<?php


namespace Modules\Ads\Builders;


Class QueryBuilder
{
    protected $from;
    protected $wheres;
    protected $orders;
    protected $limit;
    public function __construct(){

    }

    public function where($column, $operator = null, $value = null, $boolean = 'and'){
        $this->wheres[] = compact('column', 'operator', 'value', 'boolean');
        return $this;
    }

    public function orderBy($column, $direction = 'asc'){
        $this->orders[] = [
            'column' => $column,
            'direction' => strtolower($direction) == 'asc' ? 'asc' : 'desc',
        ];
        return $this;
    }
    public function from($table){
        $this->from = $table;

        return $this;
    }
    public function limit($value){
        if ($value >= 0) {
            $this->limit = $value;
        }
        return $this;
    }

    public function build(array $columns){
        $query = 'SELECT';
        if (empty($columns)){
            throw new \InvalidArgumentException("Columns must be array non empty!");
        }
        $query .= ' '.implode(', ',$columns);
        $query .= ' FROM ' . $this->from;
        if (!empty($this->wheres)){
            $query .= ' WHERE';
            foreach ($this->wheres as $index => $item){
                $query .= ' ' . $item['column'] . ' ' . $item['operator'] . ' ' . $item['value'] .($index < (count($this->wheres)-1)? ' ' . $item['boolean']:'');
            }
        }
        if (!empty($this->orders)){
            $query .= ' ORDER BY ';
            foreach ($this->orders as $index => $order){
                $query .= ' ' . $order['column'] . ' ' . $order['direction'] . ($index < (count($this->orders)-1)? ',':'');
            }
        }
        if ($this->limit > 0){
            $query .= ' LIMIT ' . $this->limit;
        }
        return $query;
    }
}