<?php

use Illuminate\Support\Facades\Log;
use Modules\Ads\Models\Option;

$g_size = function (&$item) 
{

    if(!isset($GLOBALS['module::ads::size_color_map'])) {
        $option = Option::where('key', 'module::ads::size_color_map')
            ->first();

        if($option && $option->value) {
            $sizeColorMap = json_decode($option->value, true);
            $GLOBALS['module::ads::size_color_map'] = $sizeColorMap;
        }
    }

    $sizeMap = [];
    if(isset($GLOBALS['module::ads::size_color_map']['size_map']))
        $sizeMap = $GLOBALS['module::ads::size_color_map']['size_map'];

    $itemSize = 'one size fits all';
    if(isset($item['specific_info']['Size'])) {

        $selfSize = strtolower(trim($item['specific_info']['Size']));
        if(isset($sizeMap[$selfSize]) && gettype($sizeMap[$selfSize]) == 'array' && count($sizeMap[$selfSize])) {
            $itemSize = array_shift($sizeMap[$selfSize]);
        } else {
            $itemSize = trim($item['specific_info']['Size']);
        }

    }
    return $itemSize;
};

$g_color = function (&$item) 
{

    if(!isset($GLOBALS['module::ads::size_color_map'])) {
        $option = Option::where('key', 'module::ads::size_color_map')
            ->first();

        if($option && $option->value) {
            $sizeColorMap = json_decode($option->value, true);
            $GLOBALS['module::ads::size_color_map'] = $sizeColorMap;
        }
    }

    $colorMap = [];
    if(isset($GLOBALS['module::ads::size_color_map']['color_map']))
        $colorMap = $GLOBALS['module::ads::size_color_map']['color_map'];

    $itemColor = 'Black/White';
    if(isset($item['specific_info']['Color'])) {

        $selfColor = strtolower(trim($item['specific_info']['Color']));
        if(isset($colorMap[$selfColor]) && gettype($colorMap[$selfColor]) == 'array' && !empty($colorMap[$selfColor])) {
            $colors = array_splice($colorMap[$selfColor], 0, 3); // chỉ lấy tối đa 3 màu

            if(count($colors) > 1)
                $itemColor = implode('/', $colors);
            else 
                $itemColor = array_shift($colors);

        } else {
            $itemColor = trim($item['specific_info']['Color']);
        }

    }

    return $itemColor;
};

$g_gender = function (&$item) 
{
    $gender = 'unisex';
    if(isset($item['specific_info']['Type'])) {
        $type = strtolower($item['specific_info']['Type']);
        switch ($type) {
            case 'men':
            case 'male':
                $gender = 'male';
                break;
            case 'women':
            case 'female':
                $gender = 'female';
                break;
        }
    }
    return $gender;
};

$g_ageGroup = function (&$item) 
{
    $ageGroup  = 'adult';
    $standardGroup = ['adult', 'newborn', 'infant', 'toddler', 'kids'];
    if(isset($item['specific_info']['Age'])) {
        $ageGroup = strtolower($item['specific_info']['Age']);
        if(!in_array(strtolower($ageGroup), $standardGroup)) {
            $ageGroup = 'adult';
        }
    }
    return $ageGroup;
};

return [
    'static_columns' => [
    ],
    'columns' => [
        'g:size' => $g_size,
        'g:color' => $g_color,
        'g:gender' => $g_gender,
        'g:age_group' => $g_ageGroup,
    ]
];