<?php

namespace Modules\Ads\Controllers;

use App\Helpers\ApiClient;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Route;
use Megaads\ApifyClient\Client;
use Module;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Ads\Models\Category;
use Modules\Ads\Models\CategoryGoogleMerchant;
use Modules\Ads\Models\Option;
use Modules\Ads\Models\Country;
use Modules\Ads\Models\Tag;
use Modules\Ads\Models\Warehouse;
use Modules\Ads\Models\WarehouseConfigItem;
use Modules\Ads\Services\EmailService;
use Modules\Localization\Helpers\DBConnect;
use Modules\SpreadsheetControl\Controllers\SpreadsheetController;
use Illuminate\Support\Facades\DB;

class AdsController extends Controller
{
    private $baseUrl;
    private $shopName;
    private $today;
    private $cache_times_per_day = 6;
    private $supportedTypes = [
        'xls' => 'application/vnd.ms-excel',
        'csv' => 'text/csv'
    ];
    protected $violationStatuses;
    protected $violations;
    protected $productController;
    protected $googleAdsApiToken;
    public function __construct(ProductController $productController)
    {
        Module::onView("content", function () {
            return "This is content view from Ads Module HomeController";
        }, 5);

        $this->today = date('Y-m-d');
        $this->baseUrl = URL('/');
        $shopName = explode('.', request()->getHttpHost());
        if (isset($shopName[0])) {
            $this->shopName = $shopName[0];
        }else{
            $this->shopName = 'shopod';
        }
        $this->violationStatuses = explode(',',getOption('violation_statuses','policy_violation'));
        $this->violations = [];
        $this->productController = $productController;
        $this->googleAdsApiToken = \Config::get('ads::ads.google_ads_api_token');
    }

    public function index(Request $request)
    {
        $message = config("ads::app.message");
        return view('ads::home.welcome', [
            'message' => $message,
        ]);
    }

    public function getShoppingFeed(Request $request, $idFeedSetting)
    {
        set_time_limit(60*120);
        ini_set("memory_limit", "10240M");
        $routeParameters = Route::current()->parameters();
        $idFeedSetting = $routeParameters['idFeedSetting'];
            // get setting
            $tempQuery = ApiClient::buildClient("setting_shopping_feed");
            $tempQuery->filter("id", Client::SELECTION_EQUAL, $idFeedSetting);
            $tempQuery->pageSize(-1);
            $setting = $tempQuery->first();

            if ($setting['status'] == 'successful') {
                $setting = $setting['result'];
            }
            if (empty($setting)) {
                return response('404 Không tìm thấy dữ liệu!', 404);
            }
        // check cấu hình chung
            $tempQuery = ApiClient::buildClient("option");
            $tempQuery->filter("key", Client::SELECTION_EQUAL, 'ads_setting');
            $adsSetting = $tempQuery->first();
            if ($adsSetting['status'] == 'successful') {
                $adsSetting = $adsSetting['result']['value'];
            } else {
                $adsSetting = 'instock';
            }

            // Lấy tất cả sản phẩm
            $productHadOrderSkuIds = [];

            $productFeed = $this->productController->getFeed($setting, $productHadOrderSkuIds);
            $products = $productFeed['items'];
            return $this->generateShoppingFeed($products, $setting);
    }

    public function generateShoppingFeed($products, $setting, $input = [])
    {
        $retVal = [];
        ini_set('memory_limit','10240M');
        // $shoppingFeedConfig = config('clara-ads-shopping-feed');
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $outOfStockProducts = $this->getOutOfStockProducts($prefixUrl);
        $stopedProducts = $this->getStopedProducts($prefixUrl);
        $productIdsHasOrder = $this->productController->getProductHasAnOrder($setting);
        $productIdsClone = $this->productController->getSoldProductIdsClone($setting);
        $productStopIds = $this->productController->getStopAdsProductIds($setting);
        $productsAllowAdsConfig = Option::where('key', 'products_allow_ads')
            ->first();
        $productIds = [];
        if (!empty($productsAllowAdsConfig) && !empty($productsAllowAdsConfig->value)){
            $productIds = json_decode($productsAllowAdsConfig->value);
        }
        $productImages = $this->getProductImages();
        $rowHead = [
                "id",
                "title",
                "description",
                "condition",
                "google_product_category",
                "product_type",
                "link",
                "image_link",
                "availability",
                "excluded_destination",
                "price",
                "sale_price",
                "brand",
                "mpn",
                "item_group_id",
                "gender",
                "age_group",
                "color",
                "size",
                "gtin"
        ];
        $generalConfig = \Config::get('ads::clara-ads-general');
        $shippingFee = [];
        if (isset($generalConfig['shippingFunction']) && method_exists($this,$generalConfig['shippingFunction'])){
            $countryCodes = [$countryCode];
            if (isset($generalConfig['shippingCountry'][$countryCode]) && is_array($generalConfig['shippingCountry'][$countryCode])){
                $countryCodes = array_merge($generalConfig['shippingCountry'][$countryCode],$countryCodes);
            }
            foreach ($countryCodes as $cCode){
                $rowHead[] = 'shipping';
                $country = Country::where('iso',$cCode)->first(['id']);
                if (!empty($country)){
                    $shippingFee[$cCode] = $this->{$generalConfig['shippingFunction']}($country->id);
                }
            }

        }
        $shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');

        $values = [];

        $productKeys = [];
        $notDefaultSku = [];
        $approves = $this->productController->getApproveProducts($setting);
        $eventProductIds = $this->productController->getProductIdsByTags();
        $stripeFee = doubleval(config("cart::stripe.include_fee", 0))/100;
        foreach ($products as $key => $item) {

            $item = (array) $item;

            ////////////////

            if (isset($item['sku_image_url']) && $item['sku_image_url']) {
                $item['image_url'] = $item['sku_image_url'];
            }

            if (isset($item['sku_price']) && $item['sku_price']) {
                $item['price'] = $item['sku_price'];
            }

            if (isset($item['sku_code']) && $item['sku_code']) {
                $item['sku'] = $item['sku_code'];
            }

            if (isset($item['sku_name']) && $item['sku_name'] && isset($setting['is_variant_title']) && $setting['is_variant_title']) {
                $item['name'] = $item['sku_name'];
            }

            if ($this->isSkip($item,['approves' => $approves])){
                continue;
            }
            $item['name'] = isset($approves[$item['id']])?$approves[$item['id']]:$item['name'];
            $brand = $item['sku_brand'];
            if(in_array($item['product_id'], $productIdsHasOrder )){
                $brand = 'ordered';
            }
            $this->buildImage($item,$productImages);

            if (!isset($item['sku_category_merchant_id']) || !$item['sku_category_merchant_id']) {
                continue; // break item
            }


            $availablity = $this->getAvailablity($item,['setting' => $setting,'outOfStockProducts' => $outOfStockProducts,'productsAllowAds' => $productIds,'stopedProducts' => $stopedProducts, 'productStopIds' => $productStopIds]);

            $currency = env('CURRENCY_UNIT','USD');

            $age = isset($shoppingFeedConfig['columns']['g:age_group']) ? call_user_func_array($shoppingFeedConfig['columns']['g:age_group'], [&$item]) : ' ';
            $size = isset($shoppingFeedConfig['columns']['g:size']) ? call_user_func_array($shoppingFeedConfig['columns']['g:size'], [&$item]) : ' ';
            $color = isset($shoppingFeedConfig['columns']['g:color']) ? call_user_func_array($shoppingFeedConfig['columns']['g:color'], [&$item]) : ' ';
            $gender = isset($shoppingFeedConfig['columns']['g:gender']) ? call_user_func_array($shoppingFeedConfig['columns']['g:gender'], [&$item]) : '';

            $keyOfValues = count($values);
            $productKeys[$item['product_id']][] = $keyOfValues;
            if($item['is_default'] == 0 && !in_array($item['product_id'], $notDefaultSku)) {
                $notDefaultSku[] = $item['product_id'];
            }
            $name = ucwords(strtolower($item['name']));
            $group = (isset($item["group"]) && isset($item["group"]["name"])) ? ' > ' . $item["group"]["name"] : " ";
            if (in_array($item['product_id'],$eventProductIds)){
                $group = ' > event';
            }
            if(in_array($item['product_id'], $productIdsClone )){
                $group .= ' > ordered_us';
            }
            $value = [
                $item["sku"],
                $name,
                $name,
                "new",
                $item["sku_category_merchant_id"],
                $item['category_name'] . $group,
                ($this->baseUrl . $prefixUrl . "/" . $item["sku_slug"]),
                $item["image_url"],
                'in_stock',
                $availablity != 'in_stock'?'Display ads, Shopping ads':'',
                ((isset($item['sku_high_price']) && $item['sku_high_price'] >= $item['price']) ? $item['sku_high_price'] : doubleval($item["price"])) . ' ' . $currency,
                doubleval($item["price"]) . " " . $currency,
                $brand,
                $item["sku"],
                " ",
                $gender,
                $age,
                $color,
                $size,
                $item["gtin"],
            ];
            if (!empty($shippingFee)){
                foreach ($shippingFee as $key => $shippingCosts){
                    if (isset($shippingCosts[$item['category_id']])){
                        $fee = doubleval($shippingCosts[$item['category_id']]) + round((doubleval($item["price"]) + doubleval($shippingCosts[$item['category_id']])) * $stripeFee,2);
                    }else{
                        $fee = doubleval($shippingCosts['default']) + round((doubleval($item["price"]) + doubleval($shippingCosts['default'])) * $stripeFee,2);
                    }
                    $value[] = $key . ':::' . $fee . ' ' . $currency;
                }
            }
            $values[] = $value;
        }

        foreach ($notDefaultSku as $productId) {
            if(isset($productKeys[$productId])) {
                $keys = $productKeys[$productId];
                foreach ($keys as $key) {
                    if(isset($values[$key])) {
                        $values[$key][13] = $productId; //item_group_id offset = 13
                    }
                }
            }
        }
        $googleSheet = new SpreadsheetController();
        $spreadsheetIds = explode(',',$setting['spreadsheet_id']);
        $length = 99999;
        $i = 0;
        $cacheData = [];
        foreach ($spreadsheetIds as $ssId){
            $data = array_slice($values, $i ,$length);
            array_unshift($data,$rowHead);
            $i += $length;
            $cacheData[$ssId] = count($data);
            $result = $googleSheet->updateSheet(
                [
                    'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                    'values' => $data,
                    'spreadsheetId' => $ssId,
                    'range' => $setting['spreadsheet_tab_name'],
                ]);
            $retVal[$ssId] = $result;
        }
        $this->storeRowCount($cacheData);
        return response()->json($retVal);
    }

    private function getAvailablity($item,$input = [])
    {
        $retVal = 'in_stock';
        if ($item['is_always_on_ads'] == 0){
            $setting = $input['setting'];
            $outOfStockProducts = $input['outOfStockProducts'];
            $productIds = $input['productsAllowAds'];
            $stopedProducts = $input['stopedProducts'];
            $productStopIds = $input['productStopIds'];
            if (!in_array($item['product_id'], $productIds)) {
                if (in_array($item['sku'], $stopedProducts)) {
                    $retVal = 'out_of_stock';
                } elseif (isset($outOfStockProducts[$item['product_id']])) {
                    $retVal = 'out_of_stock';
                } else {
                    if (isset($item['meta'])) {
                        $isReactAdsStatusOn = $this->isReactAdsStatusOn($item['meta']);
                        \Log::info("AdsController isReactAdsStatusOn: " . $item['product_id'] . ':' . json_encode($isReactAdsStatusOn));
                        if (!$isReactAdsStatusOn) {
                            $retVal = 'out_of_stock';
                        }
                    }
                    if (isset($item['inventory']) && isset($setting['check_inventory']) && $setting['check_inventory']) {
                        if ($item['inventory'] == 0)
                            $retVal = 'out_of_stock';
                    }
                }
            }
            if (in_array($item['product_id'], $productStopIds)){
                $retVal = 'out_of_stock';
            }
        }
        return $retVal;
    }

    public function getOutOfStockProducts($prefixUrl){
        $retVal = [];
        return $retVal;
        $isCheck =  \Config::get('ads::ads.conversion_rate_condition',false);
        if ($isCheck) {
            $outOfStockProductUrl = $this->baseUrl . $prefixUrl . '/product-react/api/product-low-rate?days=365&click_from=50&cr_to=0.015';
            $outOfStockProducts = $this->triggerSyncRequest($outOfStockProductUrl);
            if (isset($outOfStockProducts['result'])) {
                $retVal = $outOfStockProducts['result'];
            }
        }
        return $retVal;
    }

    public function getPageFeed(Request $request, $idFeedSetting)
    {

        set_time_limit(60*120);
        $all = $request->all();
        $routeParameters = Route::current()->parameters();
        $idFeedSetting = $routeParameters['idFeedSetting'];

            // get setting
            $tempQuery = ApiClient::buildClient("setting_shopping_feed");
            $tempQuery->filter("id", Client::SELECTION_EQUAL, $idFeedSetting);
            $tempQuery->pageSize(-1);
            $setting = $tempQuery->first();

            if ($setting['status'] == 'successful') {
                $setting = $setting['result'];
            }
            if (empty($setting)) {
                return response('404 Không tìm thấy dữ liệu!', 404);
            }
            $setting = array_merge($setting,$all);
            return $this->generatePageFeed($setting);

    }

    function generatePageFeed($setting)
    {
        $retVal = ['status' => 'fail'];
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl =  '/' . $locale;
        }
        $values = [
            [
                "Page URL", "Custom label"
            ]
        ];
        $input = [
            'prefixUrl' => $prefixUrl,
            'setting' => $setting,
            'values' => $values

        ];
        if (method_exists($this,$this->snakeToCamel($setting['type'],'build'))){
            $retVal =  $this->{$this->snakeToCamel($setting['type'],'build')}($input);
        }
        return response()->json($retVal);
    }



    public function getRemarketingFeed(Request $request, $idFeedSetting)
    {

        set_time_limit(60*120);

        $routeParameters = Route::current()->parameters();
        $idFeedSetting = $routeParameters['idFeedSetting'];
        // get setting
        $tempQuery = ApiClient::buildClient("setting_shopping_feed");
        $tempQuery->filter("id", Client::SELECTION_EQUAL, $idFeedSetting);
        $tempQuery->pageSize(-1);
        $setting = $tempQuery->first();

        if ($setting['status'] == 'successful') {
            $setting = $setting['result'];
        }
        if (empty($setting)) {
            return response('404 Không tìm thấy dữ liệu!', 404);
        }

        $productController = new ProductController();
        $setting['joinCategory'] = 1;
        $products = $productController->getProducts($setting,['product.id','product.sku','product.name','product.slug','product.price','product.high_price','product.image_url','category.name as categoryName']);
        $metas = $productController->getProductMeta();
        return $this->generateRemarketingFeed($products, $metas, $setting);

    }

    public function generateRemarketingFeed($products,$metas, $setting)
    {
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        if ($prefixUrl == '' && $isLocalization && $locale !== '') {
            $prefixUrl =  '/' . $locale;
        }
        $values = [
            [
                "ID", "Item title", "Final URL", "Image URL", "Item description", "Price", "Sale Price", "Item category"
            ]
        ];
        foreach ($products as $item) {

            $item = (array) $item;

            if(isset($metas[$item['id']])) {
                $isReactAdsStatusOn = $this->isReactAdsStatusOn($metas[$item['id']]);
                if(!$isReactAdsStatusOn) continue;
            }

            $currency = env('CURRENCY_UNIT','USD');

            $values[] = [
                $item['sku'],
                $item['name'],
                $this->baseUrl . $prefixUrl . '/' . $item['slug'],
                $item['image_url'],
                $item['name'],
                (($item['high_price'] >= $item['price']) ? $item['high_price'] : $item['price']) . ' ' . $currency,
                $item['price'] . ' ' . $currency,
                $item['categoryName'],
            ];
        }
        $googleSheet = new SpreadsheetController();
        return $googleSheet->pushToSheet(
            [
                'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                'values' => $values,
                'spreadsheetId' => $setting['spreadsheet_id'],
                'range' => $setting['spreadsheet_tab_name'],
            ]
        );

    }

    public function refreshFeeds() /* deprecated */
    {
        set_time_limit(60*120);
        // Lấy tất cả setting feed
        $tempQuery = ApiClient::buildClient("setting_shopping_feed");
        $tempQuery->pageSize(-1);
        $settings = $tempQuery->get();

        if ($settings['status'] == 'successful') {
            $settings = $settings['result'];
            foreach ($settings as &$setting) {
                $setting['res_instock'] = ($this->callCurl($setting['url'] . '?refresh=1')) ? true : false;
                $setting['res_outstock'] = ($this->callCurl($setting['out_of_stock_url'] . '?refresh=1')) ? true : false;
            }
        }

        return [
            'status' => 'successful',
            'result' => $settings
        ];
    }

    function callCurl($url) /* deprecated */
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
        ));

        $res = curl_exec($curl);
        curl_close($curl);

        return $res;
    }

    static public function getAdsOption($itemMeta)
    {
        if(gettype($itemMeta) == 'object') {
            $itemMeta = $itemMeta->toArray();
        }

        $productAdsStatus = null;
        $productAdsOption = array_filter($itemMeta, function ($meta) {
            return $meta['key'] == 'ads_option';
        });

        if (count($productAdsOption)) {
            $productAdsOption = array_pop($productAdsOption);
            if ($productAdsOption && $productAdsOption['value']) {
                $productAdsStatus = $productAdsOption['value'];
            }
        }

        return $productAdsStatus;
    }

    function isReactAdsStatusOn($itemMeta) {
        $adsStatus = true;
        $productReactAdsStatus = array_filter($itemMeta, function ($meta) {
            return $meta['key'] == ProductReactConfigService::ADS_STATUS_PRODUCT;
        });
        
        if($productReactAdsStatus){
            $productReactAdsStatus = array_shift($productReactAdsStatus);
            if ($productReactAdsStatus && $productReactAdsStatus['value']) {
                $productReact = json_decode($productReactAdsStatus['value'], true);
                if(isset($productReact['status']) && $productReact['status'] == 0) {
                    $adsStatus = false;
                }
            }
        }

        return $adsStatus;
    }


    function getCacheFolder() /* deprecated */
    {
        date_default_timezone_set("Asia/Bangkok");
        $duration = ceil(24 / $this->cache_times_per_day);
        if ($duration == 24 || $duration <= 1) return $this->today;

        // Tính xem đang trong khoảng thời gian nào
        /**
         * this_time / duration = cache_time
         */
        $thisTime = date('H');
        $cacheTime = ceil($thisTime / $duration);

        return intval($cacheTime);
    }

    private function returnFile($feedFilePath, $supportedTypes = null)
    {
        $fp = fopen($feedFilePath, 'rb');
        $ext = pathinfo($feedFilePath, PATHINFO_EXTENSION);

        if (!$supportedTypes)
            $supportedTypes = $this->supportedTypes;

        $header = mime_content_type($feedFilePath);

        if (array_key_exists($ext, $supportedTypes)) {
            $header = $supportedTypes[$ext];
        }

        header("Content-Type: $header");
        header("Content-Length: " . filesize($feedFilePath));

        fpassthru($fp);
        exit();
    }

    public function initMerchatCategory(){
        $updatedCount = 0;
        $createdCount = 0;
        Category::where('type', '=', Category::TYPE_PRODUCT)->chunk(100,function ($categories) use (&$updatedCount,&$createdCount){
            foreach ($categories as $category){
                if (!empty($category->id)) {
                    $merchant = CategoryGoogleMerchant::where('category_id', '=', $category->id)->first();
                    $treeTitle = '';
                    $breadcrumbs = json_decode($category->breadcrumb);
                    if (!empty($breadcrumbs)) {
                        foreach ($breadcrumbs as $item) {
                            $treeTitle .= $item->name . '/';
                        }
                        $treeTitle = substr($treeTitle, 0, -1);
                    }else{
                        $treeTitle = $category->name;
                    }
                    if (!empty($merchant->id)) {
                        if (strcmp($treeTitle,$merchant->name) != 0){
                            $updatedCount ++;
                            $merchant->name = $treeTitle;
                            $merchant->save();
                        }
                    } else {
                        $createdCount++;
                        $obj = new CategoryGoogleMerchant();
                        $obj->category_id = $category->id;
                        $obj->name = $treeTitle;
                        $obj->save();
                    }
                }
            }
        });
        return response()->json([
            'status' => 'done',
            'message' => "Create $createdCount, update $updatedCount"
        ]);
    }
    private function updateProductDisapproved($skus = []){
        $retVal = true;
        try{
            \Log::info("UpdateProductDisapproved:" . json_encode($skus));
            $locales = getModuleLocale();
            foreach ($locales as $locale){
                if (!$locale['enable']) {
                    continue;
                }
                $connection = DBConnect::connect($locale['locale']);
                $connection->table('product')->whereIn('sku', $skus)->update(['is_violation' => 1, 'updated_at' => date('Y-m-d H:i:s')]);
            }
        }catch (Exception $ex){
            print_r($ex->getTraceAsString());
            $retVal = false;
        }
        return $retVal;

    }
    private function getProductDisapproved($status, $violationStatuses = []){
        $retVal = '';
        $isDisapproved = false;
        if (!empty($status->getItemLevelIssues())) {
            foreach ($status->getItemLevelIssues() as $issue) {
                if ($issue->getServability() == 'disapproved') {
                    $this->violations[] = $issue->getCode();
                    if (in_array($issue->getCode(), $violationStatuses)) {
                        $isDisapproved = true;
                        break;
                    }
                }
            }
            if ($isDisapproved){
                $retVal = substr($status->getProductId(), 13);
            }
        }
        return $retVal;
    }

    private function getListDisapproved($violationStatuses){
        set_time_limit(60*60*10);
        $input = [];
        $input['scopes'] = \Google_Service_ShoppingContent::CONTENT;
        $input['authPath'] = base_path().'/app/Modules/SpreadsheetControl/AuthConfig/auth-merchants.json';
        $input['credentialsPath'] = base_path().'/app/Modules/SpreadsheetControl/AuthConfig/credentials-merchants.json';
        $input['authCode'] = '4/rQEhNKOPbtya6obEPBwpH5eqcvJ3wcz_VsnUv5TT2dnaoUeEPlpIgEAuP7FPDJAXaUmRNxA-NJmulEzTC6Nb9fA';
        $googleSheet = new SpreadsheetController();
        $client = $googleSheet->getClient($input);
        $service = new \Google_Service_ShoppingContent($client);
        $parameters = ['maxResults' => 250];
        $merchant_id = getOption('merchant_id','398409240');
        $count = 0;
        $try = 0;
        do {
            $productCodes = [];
            if($try == 3){
                \Log::info("UpdateProductDisapproved Break: " . $count);
                break;
            }
            try{
                $statuses = $service->productstatuses->listProductstatuses(
                    $merchant_id, $parameters);
                foreach ($statuses->getResources() as $status) {
                    $code = $this->getProductDisapproved($status, $violationStatuses);
                    if (!empty($code)){
                        $productCodes[] = $code;
                        $count ++;
                    }
                }
                if (count($productCodes) > 0){
                    $this->updateProductDisapproved($productCodes);
                }
                $parameters['pageToken'] = $statuses->nextPageToken;
                $try = 0;
            }catch (\Exception $ex){
                $client = $googleSheet->getClient($input);
                $service = new \Google_Service_ShoppingContent($client);
                $try ++;
            }
        } while (!empty($parameters['pageToken']));
        \Log::info("UpdateProductDisapproved Finish: " . $count);
        return $count;
    }
    public function cronUpdateProductDisapproved(){
        set_time_limit(0);
        $count = $this->getListDisapproved($this->violationStatuses);
        return response()->json(["status" => "successful","message" => $count]);
    }
    public function exportCustomer(){
        $data = $this->getCustomerData();
        Excel::create('Customer_List_'.env('APP_LOCALE').'_'. date('Y-m-d'), function ($excel) use ($data) {
            // Set the title
            $excel->setTitle('Customer List'. env('APP_LOCALE'));

            // Chain the setters
            $excel->setCreator('Megaads')
                ->setCompany('Megaads');

            $excel->sheet('customer', function ($sheet) use ($data) {

                foreach ($data as $value) {
                    $sheet->appendRow($value);
                }
            });
        })->download('csv');
    }

    private function getCustomerData() {
        ini_set("memory_limit", "3072M");
        $locales = getModuleLocale();
        $customerList = [['Email', 'First Name', 'Last Name', 'Country', 'Zip', 'Phone']];
        foreach ($locales as $locale){
            if (!$locale['enable']) {
                continue;
            }
            $connection = DBConnect::connect($locale['locale']);
            $query = $connection->table('order as o')
                ->join(DB::raw('`' . env('DB_DATABASE_CUSTOMER', 'printerval_customer') . '`.`customer` as sb_c'),'c.id','=','o.customer_id')
                ->join('countries as ct','ct.id','=','c.country_id')
                ->where('payment_status','=','PAID')
                ->groupBy('c.id');
            $customers = $query->get(['c.email','c.full_name','c.phone','o.zip_code','ct.iso','ct.phonecode']);
            $customerList = $this->buildCustomerData($customers,$customerList);
        }
        return $customerList;

    }

    private function buildCustomerData($customers, $customerList){
        foreach ($customers as $item){
            $fullName = explode(' ',$item->full_name);
            $firstName = $fullName[count($fullName) -1];
            unset($fullName[count($fullName) -1]);
            $lastName = implode(' ',$fullName);
            if (empty(trim($lastName))){
                $lastName = $firstName;
            }
            $data = [$item->email, $firstName, $lastName, $item->iso, $item->zip_code, $item->phonecode.$item->phone];
            $isContinue = false;
            foreach ($data as $value){
                if (empty($value)){
                    $isContinue = true;
                    break;
                }
            }
            if ($isContinue){
                continue;
            }
            $customerList[] = [$item->email, $firstName, $lastName, $item->iso, $item->zip_code, $item->phonecode.$item->phone];
        }
        return $customerList;
    }

    private function buildImage(&$item, $productImages){
        if (isset($productImages[$item['sku']])){
            $item['image_url'] = $productImages[$item['sku']];
        }
        $item['image_url'] = str_replace(',','%2C',$item['image_url']);

    }
    private function getProductImages(){
        $retVal = [];
        $images = DB::table('ads_product_sku')
            ->where('image_url','!=', '')
            ->whereNotNull('image_url')
            ->get(['sku','image_url']);
        foreach ($images as $image){
            $retVal[$image->sku] = $image->image_url;
        }
        return $retVal;
    }

    private function getStopedProducts($prefixUrl){
            $retVal = [];
            $url = $this->baseUrl . $prefixUrl . '/auto-price/get-stop-ads-product';
            $result = $this->triggerSyncRequest($url);
            if (isset($result['data'])){
                $retVal = $result['data'];
            }
            return $retVal;
    }

    private function getDescription($productId, $skuId = 0){
        $retVal = '';
       if (\Module::isActive('ConfigDescription')){
           $configDescription = new \Modules\ConfigDescription\Controllers\HomeController();
           $retVal = $configDescription->getVariantDescription(['product_id' => $productId, 'sku_id' => $skuId]);
       }
        return $retVal;
    }

    public function warningMissingProduct(){
        $retVal = [

        ];
        $data = [];
        $sheets = \Cache::get('shopping::row::count');
        foreach ($sheets as $key => $value){
            $spreadSheet = new SpreadsheetController();
            $count = $spreadSheet->countRow(
                [
                    'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                    'spreadsheetId' => $key,
                    'range' => 'Sheet1',
                ]
            );
            if ($count != $value){
                $data[] = ['url' => 'https://docs.google.com/spreadsheets/d/'.$key,'old' => $value, 'new' => $count];
            }
        }
        if (!empty($data)){
            $emailService = new EmailService();
            $subject = env('APP_NAME') . ' missing shopping product';
            $retVal = $emailService->sendWarningEmail($data, $subject, 'xuanlap93@gmail.com');
        }

        return response()->json($retVal);
    }

    private function storeRowCount($data = []){
        $keyCache = 'shopping::row::count';
        $cacheData = \Cache::get($keyCache);
        if (!empty($cacheData)){
            foreach ($data as $key => $count){
                $cacheData[$key] = $count;
            }
        }else{
            $cacheData = $data;
        }
        \Cache::put($keyCache, $cacheData, 24 * 60 * 7);
    }

    public function getDefaultShippingFee($countryId) {
        $country = Country::find($countryId);

        $config = (array) $this->getShippingConfig();

        $locationCode = $country && isset($config[$country->iso]) ? $country->iso : 'default';
        $configByContry = (array) $config[$locationCode];
        $result = [];
        if (isset($configByContry["standard"])) {
            $configShippingFeeByLocation = (array) $configByContry["standard"];
            $result["default"] = $configShippingFeeByLocation["default_shipping_fee"];
            foreach ($configShippingFeeByLocation["group"] as $key => $configGroup) {
                $arrayConfigGroup = (array) $configGroup;
                if (isset($arrayConfigGroup["category"])) {
                    foreach ($arrayConfigGroup["category"] as $i => $item) {
                        $result[$item] = $arrayConfigGroup["default_shipping_fee"];
                    }
                }
            }
        }
        return $result;
    }

    public function getDefaultShippingFeeV2($countryId) {
        $warehouse = Warehouse::with("warehouseShippingConfigs")
                ->whereHas("warehouseShippingConfigs")
                ->where('is_active', 1)
                ->where("country_id", $countryId)
                ->where("printing_code", "default")
                ->first();
        if (!$warehouse) {
            $warehouse = Warehouse::with("warehouseShippingConfigs")
                ->where('is_active', 1)
                ->where('country_id', -1)
                ->where("printing_code", "default")
                ->first();
        }
        $result = [];
        if ($warehouse) {
            for ($index = 0; $index < count($warehouse->warehouseShippingConfigs); $index++) {
                $warehouseConfig = $warehouse->warehouseShippingConfigs[$index];
                if ($warehouseConfig->type == 'standard') {
                    $warehouseConfigItems = WarehouseConfigItem::where("warehouse_config_id", $warehouseConfig->id)->get();
                    foreach ($warehouseConfigItems as $key => $value) {
                        if ($value->type == "default") {
                            $result["default"] = $value->default_shipping_fee;
                        } else {
                            $categoryIds = explode(",", $value->apply_cate);
                            foreach ($categoryIds as $i => $item) {
                                $result[$item] = $value->default_shipping_fee;
                            }
                        }
                    }
                }
            }
        }
        return $result;
    }

    private function getShippingConfig() {
        $config = Option::where("key", "shipping_fee_config")->first();
        $config = json_decode($config->value);
        return $config;
    }

    public function emailMarketingFeed(Request $request){
        $input = $request->all();
        $filter = [];
        if (array_key_exists('idFrom',$input)){
            $filter['id_from'] = $input['idFrom'];
        }
        if (array_key_exists('idTo',$input)){
            $filter['id_to'] = $input['idTo'];
        }
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl =  '/' . $locale;
        }
            $productController = new ProductController();
            $products = $productController->filterProduct($filter,['id','sku','price','high_price','name','slug','image_url','description']);
            $productFeeds = [];
            foreach ($products as $item){
                $feed = [
                    'id' => $item->sku,
                    'title' => $item->name,
                    'description' => !empty($item->description)?$item->description:$item->name,
                    'price' => $item->price,
                    'image_url' => $item->image_url,
                    'url' => $this->baseUrl . $prefixUrl . '/' . $item->slug . '-p' . $item->id
                ];
                $productFeeds[] = $feed;
            }
        return response()->json($productFeeds);
    }

    public function adjustConversion(Request $request){
        ini_set("memory_limit", "1024M");
        set_time_limit(120);
        $range = $request->get('sheetTabName');
        $spreadsheetId = $request->get('sheetId');
        $conversionName = $request->get('conversionName','Purchase');
        if (empty($range) || empty($spreadsheetId)){
            return response()->json(["status" => "fail", "message" => "sheetTabName,sheetId must enter!"]);
        }
        $locales = getModuleLocale();
        $data = [];
        foreach ($locales as $locale){
            if (!$locale['enable']) {
                continue;
            }
            $connection = DBConnect::connect($locale['locale']);
            $query = $connection->table('order as o')
                ->join('order_meta as m','o.id','=','m.order_id')
                ->where('o.payment_status','=','PAID')
                ->where('o.status','=','CANCELED')
                ->where('m.key','=','from')
                ->where('m.value','=','adwords')
                ->where('o.created_at','>=',date('Y-m-d 00:00:00',strtotime('-2 day')))
                ->where('o.created_at','<=',date('Y-m-d 23:59:59',strtotime('-2 day')));
            $orders = $query->get(['o.code','o.created_at']);
            $data = array_merge($data,$orders->toArray());
        }
        $values = $this->buildConversion($data, $conversionName);
        $googleSheet = new SpreadsheetController();
        return $googleSheet->pushToSheet(
            [
                'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                'values' => $values,
                'spreadsheetId' => $spreadsheetId,
                'range' => $range,
            ]);

    }
    private function buildConversion($data, $conversionName){
        $retVal = [
            ['### INSTRUCTIONS ###'],
            ['# IMPORTANT: Remember to set the TimeZone value in the "parameters" row and/or in your Adjustment Time column'],
            ['# Order ID should not contain personally identifiable information like name, email or phone number'],
            ['# For instructions on how to set your timezones, visit http://goo.gl/T1C5Ov'],
            [''],
            ['### TEMPLATE ###'],
            ['Parameters:TimeZone=+0700;'],
            ['Order ID', 'Conversion Name', 'Adjustment Time', 'Adjustment Type', 'Adjusted Value', 'Adjusted Value Currency']
        ];
        foreach ($data as $item) {
            $adjustmentTime = date('Y-m-d H:i:s',strtotime('+1 day',strtotime($item->created_at)));
            $retVal[] = [$item->code, $conversionName, $adjustmentTime, 'RETRACT', '', ''];
        }
        return $retVal;
    }

    private function buildCategoryPageFeed($input = []){
        ini_set("memory_limit", "1024M");
        $categories = Category::where('type',Category::TYPE_PRODUCT)->where('is_hidden',0)->get(['name','slug']);
        $prefixUrl = $input['prefixUrl'];
        $values = $input['values'];
        foreach ($categories as $item){
            $values[] = [$this->baseUrl . $prefixUrl . '/' . $item->slug,$item->name];
        }
        $googleSheet = new SpreadsheetController();
        return $googleSheet->pushToSheet(
            [
                'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                'values' => $values,
                'spreadsheetId' => $input['setting']['spreadsheet_id'],
                'range' => $input['setting']['spreadsheet_tab_name'],
            ]);
    }

    private function buildTagPageFeed($input = []){
        ini_set("memory_limit", "1024M");
        $tags = Tag::get(['title','slug']);
        $prefixUrl = $input['prefixUrl'];
        $values = $input['values'];
        foreach ($tags as $item){
            $values[] = [$this->baseUrl . $prefixUrl . '/' . $item->slug,$item->title];
        }
        $googleSheet = new SpreadsheetController();
        return $googleSheet->pushToSheet(
            [
                'authCode' => '4/Ajm2xQHHJJpPgKGl6cq-A7cfarCCU8meTr6xnsXcm1U',
                'values' => $values,
                'spreadsheetId' => $input['setting']['spreadsheet_id'],
                'range' => $input['setting']['spreadsheet_tab_name'],
            ]);
    }

    private function buildPageFeed($input = []){
        $setting = $input['setting'];
        $date = new \DateTime("now", new \DateTimeZone('Asia/Ho_Chi_Minh') );
        $toDate = $date->format('Y-m-d H:i:s');
        $date->add(\DateInterval::createFromDateString('-3 hour'));
        $fromDate = $date->format('Y-m-d H:i:s');
        if (!array_key_exists('updated_from', $setting)){
            $setting['updated_from'] = $fromDate;
        }
        if (!array_key_exists('updated_to', $setting)){
            $setting['updated_to'] = $toDate;
        }
        $productController = new ProductController();
        $metas = $productController->getProductMeta();
        $productController->getProducts($setting,['product.id','product.name','product.slug'],function($products) use ($metas, $input, &$retVal){
            $prefixUrl = $input['prefixUrl'];
            $values = [];
            $lastId = 0;
            foreach ($products as $item) {
                $item = (array)$item;
                if(isset($metas[$item['id']])) {
                    $isReactAdsStatusOn = $this->isReactAdsStatusOn($metas[$item['id']]);
                    if(!$isReactAdsStatusOn) continue;
                }
                $item['url'] = $this->baseUrl . $prefixUrl . '/' . $item['slug'] . '-p' . $item['id'];
                $values[] = [
                    'url' => $item['url'],
                    'label' => $item['name']
                ];
                $lastId = $item['id'];
            }
            $url = \Config::get('ads::ads.google_ads_api_url',''). '/asset/set-page-feed';
            $params = [
                'customerId' => $input['setting']['customerId'],
                'products' => $values,
                'assetSetResourceName' => $input['setting']['assetSetResourceName']
            ];
            $this->triggerSyncRequest($url,'POST', $params, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
            \Log::info("pageFeed: ". $lastId);
        });
        return "Inprocessing";
    }

    private function snakeToCamel($string, $fn = ''){
        $retVal = '';
        $str = str_replace('_', '', ucwords($string, '_'));
        if (!empty($fn)){
            $retVal = $fn.$str;
        }
        return $retVal;
    }

    private function isSkip($item,$input = [])
    {
        $retVal = false;
        $approves = $input['approves'];
        if (!isset($approves[$item['id']])){
            $retVal = true;
        }elseif($item['sku_slug'][0] == '-'){
            $retVal = true;
        }elseif($item['price'] <= 0){
            $retVal = true;
        }elseif(empty(trim($item['image_url'])) || strpos($item['image_url'],'http')){
            $retVal = true;
        }elseif(strlen($item['sku_slug']) > 255){
            $retVal = true;
        }
        return $retVal;
    }

    public function getFeedFile($type,$fileName){
        return null;
        ob_clean();
        $routeParameters = Route::current()->parameters();
        $locale = env('APP_LOCALE');
        if (empty($locale)){
            $locale = 'us';
        }
        if (array_key_exists('type',$routeParameters)){
            $type = $routeParameters['type'];
        }
        if (array_key_exists('fileName',$routeParameters)){
            $fileName = $routeParameters['fileName'];
        }
        $pathToFile = base_path() . "/public/feeds/$locale/$type/$fileName";
        return response()->file($pathToFile);
    }

    public function uploadFileToGoogleCloudStorage(Request $request){
        set_time_limit(-1);
        $input = $request->all();
        $filePath = $input['filePath'];
        $localFilePath = public_path($filePath);
        $gcsFilePath = $filePath;
        $object = uploadToGcs($localFilePath, $gcsFilePath);
        return response()->json(['url' => url($filePath),'result' => $object]);

    }

}
