<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Models\AdsProductPerformance;


class AdsProductPerformanceController extends Controller
{
    public function findLatest(Request $request) {
        set_time_limit(5 * 3600);
        
        $productIds = $request->get('product_ids');
        $items = AdsProductPerformance::whereIn('id', explode(',', $productIds))->orderBy('id', 'desc')->get();

        $result = [];
        foreach ($items as $item) {
            if (!isset($result[$item->product_id])) {
                $result[$item->product_id] = $item;
            }
        }

        return [
            'status' => 'successful',
            'result' => array_values($result)
        ];
    }
}