<?php

namespace Modules\Ads\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Models\ProductReactBySource;
use Modules\Ads\Controllers\ProductReactService;

class ApiProductReactBySourceService extends ProductReactService
{
    public function findProductLowRate(Request $request) {
        set_time_limit(1800);
        //product_id_from, product_id_to, time_from, time_to
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $query = ProductReactBySource::select('*', DB::raw('sum(conversion) as total_conversion'), DB::raw('sum(click) as total_click'));
        if ($request->has('product_id_from')) {
            $query->where('product_id', '>=', $request->get('product_id_from'));
        }

        if ($request->has('product_id_to')) {
            $query->where('product_id', '<=', $request->get('product_id_to'));
        }

        if ($request->has('time_from')) {
            $query->where('created_at', '>=', $request->get('time_from'));
        }

        if ($request->has('time_to')) {
            $query->where('created_at', '<=', $request->get('time_to'));
        }

        if ($request->has('source')) {
            $query->where('source', '=', $request->get('source'));
        }
        $query->groupBy('product_id');
        $query->having('total_click', '>', 0);
        $query->having(DB::raw('total_conversion / total_click'), '<=', 0.01);

        $retVal['result'] = $query->get();

        return $retVal;
    }

}
