<?php

namespace Modules\Ads\Controllers\Api;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Services\PendingProductService;

class PendingProductController extends Controller
{
    protected $pendingProductService;
    public function __construct(PendingProductService $pendingProductService)
    {
        $this->pendingProductService = $pendingProductService;
    }

    public function getProducts(Request $request)
    {
        return $this->pendingProductService->getProducts($request);
    }

    public function getGoogleAdsIssues(Request $request)
    {
        $response = [
            'status' => 'fail'
        ];

        $result = $this->pendingProductService->getGoogleAdsIssues($request);
        if (!empty($result)) {
            $response = [
                'status' => 'successful',
                'result' => $result
            ];
        }
        return $response;
    }
    
}
