<?php

namespace Modules\Ads\Controllers;

use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\AwinService;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;


class AwinController extends Controller
{
    private $merchantProductService;
    private $awinProductService;
    public function __construct(MerchantProductService $merchantProductService, AwinService $awinProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->awinProductService = $awinProductService;
    }
    public function cronUpdateFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        if(array_key_exists('trend',$input)){
         return $this->buildProductByIds($input);
        }
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = [
            'status' => 'ACTIVE',
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1
        ];
        if (array_key_exists('social_type',$input)){
            $filter['social_status'] = 1;
            $filter['social_type'] = $input['social_type'];
        }else{
            $filter['approve_advertising'] = 1;
        }
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
        }
        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('sold_from',$input)){
            $filter['sold_from'] = $input['sold_from'];
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(',',$input['ids']);;
        }
        if(array_key_exists('categoryIds',$input)){
            $filter['categoryIds'] = explode(',',$input['categoryIds']);;
        }
        $filter['columns'] = [
                // ORIGIN
                'product.id',
                'product.slug', 'product.brand_id', 'product.image_url',
                'product.description',
                'product.status', 'product.approve_advertising',
                'product.is_trademark',
                'product.gtin',
                'product.is_always_on_ads',
                'product.actor_id',
                'product.created_at',
                'product.sold',
                // SKU
                'product_info.name as sku_name',
                'product_info.variants as sku_specific_info',
                'product_info.brand as sku_brand',
                'product.sku as sku_code',
                'product_info.slug as sku_slug',
                'product_info.price',
                'product_info.inventory',
                'product_info.high_price',
                'product_info.category_merchant_id as sku_category_merchant_id',
                'product_info.product_sku_id',
                'product_info.product_sku_id as sku_id',
                'product_info.is_default',
                'product_n_category.category_id as category_id',
                'product.name as title_replacement',
        ];

        $query = $this->merchantProductService->buidFilter($filter);
        $products = $query->get();
        $input['prefixUrl'] = $prefixUrl;
        $input['country'] = $countryCode;
        $count = $this->awinProductService->buildProducts($products, $input);
        $this->awinProductService->store($input, $locale);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    private function buildProductByIds($input){
        $retVal = [];
        if (array_key_exists('sellerId',$input)){
            $ids =  $this->awinProductService->getProductBySellerId($input);
        }else{
            $ids =  $this->awinProductService->getProductTrend($input);
        }
        $param = [
            'fileName' =>$input['fileName'],
            'ignore_updated_at' =>'1',
//            'append' =>'1',
//            'truncate' =>'1',
            'rename' =>'1',
        ];
        if (array_key_exists('mga_source',$input)){
            $param['mga_source'] = $input['mga_source'];
        }
        if (array_key_exists('truncate',$input)){
            $param['truncate'] = $input['truncate'];
        }
        if (array_key_exists('append',$input)){
            $param['append'] = $input['append'];
        }
        if (array_key_exists('utm_cam',$input)){
            $param['utm_cam'] = $input['utm_cam'];
        }
        $index = 0;
        foreach (array_chunk($ids,600) as $aPart) {
            if ($index == 1){
                unset($param['append']);
                unset($param['truncate']);
            }
            $ids = implode(',',$aPart);
            $url = route('ads::ads:awin::feed',$param);
            $url = $url.'&ids='.$ids;
            $retVal = $this->triggerSyncRequest($url,'GET');
            $index ++;
        }
        return response()->json(['status' => 'successful', 'data' => $retVal]);
    }

    public function cronRemoveProduct(Request $request){
        $start = microtime(true);
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d 00:00:00",strtotime('-1 day'));
                }
            }
        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d 00:00:00",strtotime('-1 day'));
            }
        }
        \Log::info("Awin: " . json_encode($input));
        $filter['columns'] = [
            // ORIGIN
            'product.id'
        ];
        $query = $this->awinProductService->buildDeleteQuery($filter);
        $chunkCount = 100000;
        $count = 0;
        $query->chunk($chunkCount, function($products) use($prefixUrl,$countryCode, $input, &$count, $start, $locale){
            \Log::info("Awin remove count: " . $count ." " . (microtime(true) - $start));
            $input['prefixUrl'] = $prefixUrl;
            $input['country'] = $countryCode;
            $data = $this->awinProductService->buildRemoveProducts($products, $input);
            $count += count($data);
            $input['removeProducts'] = $data;
            $this->awinProductService->remove($input, $locale);
        });
        $totalTime = microtime(true) - $start;
        \Log::info("Awin process remove time miliseconds: " .json_encode($input). $totalTime);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    public function cleanFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $input['prefixUrl'] = $prefixUrl;
        $input['country'] = $countryCode;
        $count = $this->awinProductService->clean($input, $locale);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

}
