<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\DB;
use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\BingProductService;
use Modules\Ads\Controllers\Service\BingService;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Models\Product;


class BingController extends Controller
{
    private $merchantProductService;
    private $bingProductService;
    private $bingService;
    private $ftpConfig = [];
    private $merchantServiceConfig;
    private $queue;
    private $languages;
    public function __construct(MerchantProductService $merchantProductService,BingService $bingService, BingProductService $bingProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->bingProductService = $bingProductService;
        $this->bingService = $bingService;
        $config = DB::table('option')->where('key','bing::ftp')->first(['value']);
        if (!empty($config) && !empty($config->value)){
            $this->ftpConfig = json_decode($config->value,true);
        }
        $this->merchantServiceConfig = \Config::get('ads::ads.merchant_service',[]);
        $this->queue = \Config::get('ads::ads.queue',[]);
        $this->languages = \Config::get('ads::clara-ads-general.languages',[]);
    }
    public function cronUpdateFeed(Request $request){
        $start = microtime(true);
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = [
            'status' => 'ACTIVE',
            'approve_advertising' => 1,
            'advertising_status' => 1,
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1
        ];
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
        }
        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('sold_from',$input)){
            $filter['sold_from'] = $input['sold_from'];
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(',',$input['ids']);;
        }
        if(array_key_exists('categoryIds',$input)){
            $filter['categoryIds'] = explode(',',$input['categoryIds']);;
        }
        \Log::info("Bing: " . json_encode($input));
        $filter['columns'] = [
                // ORIGIN
                'product.id',
                'product.slug', 'product.brand_id', 'product.image_url',
                'product.description',
                'product.status', 'product.approve_advertising',
                'product.is_trademark',
                'product.gtin',
                'product.is_always_on_ads',
                'product.actor_id',
                'product.created_at',
                'product.sold',
                // SKU
                'product_info.name as sku_name',
                'product_info.variants as sku_specific_info',
                'product_info.brand as sku_brand',
                'product_info.sku as sku_code',
                'product_info.slug as sku_slug',
                'product_info.price',
                'product_info.inventory',
                'product_info.high_price',
                'product_info.category_merchant_id as sku_category_merchant_id',
                'product_info.product_sku_id',
                'product_info.product_sku_id as sku_id',
                'product_info.is_default',
                'product_n_category.category_id as category_id',
                'product.name as title_replacement',
        ];
        $query = $this->merchantProductService->buidFilter($filter);
        $chunkCount = 100000;
        $count = 0;
        $query->chunk($chunkCount, function($products) use($prefixUrl,$countryCode, $input, &$count, $start, $locale){
            \Log::info("Bing count: " . $count ." " . (microtime(true) - $start));
            $input['prefixUrl'] = $prefixUrl;
            $input['country'] = $countryCode;
            $data = $this->bingService->buildProducts($products, $input);
            $count += $data;
            $this->bingService->store($input, $locale);
        });
        $totalTime = microtime(true) - $start;
        \Log::info("Bing process time miliseconds: " .json_encode($input). $totalTime);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    public function cleanFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $input['prefixUrl'] = $prefixUrl;
        $input['country'] = $countryCode;
        $this->bingService->clean($input, $locale);
    }

    public function cronRemoveProduct(Request $request){
        $start = microtime(true);
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
                }
            }
        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d H:i:s",strtotime('-1 day'));
            }
        }
        \Log::info("Bing: " . json_encode($input));
        $filter['columns'] = [
            // ORIGIN
            'product.id'
        ];
        $query = $this->bingService->buildDeleteQuery($filter);
        $chunkCount = 100000;
        $count = 0;
        $query->chunk($chunkCount, function($products) use($prefixUrl,$countryCode, $input, &$count, $start, $locale){
            \Log::info("Bing remove count: " . $count ." " . (microtime(true) - $start));
            $input['prefixUrl'] = $prefixUrl;
            $input['country'] = $countryCode;
            $data = $this->bingService->buildRemoveProducts($products, $input);
            $count += count($data);
            $input['removeProducts'] = $data;
            $this->bingService->remove($input, $locale);
        });
        $totalTime = microtime(true) - $start;
        \Log::info("Bing process remove time miliseconds: " .json_encode($input). $totalTime);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    public function ftpUpload(Request $request){
        set_time_limit(1800);
        $retVal = ['status' => 'successful'];
        $input = $request->all();
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtolower($countryCode);
        $ftpServer = $this->ftpConfig['ftp_server'];
        $ftpUserName = $this->ftpConfig['ftp_user_name'];
        $ftpUserPass = $this->ftpConfig['ftp_user_pass'];
        $localFile = base_path() . '/public/feeds/' . $countryCode . '/bing/'. $input['fileName'];
        $remoteFile = $input['fileName'];
        // set up basic connection
        $ftp = ftp_connect($ftpServer);
        // login with username and password
        try{
            $isLogin = ftp_login($ftp, $ftpUserName, $ftpUserPass);
            ftp_pasv($ftp, true);
//            $contents = ftp_nlist($ftp, ".");
//            // output $contents
//            var_dump($contents);die;
            if (!ftp_put($ftp, $remoteFile, $localFile, FTP_ASCII)) {
                $retVal['status'] = 'fail';
                $retVal['message'] = $input['fileName'];
            }
        } catch (\Exception $e) {
            $retVal['status'] = 'fail';
            $retVal['message'] = $e->getMessage();
            echo $e->getTraceAsString();
        }
        ftp_close($ftp);
        return response()->json($retVal);
    }

    public function insert(Request $request){
        $timeLimit = 60*30;
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $this->getLocaleData();
        $localeData = $this->getLocaleData();
        $prefixUrl = $localeData['prefixUrl'];
        $countryCode = $localeData['countryCode'];
        $filter = $this->getDefaultFilter();
        $input = $request->all();
        $from = 0;
        $to = 10001;
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
            $from = $filter['product_id_from'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-1 day'));
        }

        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
            $to = $filter['product_id_to'];
        }
        if ($to - $from > 10000){
            $filter['product_id_to'] = $from + 10000;
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('actor_ids',$input)){
            $filter['actor_ids'] = explode(",", $input['actor_ids']);
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(',',$input['ids']);
        }
        if(array_key_exists('categoryIds',$input)){
            $filter['categoryIds'] = explode(',',$input['categoryIds']);;
        }
        $query = $this->merchantProductService->buidFilter($filter);
        $products = $query->get();
        $inputBuildProduct = [
            'prefixUrl' => $prefixUrl,
            'country' => $countryCode,
            'language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'),
        ];
        $inputBuildProduct['merchant_id'] = $this->bingProductService->getMerchantId();
        if (array_key_exists('catalog_id',$input)){
            $inputBuildProduct['catalog_id'] = $input['catalog_id'];
        }
        $data = $this->merchantProductService->buildProduct($products,$inputBuildProduct);
        $retVal = $this->insertByService($data,$inputBuildProduct);
        return response()->json($retVal);
    }

    public function delete(Request $request){
        $timeLimit = 60*30;
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $this->getLocaleData();
        $localeData = $this->getLocaleData();
        $prefixUrl = $localeData['prefixUrl'];
        $countryCode = $localeData['countryCode'];
        $input = $request->all();
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-24 hours'));
                }
            }else{
                $filter['updated_at_from'] = $input['updated_at_from'];
            }
        }elseif(array_key_exists('hard_delete',$input)){

        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d H:i:s",strtotime('-24 hours'));
            }
        }
        if(array_key_exists('actor_ids',$input)){
            $filter['actor_ids'] = explode(",", $input['actor_ids']);
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = explode(",", $input['ids']);
        }
        $query = $this->bingProductService->buildDeleteQuery($filter);
        $inputData = [
            'prefixUrl' => $prefixUrl,
            'country' => $countryCode,
            'language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'),
        ];
        $products = $query->get();
        $productDeletes = [];
        foreach ($products as $product){
            $productDeletes[] = ['productId' => $product->product_id, 'sku' => $product->sku, 'merchantProductId' => $product->id];
        }
        $data = $this->bingProductService->buildProductDelete($productDeletes,$inputData);
        $result = $this->deleteByService($data,['merchant_id' => $this->bingProductService->getMerchantId()]);
        return response()->json($result);
    }

    private function getDefaultFilter(){
        $filter = [
            'status' => 'ACTIVE',
            'approve_advertising' => 1,
            'advertising_status' => 1,
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1,
        ];
        $filter['columns'] = [
            // ORIGIN
            'product.id',
            'product.slug', 'product.brand_id', 'product.image_url',
            'product.description',
            'product.status', 'product.approve_advertising',
            'product.is_trademark',
            'product.gtin',
            'product.is_always_on_ads',
            'product.actor_id',
            'product.created_at',
            'product.sold',
            'product.barcode',
//                'product.price',
//                'product.high_price',
            // SKU
            'product_info.name as sku_name',
            'product_info.variants as sku_specific_info',
            'product_info.brand as sku_brand',
            'product_info.sku as sku_code',
            'product_info.slug as sku_slug',
            'product_info.price',
            'product_info.inventory',
            'product_info.high_price',
            'product_info.category_merchant_id as sku_category_merchant_id',
            'product_info.product_sku_id',
            'product_info.product_sku_id as sku_id',
            'product_info.is_default',
            'product_n_category.category_id as category_id',
            'product.name as title_replacement',
        ];
        return $filter;
    }

    public function insertByService($products, $input){
        $result['status'] = 'fail';
        $result['message'] = 'empty product';
        if (!empty($products)){
            $url = $this->merchantServiceConfig['queue'].'/api/bing/products/batch/upsert?site='.$_SERVER['HTTP_HOST'];
            $params = [
                'products' => utf8_encode(gzencode(json_encode($products),9)),
                'storeId' => $input['merchant_id'],
                'postback_url' => route("ads::ads:bing::updateMerchantData")
            ];
            $queueDomain = '';
            $domain = '';
            if (isset($_SERVER['HTTP_HOST'])){
                $domain = $_SERVER['HTTP_HOST'];
                $queueDomain = $domain;
            }
            if(isset($this->queue['DEFAULT'])){
                $queueDomain = $this->queue['DEFAULT'];
            }
            $params['postback_url'] = str_replace($domain,$queueDomain,$params['postback_url']);
            if (array_key_exists('catalog_id',$input)){
                $params['catalog_id'] = $input['catalog_id'];
            }
            $result = $this->triggerSyncRequest($url,'POST',$params,$this->getHeaderMerchantService());
        }
        return $result;
    }

    private function deleteByService($products, $input){
        $result['status'] = 'fail';
        $result['message'] = 'empty product';
        if (!empty($products)){
            $url = $this->merchantServiceConfig['queue'].'/api/bing/products/batch/delete?site='.$_SERVER['HTTP_HOST'];
            $params = [
                'products' => utf8_encode(gzencode(json_encode($products),9)),
                'storeId' => $input['merchant_id'],
                'postback_url' => route("ads::ads:bing::updateMerchantData")
            ];
            $queueDomain = '';
            $domain = '';
            if (isset($_SERVER['HTTP_HOST'])){
                $domain = $_SERVER['HTTP_HOST'];
                $queueDomain = $domain;
            }
            if(isset($this->queue['DEFAULT'])){
                $queueDomain = $this->queue['DEFAULT'];
            }
            $params['postback_url'] = str_replace($domain,$queueDomain,$params['postback_url']);
            if (array_key_exists('catalog_id',$input)){
                $params['catalog_id'] = $input['catalog_id'];
            }
            $result = $this->triggerSyncRequest($url,'POST',$params,$this->getHeaderMerchantService());
        }
        return $result;
    }

    private function getHeaderMerchantService(){
        $headers = array(
            'Authorization: Basic '. base64_encode($this->merchantServiceConfig['user'].":".$this->merchantServiceConfig['password']),
            'Content-Type: application/json'
        );
        return $headers;
    }

    public function updateMerchantData(Request $request){
        $localeData = $this->getLocaleData();
        $countryCode = $localeData['countryCode'];
        $inputAll = $request->all();
//        \Log::useDailyFiles(storage_path().'/logs/merchant-service.log');
        $input = $inputAll;
        if (isset($inputAll['result']['result'])) {
            $input = $inputAll['result']['result'];
            $method = $input['method'];
            $successData = $input['success_data'];
            $errorData = $input['error_data'];
            $removeIds = [];
            foreach ($errorData as $item) {
                if (!isset($item['id'])){
                    \Log::info("BingUpdateMerchantData: " . json_encode($item));
                    continue;
                }
                $removeIds[] = $item['id'];
            }
            if (!empty($removeIds)) {
                $this->bingProductService->clearProductCreateFail($removeIds);
            }
            switch ($method) {
                case 'upsert':
                    $removeData = [];
                    foreach ($successData as $product) {
                        $removeData = array_merge($removeData, $this->bingProductService->saveBingProduct($product['id'], $product['sku']));
                    }
                    $removeData = $this->bingProductService->buildProductDelete($removeData, ['language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'), 'country' => $countryCode]);
                    $this->deleteByService($removeData, ['merchant_id' => $this->bingProductService->getMerchantId()]);
                    break;
                case 'delete':
                    $productIds = [];
                    $productData = [];
                    foreach ($successData as $item) {
                        $productId = $item['id'];
                        $productIds[] = $productId;
                        $productData[] = ['product_id' => $productId, 'sku' => $item['sku'], 'created_at' => date('Y-m-d H:i:s')];;
                    }
                    if (!empty($productData)) {
                        $this->bingProductService->createDeleteBingProduct($productData);
                    }
                    if (!empty($productIds)) {
                        $this->bingProductService->removeBingProduct($productIds);
                    }
                    break;
                default:

            }
        }
        return response()->json($input);
    }

    public function pushToQueue(Request $request){
        set_time_limit(60*60*24);
        ini_set("memory_limit", "1024M");
        $filter = $request->all();
        $this->getLocaleData();
        $localeData = $this->getLocaleData();
        $countryCode = $localeData['countryCode'];
        $queueDomain = '';
        $domain = '';
        if (isset($_SERVER['HTTP_HOST'])){
            $domain = $_SERVER['HTTP_HOST'];
            $queueDomain = $domain;
        }
        if (isset($this->queue[$countryCode])){
            $queueDomain = $this->queue[$countryCode];
        }elseif(isset($this->queue['DEFAULT'])){
            $queueDomain = $this->queue['DEFAULT'];
        }
        $product = $this->merchantProductService->getProduct(['max' => 1]);
        $maxId = $product->id;
        $lastId = $this->merchantProductService->getOptionByKey('bing_last_id',0);
        $step = 5000;
        if (array_key_exists('step',$filter)){
            $step = $filter['step'];
        }
        if (array_key_exists('lastId',$filter)){
            $lastId = $filter['lastId'];
        }
        if (array_key_exists('maxId',$filter)){
            $maxId = $filter['maxId'];
        }
        for($i = $lastId; $i <= $maxId+$step; $i = $i+$step){
            $filter['product_id_from'] = $i;
            $filter['product_id_to'] = $i+$step;
            $url = route('ads::ads:bing::insert',$filter);
            $url = str_replace($domain,$queueDomain,$url);
            $this->triggerSyncRequest($url);
        }
        $this->merchantProductService->saveOptionByKey('bing_last_id',$maxId);
        return response()->json(['lastId' => $lastId,'maxId' => $maxId]);
    }
}
