<?php

namespace Modules\Ads\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\DB;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function triggerAsyncRequest($url, $params = "", $method = "get") {
        $channel = curl_init();
        if ($method == "get" || $method == "GET") {
            curl_setopt($channel, CURLOPT_URL, $url . "?" . $params);
        } else if ($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_URL, $url);
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, $params);
        }
        curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT_MS, 600);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        curl_exec($channel);
        curl_close($channel);
    }

    protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = [], $timeout = 200, $isGzip = false) {
        if (!$isGzip){
            $params = json_encode($params);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($headers) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        if ($method != 'GET') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        }else{
            if (!empty($params)){
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            }
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        $data = curl_exec($ch);
        if (curl_errno($ch)) {
            $error = curl_errno($ch);
            print_r($error);
        }
        curl_close($ch);
        $retVal =  json_decode($data, true);
        if (empty($retVal)){
            $retVal = $data;
        }
        return $retVal;
    }
    protected function getProductIdFromSku($sku){
        $retVal = 0;
        preg_match('/^P(\d+)-/i',$sku,$matches);
        if (isset($matches[1])){
            $retVal = $matches[1];
        }else{
            $product = DB::table('merchant_product')->where('sku',$sku)->first(['product_id']);
            if (!empty($product->product_id)){
                $retVal = $product->product_id;
            }
        }
        return $retVal;
    }
    protected function triggerAsyncRequestPost($url, $params = [])
    {
        // Initialize cURL session
        $ch = curl_init();

        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

        // Execute the cURL request
        $response = curl_exec($ch);

        // Check for cURL errors
        if (curl_errno($ch)) {
            echo 'cURL Error: ' . curl_error($ch);
        }

        // Close cURL session
        curl_close($ch);
        return json_decode($response, true);
    }

    protected function getLocaleData(){
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = \Config::get('ads::clara-ads-general.countryCodeDefault','US');
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        return ['prefixUrl' => $prefixUrl,'countryCode' =>$countryCode];
    }

    public function sendHttpResponse($url, $method = "GET", $headers = [], $data = [], $timeout = 120)
    {
        $client = new \GuzzleHttp\Client([
            'timeout' => $timeout,
            'verify' => false,
        ]);

        try {
            $options = ['headers' => $headers];
            if (!empty($data)) {
                $contentType = $headers['Content-Type'] ?? 'application/json';

                if (stripos($contentType, 'application/json') !== false) {
                    $options['json'] = $data;
                } else {
                    $options['form_params'] = $data;
                }
            }
            switch (strtoupper($method)) {
                case 'GET':
                    $response = $client->get($url, $options);
                    break;
                case 'POST':
                    $response = $client->post($url, $options);
                    break;
                case 'PUT':
                    $response = $client->put($url, $options);
                    break;
                case 'DELETE':
                    $response = $client->delete($url, $options);
                    break;
                default:
                    throw new \Exception("Unsupported HTTP method: $method");
            }
            $body = $response->getBody()->getContents();
            $decoded = json_decode($body, true);
            return $decoded !== null ? $decoded : $body;

        } catch (\GuzzleHttp\Exception\RequestException $e) {
            return [
                'error' => $e->getMessage(),
                'code' => $e->getCode(),
                'url' => $url,
            ];
        }
    }

}
