<?php

namespace Modules\Ads\Controllers\Cron;

use DB;
use Modules\Ads\Controllers\Controller;
use Illuminate\Http\Request;

class AutoApproveDesignBatchController extends Controller
{
    public function approveDesignBatch(Request $request) {
        set_time_limit(3600);
        $email = $request->input('email');
        if (!$email) {
            return [
                'status' => 'fail',
                'message' => 'permission denied'
            ];
        }
        $user = DB::table('users')
        ->where('email', $email)
            ->whereIn('role', ['STAFF', 'ADMIN'])
            ->where('status', 'ACTIVE')
            ->first();
        if (!$user) {
            return [
                'status' => 'fail',
                'message' => 'permission denied'
            ];
        }
        \Log::info('approveDesignBatch', $request->all());
        $designs = $request->input('designs', []);
        $designIds = [];
        foreach ($designs as $design) {
            $approve = $design['approve'];
            $designId = $design['design_id'];
            if (!DB::table('design_approve_log')->where('design_id', $designId)->exists()) {
                DB::table('design_approve_log')
                    ->insert([
                        'actor_email' => $email,
                        'design_id' => $designId,
                        'approve' => $approve,
                        'reason' => $design['reason'],
                        'created_at' => date('Y-m-d H:i:s', time()),
                        'updated_at' => date('Y-m-d H:i:s', time())
                    ]);
            }
            $productIds = DB::table('product_n_design')
                ->where('design_id', $designId)
                ->pluck('product_id')
                ->toArray();
            
            DB::table('product')
                ->whereIn('id', $productIds)
                ->update([
                    'approve_advertising' => $approve,
                    'updated_at' => date('Y-m-d H:i:s', time())
                ]);
            foreach ($productIds as $productId) {
                $this->saveApproveLog([
                    'actor_email' => $email,
                    'product_id' => $productId,
                    'approve' => $approve,
                    'reason' => $design['reason'],
                ]);
            }
    
            if ($approve) {
                $this->autoPushFeed($productIds);
            }
        }

        return [
            'status' => 'successful',
            'result' => $designIds
        ];
    }

    private function autoPushFeed($productIds) {
        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        $restQUrl = config('restq.origin', url('/'));
        $url = $restQUrl . ($locale == 'us' ? '' : '/' . $locale) . '/module/ads/merchant/insert?ignore_updated_at=1&ids=' . implode(',', $productIds);
        $this->triggerSyncRequest($url, 'GET', [], ['Content-Type: application/json'], 10);
    }

    private function saveLog($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        DB::table('log')
            ->insert($data);
    }

    private function saveApproveLog($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        DB::table('product_approve_log')
            ->insert($data);
    }
}