<?php

namespace Modules\Ads\Controllers\Cron;

use DB;
use Modules\Ads\Controllers\Controller;
use Illuminate\Http\Request;

class AutoApproveDesignController extends Controller
{
    public function approveByDesign(Request $request) {
        set_time_limit(3600);
        $email = $request->input('email');
        if (!$email) {
            return [
                'status' => 'fail',
                'message' => 'permission denied'
            ];
        }
        $user = DB::table('users')
        ->where('email', $email)
            ->whereIn('role', ['STAFF', 'ADMIN'])
            ->where('status', 'ACTIVE')
            ->first();
        if (!$user) {
            return [
                'status' => 'fail',
                'message' => 'permission denied'
            ];
        }
        $designId = $request->input('design_id', 0);
        $approve = $request->input('approve', 0);
        $productIds = DB::table('product_n_design')
            ->where('design_id', $designId)
            ->pluck('product_id')
            ->toArray();
        
        DB::table('product')
            ->whereIn('id', $productIds)
            ->update([
                'approve_advertising' => $approve,
                'updated_at' => date('Y-m-d H:i:s', time())
            ]);
        foreach ($productIds as $productId) {
            $this->saveApproveLog([
                'actor_email' => $email,
                'product_id' => $productId,
                'approve' => $approve,
                'reason' => $request->get('reason', ''),
            ]);
        }

        if ($approve && $request->get('auto_push_feed', 0)) {
            $this->autoPushFeed($productIds);
        }

        if ($approve) {
            $this->buildProductInfo($productIds);
        }

        return [
            'status' => 'successful',
            'result' => $productIds
        ];
    }

    private function autoPushFeed($productIds) {
        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        $restQUrl = config('restq.origin', url('/'));
        $url = $restQUrl . ($locale == 'us' ? '' : '/' . $locale) . '/module/ads/merchant/insert?ignore_updated_at=1&ids=' . implode(',', $productIds);
        $this->triggerSyncRequest($url, 'GET', [], ['Content-Type: application/json'], 10);
    }

    private function buildProductInfo($productIds) {
        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        if (!$locale) {
            $locale = 'us';
        }
        $restQUrl = config('restq.origin', url('/'));
        $url = $restQUrl . '/v2/cron/build-product-info?service_token=megaads@123&locale=' . $locale;
        $this->triggerSyncRequest($url, 'POST', [
            'ids' => implode(',', $productIds)
        ], ['Content-Type: application/json'], 10);
    }

    private function saveLog($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        DB::table('log')
            ->insert($data);
    }

    private function saveApproveLog($data) {
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['updated_at'] = date('Y-m-d H:i:s');
        DB::table('product_approve_log')
            ->insert($data);
    }
}