<?php

namespace Modules\Ads\Controllers\Cron;

use DB;
use Modules\Ads\Controllers\Controller;
use Illuminate\Http\Request;

class AutoApproveSellerProduct extends Controller
{
    public function getDesignIds($fromId, $toId) {
        $designIds = [];
        while($fromId <= $toId) {
            $partIds = DB::table('product_n_design')
                ->where('id', '>=', $fromId)
                ->where('id', '<=', $fromId + 5000)
                ->get(['design_id'])
                ->pluck('design_id')
                ->toArray();
            $designIds = array_merge($designIds, array_unique($partIds));
            $fromId += 5001;
        }
        $designIds = array_unique($designIds);

        $unapproveDesignIds = [];
        foreach (array_chunk($designIds, 500) as $chunk) {
            $partIds = DB::table('design')
                ->whereIn('id', $chunk)
                ->where('source', 'seller')
                ->get(['id'])
                ->pluck('id')
                ->toArray();
            $approveIds = DB::table('design_approve_log')
                ->whereIn('design_id', $partIds)
                ->get(['design_id'])
                ->pluck('design_id')
                ->toArray();
            $diffIds = array_diff($partIds, $approveIds);
            
            $unapproveDesignIds = array_merge($unapproveDesignIds, $diffIds);
        }
        
        return $unapproveDesignIds;
    }

    public function autoApprove(Request $request) {
        set_time_limit(3600);
        $query = DB::table('product_n_design');
        $fromId = $this->getFromId($request, $query);
        $toId = $this->getToId($request, $query);
        if ($fromId == 0 || $toId == 0) {
            return [
                'status' => 'fail',
                'message' => 'from_id and to_id is required'
            ];
        }

        $designIds = $this->getDesignIds($fromId, $toId);
        $designIds = array_unique($designIds);

        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        if (!$locale) {
            $locale = 'us';
        }
        $checkTrademarkUrl = config('trademarks::sa.check_trademark_url', 'https://trademark-checker.printerval.com');
        if ($checkTrademarkUrl) {
            $testTrademarkUrl = $checkTrademarkUrl  . '/check-design-by-ai-batch';
            $this->triggerSyncRequest($testTrademarkUrl, 'POST', [
                'designIds' => $designIds, 
                'locale' => $locale,
                'origin' => url('/')
            ], ['Content-Type: application/json']);
        }

        return [
            'status' => 'success',
            'result' => $designIds
        ];
    }

    public function getFromId($request, $query) {
        if ($request->has('from_id')) {
            return $request->get('from_id');
        }
        $cloneQuery = clone $query;
        $from = $cloneQuery
            ->where('created_at', '>=', date('Y-m-d H:00:00', time() - $request->get('hours', 1) * 3600))
            ->orderBy('created_at', 'asc')->first();
        if ($from) {
            return $from->id;
        }

        return 0;
    }

    public function getToId($request, $query) {
        if ($request->has('to_id')) {
            return $request->get('to_id');
        }
        $cloneQuery = clone $query;
        $to = $cloneQuery
            ->where('created_at', '<=', date('Y-m-d H:59:59', time() - $request->get('hours', 1) * 3600))
            ->orderBy('id', 'desc')->first();
        if ($to) {
            return $to->id;
        }

        return 0;
    }
}