<?php

namespace Modules\Ads\Controllers\Cron;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Services\CampaignService;
use Modules\Ads\Services\ClickService;
use Modules\Ads\Services\ProductInfoService;
use WhichBrowser\Parser;
use Modules\Ads\Models\Order;
use Modules\Ads\Models\ProductInfo;

use Module;

class ClickController extends Controller
{
    protected $clickService;
    protected $campaignService;
    protected $productInfoService;

    public function __construct(ClickService $clickService,
                                CampaignService $campaignService,
                                ProductInfoService $productInfoService
                                )
    {        
        $this->clickService = $clickService;
        $this->campaignService = $campaignService;
        $this->productInfoService = $productInfoService;
    }

    public function cronClick(Request $request) {
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $response = [
            'status' => 'successful',
            'message' => 'Calculate clicked successful'
        ];
        $from = date('d/m/Y', strtotime("-1 day"));
        $to = date('d/m/Y', time());
        if($request->has('day')) {
            $from = $request->input('day');
            $to = $from;
        }
        $campaigns = $this->campaignService->campaignByIds();
        $url = \URL::to('/');
        $parse = parse_url($url);
        $domain = $parse['host'];
        $locale = env('APP_LOCALE');
        $curentLocale = 'us';
        if (!empty($locale) && $locale != 'us') {
            $domain .= '/' . $locale . '/';
            $curentLocale = $locale;
        }
        $clickerUrl = config("clicker.domain");
        if ($clickerUrl == null) {
            throw new \Exception('The module Product Advertising require a "domain" in /config/clicker.php');
        }
        $username = config('clicker.authBasic.username');
        $password = config('clicker.authBasic.password');
        if ($username == null || $password == null) {
            throw new \Exception('The module Product Advertising require "clickerAuthBasic.username" and "clickerAuthBasic.password" in /config/app.php');
        }
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic '. base64_encode($username . ":" . $password)
        );
        $pageSize = 1000;
        $page = 0;
        $loop = 0;
        $data = [];
        $listProductCode = [];
        while (true) {
            $loop++;
            $apiUrl = $clickerUrl . '/service/get-data-tracking?source=all&site='. $domain .'&from=' . $from . '&to=' . $to . '&page=' . $page . '&page_size=' . $pageSize;
            $output = $this->triggerSyncRequest($apiUrl, 'GET', [], $headers);
            if (($output && !empty($output) && $output['status'] == 'successful' && count($output['data']) == 0) || $loop == 500) {
                break;
            }
            if ($output && !empty($output) && $output['status'] == 'successful') {
                $productIds = [];
                $items = [];
                foreach($output['data'] as $item) {
                    $urlParser = parse_url($item['url']);
                    $localeUrl = $this->getLocaleFromUrl($urlParser['path']);
                    if (!isset($urlParser['path']) || $curentLocale != $localeUrl) {
                        continue;
                    }
                    preg_match('/.*-p([0-9]+)\.html$/i', $urlParser["path"], $match);
                    if (!$match) {
                        preg_match('/.*-p([0-9]+)/i', $urlParser["path"], $match);
                        $productId = isset($match[1]) ? $match[1] : '';
                        if (!$match) {
                            continue;
                        }
                    }
                    $productId = isset($match[1]) ? $match[1] : '';
                    $skuId = null;
                    if (isset($urlParser['query'])) {
                        $queries = explode("&", $urlParser['query']);
                        foreach ($queries as $query) {
                            $pos = strpos($query, 'spid=');
                            if($pos !== false) {
                                $skuId = preg_replace('/[^0-9]/', '', $query);
                                break;
                            }
                        }
                    }
                    if ($productId != '') {
                        $productIds[] = $productId;
                        $newData = [];
                        $newData['product_id'] = (int) $productId;
                        $newData['product_sku_id'] = (int) $skuId;
                        $url = $urlParser['scheme'] . '://' . $urlParser['host'] . $urlParser['path'];
                        if ($skuId != null) {
                            $url .= '?spid=' . $skuId;
                        }
                        $newData['url'] = $url;
                        $newData['source'] = $item['source'];
                        $newData['campaign_id'] = null;
                        $newData['campaign_type'] = 'UNKNOWN';
                        $arrDate = explode(' ', $item['create_time']);
                        $newData['date'] = $arrDate[0];
                        $newData['data'] = $item['data'];
                        $items[] = $newData;
                    } 
                }
                $skuByIds = $this->productInfoService->getSkuById($productIds);
                foreach ($items as $item) {
                    $key = $item['product_id'];
                    if ($item['product_sku_id'] != null) {
                        $key .= '_' . $item['product_sku_id'];
                    }
                    $item['sku'] = '';
                    if (isset($skuByIds['buyIds'][$item['product_id']])) {
                        $item['sku'] = $skuByIds['buyIds'][$item['product_id']];
                    }
                    $uniqString = $item['product_id'] . '-' . $item['product_sku_id'] . '-' . $item['source'] . '-' . $item['date'];
                    $dataJson = json_decode($item['data'], true);
                    if (isset($dataJson['campaignid'])) {
                        $item['campaign_id'] = $dataJson['campaignid'];
                        if (isset($campaigns[$dataJson['campaignid']])) {
                            $item['campaign_type'] = $campaigns[$dataJson['campaignid']]['campaign_type'];
                        }
                        $uniqString .= $dataJson['campaignid'];
                    }
                    $uniqId = md5($uniqString);
                    $item['uniq_id'] = $uniqId;
                    unset($item['data']);
                    if (!isset($data[$uniqId])) {
                        $item['clicks'] = 1;
                        $data[$uniqId] = $item;
                    } else {
                        $data[$uniqId]['clicks']++;
                    }
                }
                $page++;
            }
        }
        $items = [];
        $subItem = [];
        $count = count($data);
        $count = round($count);
        $i = 0;
        foreach($data as $key => $item) {
            $subItem[] = $item;
            if (count($subItem) == 100 || $i == $count - 1) {
                $items[] = $subItem;
                $subItem = [];
            }
            $i++;
        }
        $property = [
            'table' => 'sb_click',
            'columns' => ['product_id', 'product_sku_id', 'sku', 'url', 'source', 'campaign_id', 'campaign_type', 'clicks', 'date', 'uniq_id']
        ];
        foreach($items as $key => $values) {
            $this->clickService->excecuteStatement($property, $values);
        }
        return response()->json($response);
    }


    public function calculatingReportByProduct(Request $request) {
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $response = [
            'status' => 'successful',
            'message' => 'Calculate clicked successful'
        ];
        $from = date('d/m/Y', strtotime("-1 day"));
        $to = date('d/m/Y', time());
        if($request->has('day')) {
            $from = $request->input('day');
            $to = $from;
        }
        $dataSale = $this->getSale($from, $to);
        $url = \URL::to('/');
        $parse = parse_url($url);
        $domain = $parse['host'];
        $locale = env('APP_LOCALE');
        $curentLocale = 'us';
        if (!empty($locale) && $locale != 'us') {
            $domain .= '/' . $locale . '/';
            $curentLocale = $locale;
        }
        $clickerUrl = config("clicker.domain");
        if ($clickerUrl == null) {
            throw new \Exception('The module Product Advertising require a "domain" in /config/clicker.php');
        }
        $username = config('clicker.authBasic.username');
        $password = config('clicker.authBasic.password');
        if ($username == null || $password == null) {
            throw new \Exception('The module Product Advertising require "clickerAuthBasic.username" and "clickerAuthBasic.password" in /config/app.php');
        }
        $headers = array(
            'Content-Type:application/json',
            'Authorization: Basic '. base64_encode($username . ":" . $password)
        );
        $pageSize = 1000;
        $page = 0;
        $loop = 0;
        $data = [];
        while (true) {
            $loop++;
            $apiUrl = $clickerUrl . '/service/get-data-tracking?is_device=1&site='. $domain .'&from=' . $from . '&to=' . $to . '&page=' . $page . '&page_size=' . $pageSize;
            $output = $this->triggerSyncRequest($apiUrl, 'GET', [], $headers);
            if (($output && !empty($output) && $output['status'] == 'successful' && count($output['data']) == 0) || $loop == 500) {
                break;
            }
            if ($output && !empty($output) && $output['status'] == 'successful') {
                $deviceByTokens = [];
                foreach ($output['devices'] as $item) {
                    $deviceByTokens[$item['key']] = $item['value'];
                }
                $items = [];
                $productIds = [];
                foreach($output['data'] as $item) {
                    if (isset($deviceByTokens[$item['token']])) {
                        $item['userAgent'] = $deviceByTokens[$item['token']];
                    }
                    $urlParser = parse_url($item['url']);
                    $localeUrl = $this->getLocaleFromUrl($urlParser['path']);
                    if (!isset($urlParser['path']) || $curentLocale != $localeUrl) {
                        continue;
                    }
                    preg_match('/.*-p([0-9]+)\.html$/i', $urlParser["path"], $match);
                    if (!$match) {
                        preg_match('/.*-p([0-9]+)/i', $urlParser["path"], $match);
                        $productId = isset($match[1]) ? $match[1] : '';
                        if (!$match) {
                            continue;
                        }
                    }
                    $productId = isset($match[1]) ? $match[1] : '';
                    // $skuId = $this->getProductSkuId($urlParser);
                    if ($productId != '') {
                        $productIds[] = $productId;
                        $item['productId'] = $productId;
                        // $item['productSkuId'] = $skuId;
                        $items[] = $item;
                    }
                }

                $skuByIds = $this->productInfoService->getSkuById($productIds);
                foreach ($items as $item) {
                    $device = 'other';
                    if (isset($item['userAgent'])) {
                        $device = $this->detectDevice($item['userAgent']);
                    }
                    if ($device != 'other') {
                        $newData = [];
                        $newData['product_id'] = (int) $item['productId'];
                        $arrDate = explode(' ', $item['create_time']);
                        $newData['date'] = $arrDate[0];
                        $newData['device'] = $device;
                        $newData['sku'] = '';
                        if (isset($skuByIds['buyIds'][$item['productId']])) {
                            $newData['sku'] = $skuByIds['buyIds'][$item['productId']];
                        }
                        $uniqString = $newData['product_id'] . '-' . $newData['device'] . '-' . $arrDate[0];
                        $uniqId = md5($uniqString);
                        $newData['uniq_id'] = $uniqId;
                        $deviceKey = $newData['product_id'] . '-' . $newData['device'];
                        $newData['sale'] = 0;
                        if (isset($dataSale[$deviceKey])) {
                            $newData['sale'] = $dataSale[$deviceKey];
                        }
                        $updatedAt = new \DateTime();
                        $updatedAtString = $updatedAt->format('Y-m-d H:i:s');
                        $newData['updated_at'] = $updatedAtString;
                        if (!isset($data[$uniqId])) {
                            $newData['click'] = 1;
                            $data[$uniqId] = $newData;
                        } else {
                            $data[$uniqId]['click']++;
                        }
                    }
                }
                $page++;
            }
        }
        $this->saveDataReport($data);
        return response()->json($response);
    }

    private function saveDataReport($data) {
        $items = [];
        $subItem = [];
        $count = count($data);
        $count = round($count);
        $i = 0;
        foreach($data as $key => $item) {
            $subItem[] = $item;
            if (count($subItem) == 200 || $i == $count - 1) {
                $items[] = $subItem;
                $subItem = [];
            }
            $i++;
        }
        $property = [
            'table' => 'sb_product_report',
            'columns' => ['product_id', 'sku', 'device', 'click', 'sale', 'date', 'uniq_id', 'updated_at']
        ];
        foreach($items as $key => $values) {
            $this->clickService->excecuteStatement($property, $values);
        }
    }

    private function getSale($from, $to) {
        $fromObject = \DateTime::createFromFormat('d/m/Y', $from);
        $toObj = \DateTime::createFromFormat('d/m/Y', $to);
        $from = $fromObject->setTime(0,0,0);
        $to = $toObj->setTime(23,59,59);
        $items = Order::with(['items', 'device'])
                        ->where('payment_status', '=', 'PAID')
                        ->where('created_at', '>=', $from)
                        ->where('created_at', '<=', $to)
                        ->get()->toArray();
        $retVal = [];
        foreach ($items as $order) {
            $device = 'other';
            if (isset($order['device']) && !empty($order['device'])) {
                $device = $order['device'][0]['value'];
            }
            $device = strtolower($device);
            $productIds = [];
            foreach ($order['items'] as $item) {
                if (!in_array($item['product_id'], $productIds)) {
                    $productIds[] = $item['product_id'];
                }
            }
            foreach ($productIds as $id) {
                $key = $id . '-' . $device;
                if (!array_key_exists($key, $retVal)) {
                    $retVal[$key] = 0;
                }
                $retVal[$key]++;
            }
        }
        return $retVal;
    }

    private function getProductSkuId($urlParser) {
        $retVal = null;
        if (isset($urlParser['query'])) {
            $queries = explode("&", $urlParser['query']);
            foreach ($queries as $query) {
                $pos = strpos($query, 'spid=');
                if($pos !== false) {
                    $retVal = preg_replace('/[^0-9]/', '', $query);
                    break;
                }
            }
        }
        return $retVal;
    }

    private function detectDevice($userAgent) {
        $result = new Parser($userAgent);
        $retVal = 'other';
        if ($result->isType('desktop')) {
            $retVal = 'desktop';
        } elseif ($result->isType('mobile')) {
            $retVal = 'mobile';
        } elseif ($result->isType('tablet')) {
            $retVal = 'tablet';
        }
        return $retVal;
    }

    private function getLocaleFromUrl($path) {
        $locale = 'us';
        if ($path) {
            $pathExplode = explode('/', $path);
            $pathExplode = array_values(array_filter($pathExplode));
            $prefix = isset($pathExplode[0]) ? $pathExplode[0] : '';
            if ($prefix && in_array($prefix, ['au', 'ca', 'es', 'fr', 'jp', 'it', 'pt', 'uk', 'de'])) {
                $locale = $prefix;
            }
        }
        return $locale;
    }
}
