<?php

namespace Modules\Ads\Controllers\Cron;

use DB;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;

class ViolationController extends Controller {
    public function checkViolation(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $isAll = false;
        if ($request->get('all')) {
            $isAll = true;
        }

        if ($request->has('keyword')) {
            $violateKeywords = [$request->get('keyword')];
        } else if ($request->has('new_keyword')) {
            $violateKeywords = $this->getNewViolateKeywords($request);
        } else {
            $minMaxId = explode(',', $request->input('minMaxKeywordId', '0,0'));
            $violateKeywords = $this->getViolateKeywords($minMaxId[0], $minMaxId[1]);
        }

        foreach ($violateKeywords as $keyword) {
            $query = DB::table('product')
                ->where('is_violation', 0);
            $fromId = $this->getFromId($request, $query);
            $toId = $this->getToId($request, $query);
            if (!$isAll && !$request->has('from_id') && !$request->has('to_id')) {
                $query->where('updated_at', '>=', $date);
                $query->where('updated_at', '<=', $current);
            }
            $query->having('name', 'like', '%' . $keyword . '%');

            $step = $request->get('step', 10000);
            while($fromId <= $toId) {
                $cloneQuery = clone $query;
                $cloneQuery
                    ->where('product.id', '>=', $fromId)
                    ->where('product.id', '<', $fromId + $step)
                    ->select(\DB::raw("id, replace(replace(replace(replace(`name`, '-', ''), '.', ''), '_', ''), '+', '') as `name`, slug"));
                $products = $cloneQuery->get();
                $violateIds = [];
                foreach ($products as $product) {
                    $check = $this->checkNameIsViolate($product->name, $keyword);
                    if (!$check) {
                        $check = $this->checkNameIsViolate(str_replace('-', ' ', $product->slug), $keyword);
                    }
                    if ($check) {
                        $retVal['result'][] = $product->id;
                        $violateIds[] = $product->id;
                    }
                }
    
                $this->updateViolationProduct($violateIds);

                $fromId += $step;
            }
        }
        return $retVal;
    }

    public function enableViolation(Request $request)
    {
        set_time_limit(3 * 3600);
        ini_set('memory_limit', '2048M');
        $fromId = $request->input('from_id');
        $toId = $request->input('to_id');
        $keyword = $request->input('keyword');
        $step = $request->input('step', 10000);
        if (!$fromId || !$toId || !$keyword) {
            return;
        }
        $pIdsUpdate = [];
        while ($fromId < $toId) {
            $products = $this->getProductViolation($fromId, $fromId + $step, $keyword);
            $fromId += $step;
            if ($products) {
                foreach ($products as $product) {
                    if ($this->productIsViolation($product, $keyword)) {
                        $pIdsUpdate[] = $product->id;
                    }
                }
            }
        }
        if ($pIdsUpdate) {
            foreach (array_chunk($pIdsUpdate, 200) as $chunkPIds) {
                $this->activeProductViolation($chunkPIds);
            }
        }
        $response = array(
            "status" => 'successful',
            "keyword" => $keyword,
            "count" => count($pIdsUpdate),
        );
        return response()->json($response);

    }

    protected function activeProductViolation($pIds) {
        $date = new \DateTime();
        DB::table('product')->whereIn('id', $pIds)->update([
            'status' => 'ACTIVE',
            'is_violation' => 0,
            'updated_at' => $date,
        ]);
    }

    protected function productIsViolation($product, $keyword) {
        $result = $this->checkNameIsViolate($product->name, $keyword);
        if (!$result) {
            $result = $this->checkNameIsViolate(str_replace('-', ' ', $product->slug), $keyword);
        }
        return $result;
    }


    protected function getProductViolation($fromId, $toId, $keyword) {
        return DB::table('product')
            ->where('is_violation', 1)
            ->where('is_trademark', 0)
            ->where('product.id', '>=', $fromId)
            ->where('product.id', '<=', $toId)
            ->where('name', 'like', '%' . $keyword . '%')
            ->get([
                \DB::raw("replace(replace(replace(replace(`name`, '-', ''), '.', ''), '_', ''), '+', '') as `name`"),
                'id', 'slug'
            ]);
    }

    public function checkNameIsViolate($name, $keyword) {
        $check = $this->isViolate($name, $keyword);
        if (!$check) {
            $name = preg_replace("/[^A-Za-z ]/", ' ', $name);
            $check = $this->isViolate($name, $keyword);
        }

        if (!$check) {
            $name = str_replace(' and ', ' ', $name);
            $check = $this->isViolate($name, $keyword);
        }
        if (!$check) {
            $originalName = $name;
            $name = preg_replace("/[^A-Za-z ]/", ' ', $name);
            $name = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $name)));
            $check = $this->isViolate($name, $keyword);
            if (!$check) {
                $name = preg_replace("/[^A-Za-z ]/", '', $originalName);
                $check = $this->isViolate($name, $keyword);
            }
        }
        return $check;
    }

    public function getFromId($request, $query, $column = 'product.id') {
        if ($request->has('from_id')) {
            return $request->get('from_id');
        }
        $cloneQuery = clone $query;
        $from = $cloneQuery->orderBy($column, 'asc')->first();
        if ($from) {
            return $from->id;
        }

        return 0;
    }

    public function getToId($request, $query, $column = 'product.id') {
        if ($request->has('to_id')) {
            return $request->get('to_id');
        }
        $cloneQuery = clone $query;
        $to = $cloneQuery->orderBy($column, 'desc')->first();
        if ($to) {
            return $to->id;
        }

        return 0;
    }

    public function getNewViolateKeywords($request) {
        $violateKeywords = [];
        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $keywords = DB::table('violation_keyword')
            ->where('updated_at', '>=', $date)
            ->where('updated_at', '<=', $current)
            ->get(['keyword'])
            ->pluck('keyword')
            ->toArray();
        foreach ($keywords as $value) {
            $violateKeywords[] = strtolower(trim($value));
        }

        return $violateKeywords;
    }

    public function getViolateKeywords($minId = null, $maxId = null) {
        $violateKeywords = [];
        $query = DB::table('violation_keyword');
        if ($minId && $maxId) {
            $query->where('id', '>=', $minId)
                ->where('id', '<=', $maxId);
        }
        $keywords = $query->get(['keyword'])->pluck('keyword')->toArray();
        foreach ($keywords as $value) {
            $violateKeywords[] = strtolower(trim($value));
        }

        return $violateKeywords;
    }

    public function isViolate($name, $keyword) {
        $retVal = false;
        $name = strtolower(trim($name));
        if (
            preg_match("/\b" . $keyword . "\b/i", $name) ||
            preg_match(sprintf("/^%s\s|\s%s\s|\s%s$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ss\s|\s%ss\s|\s%ss$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ses\s|\\s%ses\s|\s%ses$/", $keyword, $keyword, $keyword), $name) ||
            $name == $keyword 
        ) {
            $retVal = true;
        }

        return $retVal;
    }

    public function recheckViolation(Request $request) {
        set_time_limit(4 * 3600);
        ini_set('memory_limit', '2048M');
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        $productViolate = $this->buildProductMetaViolation();
        $query = DB::table('product')
            ->where('is_violation', 1)
            ->select(\DB::raw("id, replace(replace(replace(replace(`name`, '-', ''), '.', ''), '_', ''), '+', '') as `name`, slug"));
        $products = $query->get();
        $violateKeywords = $this->getViolateKeywords();
        foreach ($violateKeywords as $keyword) {
            $violateIds = [];
            foreach ($products as $product) {
                if (array_key_exists($product->id, $productViolate)) {
                    continue;
                }
                if ($this->isViolate($product->name, $keyword)) {
                    $retVal['result'][] = $product->id;
                    $violateIds[] = $product->id;
                }
            }

            foreach (array_chunk($violateIds, 200) as $ids) {
                //Save product meta violation by keywords
                $data = [];
                foreach ($ids as $key => $id) {
                    $productViolate[$id] = $id;
                    $data[] = [
                        "key" => "violation_by_keywords",
                        "value" => 1,
                        "product_id" => $id
                    ];
                }
                DB::table('product_meta')->insert($data);
            }
        }

        return $retVal;
    }

    protected function buildProductMetaViolation() {
        return  DB::table('product_meta')
            ->where('key', 'violation_by_keywords')
            ->pluck('product_id', 'product_id')
            ->toArray();
    }

    public function getViolationTag($request) {
        $retVal = [];

        if ($request->has('keyword')) {
            $violateKeywords = [$request->get('keyword')];
        } else {
            $violateKeywords = $this->getViolateKeywords();
        }

        foreach($violateKeywords as $keyword) {
            $query = DB::table('tag')
                ->select(\DB::raw("id, replace(replace(replace(replace(`title`, '-', ''), '.', ''), '_', ''), '+', '') as `title`, slug"))
                ->having('title', 'like', '%' . $keyword . '%');
            $tags = $query->get();

            foreach($tags as $item) {
                $check = $this->checkNameIsViolate($item->title, $keyword);
                if (!$check) {
                    $check = $this->checkNameIsViolate(str_replace('-', ' ', $item->slug), $keyword);
                }
                if ($check) {
                    $retVal[] = $item->id;
                }
            }
        }

        return array_unique($retVal);
    }

    public function checkViolationTag(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $isAll = false;
        if ($request->get('all')) {
            $isAll = true;
        }

        $tagIds = $this->getViolationTag($request);
        $query = DB::table('product')
            ->join('tag_refer', 'tag_refer.refer_id', 'product.id')
            ->where('refer_type', 'PRODUCT')
            ->where('is_violation', 0)
            ->select('product.id');
        foreach ($tagIds as $tagId) {
            $cloneQuery = clone $query; 
            $cloneQuery->where('tag_id', $tagId);

            $fromId = $this->getFromId($request, $cloneQuery);
            $toId = $this->getToId($request, $cloneQuery);
            $step = $request->get('step', 10000);
            while($fromId <= $toId) {
                $productIds = $cloneQuery->where('product.id', '>=', $fromId)
                    ->where('product.id', '<', $toId + $step)
                    ->get(['product.id'])
                    ->pluck('id')
                    ->toArray();
                $retVal['result'] = array_merge($retVal['result'], $productIds);

                // $this->updateViolationProduct($productIds);
                
                $fromId += $step;
            }
        }

        $retVal['result'] = array_values(array_unique($retVal['result']));

        return $retVal;
    }

    public function updateViolationProduct($productIds) {
        foreach (array_chunk($productIds, 500) as $ids) {
            DB::table('product')->whereIn('id', $ids)
                ->update([
                    'is_violation' => 1,
                    'updated_at' => date('Y-m-d H:i:s', time())
                ]);
            
            //Save product meta violation by keywords
            $data = [];
            foreach ($ids as $key => $id) {
                if (!DB::table('product_meta')->where('product_id', $id)->where('key', 'violation_by_keywords')->exists()) {
                    $data[] = [
                        "key" => "violation_by_keywords",
                        "value" => 1,
                        "product_id" => $id
                    ];
                }
            }
            if (count($data)) {
                DB::table('product_meta')->insert($data);
            }
        }
    }
}
