<?php

namespace Modules\Ads\Controllers;

use App\Customer;
use App\Http\Controllers\GoogleCloudStorageController;
use App\Models\Option;
use App\Modules\Ads\Request\DataExport\ExportPlatformRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Controllers\Service\ClickHouseService;
use Modules\Ads\Controllers\Service\DataExportService;
use Carbon\Carbon;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Controllers\Service\PinterestService;
use Modules\Ads\Controllers\Service\RedditService;
use Modules\Ads\Controllers\Service\SnapchatService;
use Modules\Ads\Controllers\Service\TiktokService;
use Modules\Ads\Controllers\Service\TwitterService;


class DataExportController extends Controller
{
    protected $dataExportService;
    protected $clickHouseService;
    protected $optionModel;
    protected $googleCloudStorageController;
    protected $tiktokService;
    protected $pinterestProductService;
    protected $snapchatService;
    protected $twitterService;
    protected $redditService;
    protected $customerModel;

    public function __construct(DataExportService $dataExportService, ClickHouseService $clickHouseService,
                                Option            $optionModel, GoogleCloudStorageController $googleCloudStorageController,
                                TiktokService     $tiktokService, PinterestService $pinterestProductService,
                                SnapchatService   $snapchatService, TwitterService $twitterService,
                                RedditService     $redditService, Customer $customerModel
    )
    {
        $this->dataExportService = $dataExportService;
        $this->clickHouseService = $clickHouseService;
        $this->optionModel = $optionModel;
        $this->googleCloudStorageController = $googleCloudStorageController;
        $this->tiktokService = $tiktokService;
        $this->pinterestProductService = $pinterestProductService;
        $this->snapchatService = $snapchatService;
        $this->twitterService = $twitterService;
        $this->redditService = $redditService;
        $this->customerModel = $customerModel;
    }

    public function cronExportCustomerEmail(Request $request)
    {
        set_time_limit(600);

        $overwrite = $request->input('overwrite', false);
        $domain = $this->getDomain();
        $domainQueue = $this->getDomainQueue() ?? $domain;
        $locale = 'us';
        if (!empty(env('APP_LOCALE'))) {
            $locale = env('APP_LOCALE');
        }
        $locale = $request->locale ?? $locale;
        $keyScan = 'last_id_customer_scan_' . $locale;
        $filePath = public_path("customer/{$domain}_{$locale}_customer_email.csv");

        if ($overwrite) {
            if (file_exists($filePath)) {
                unlink($filePath);
            }
            $this->optionModel->updateOrInsert(['key' => $keyScan], ['value' => 0]);
            if (empty($request->input('locale'))) {
                DB::table('exported_customers')->truncate();
            }
        }
        $lastIdScan = 1;
        if (empty($request->input('locale'))) {
            $upLocale = strtoupper($locale);
            $queryMax = "SELECT MAX(id) AS max_id FROM mega.sb_order WHERE locale = '{$upLocale}'";
            $queryMin = "SELECT MIN(id) AS min_id FROM mega.sb_order WHERE locale = '{$upLocale}'";
            $resultMax = $this->sendHttpResponse($this->clickHouseService->getQueryUrl($queryMax), "GET");
            $resultMin = $this->sendHttpResponse($this->clickHouseService->getQueryUrl($queryMin), "GET");
            $lastID = $resultMax['data'][0]['max_id'] ?? 0;
            $lastIdScan = $resultMin['data'][0]['min_id'] ?? 0;
        } else {
            $lastID = $this->customerModel->orderBy('id', 'DESC')->value('id');
        }
        $batchSize = $request->batch_size ?? 1000;
        $optionKeyValue = $this->optionModel->where('key', $keyScan)->value('value');
        $lastIdScan = !empty($optionKeyValue) ? $optionKeyValue : $lastIdScan;
        for ($start = $lastIdScan; $start <= $lastID; $start += $batchSize) {
            $end = min($start + $batchSize - 1, $lastID);
            $dataSendRequest = [
                'first_id' => $start,
                'last_id' => $end,
                'locale' => $locale
            ];
            $url = route('ads::export::email-csv', $dataSendRequest);
            $urlDetail = str_replace($domain, $domainQueue, $url);
            $this->sendHttpResponse($urlDetail, "POST");
        }

        $this->optionModel->updateOrInsert(['key' => $keyScan], ['value' => $lastID]);
        return response()->json([
            'status' => 'done',
            'link_gcs' => "https://storage.googleapis.com/printerval-central/customer/{$this->getDomain()}_{$locale}_customer_email.csv"
        ]);
    }


    public function exportCustomerEmail(Request $request)
    {
        try {
            $firstId = $request->first_id ?? 0;
            $lastId = $request->last_id ?? 0;
            $locale = $request->locale ?? (env('APP_LOCALE', 'us') == 'us' ? 'us' : env('APP_LOCALE'));
            if (!empty($request->locale) && $locale != 'all') {
                $dataAppend = $this->appendByClickHouse($locale, $firstId, $lastId);
            } else {
                $dataAppend = $this->appendByCustomer($locale, $firstId, $lastId);
            }
            if (!empty($dataAppend['exported_count'])) {
                $uploadGCS = uploadToGCS($dataAppend['file_path'], "customer/{$this->getDomain()}_{$locale}_customer_email.csv");
                $retVal = [
                    'status' => true,
                    'data' => $dataAppend,
                    'link_gcs' => $uploadGCS,
                    'message' => 'Exported batch successfully'
                ];
            } else {
                $retVal = [
                    'status' => true,
                    'data' => $dataAppend,
                    'message' => 'Exported batch successfully'
                ];
            }
            return response()->json($retVal);
        } catch (\Exception $exception) {
            throw $exception;
        }

    }

    public function createFileCsvBySocialPlatform(ExportPlatformRequest $request)
    {
        $retVal = ['status' => 'failed'];
        $input = $request->all();
        $input['rename'] = 1;
        $input['truncate'] = 1;
        $input['ignore_updated_at'] = 1;
        $timeLimit = 60 * 30;
        if (array_key_exists('time_limit', $input)) {
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        if (!empty($input['social_platform'])) {
            $socialMedia = $input['social_platform'];
            switch ($socialMedia) {
                case "pinterest":
                    $socialMediaService = $this->pinterestProductService;
                    break;
                case "tiktok":
                    $socialMediaService = $this->tiktokService;
                    break;
                case "snapchat":
                    $socialMediaService = $this->snapchatService;
                    break;
                case "twitter":
                    $socialMediaService = $this->twitterService;
                    break;
                case "reddit":
                    $socialMediaService = $this->redditService;
                    break;
                case "facebook":
                    $socialMediaService = $this->pinterestProductService;
                    $input['mga_source'] = 'facebook_ads';
                    break;
                default:
                    $socialMediaService = null;
                    break;
            }
            if (!empty($socialMediaService)) {
                $buildFilterPrintest = $socialMediaService->buildFilterData($input);
                $products = $buildFilterPrintest['products'];
                $input = $buildFilterPrintest['input'];
                $locale = $buildFilterPrintest['locale'];
                $count = $socialMediaService->buildProducts($products, $input);
                $fileName = $socialMediaService->store($input, $locale);
                if (!empty($fileName)) {
                    $localPath = $fileName['local_path'];
                    $storagePath = $fileName['storage_path'];
                    $fileNameGoogleCloud = uploadToGCS($localPath, $storagePath);
                    $retVal['status'] = 'successful';
                    $retVal['url'] = $fileNameGoogleCloud['publicUrl'];
                    $retVal['count'] = $count;
                } else {
                    $retVal['message'] = "Không có sản phẩm hợp lệ";
                }
            }
        }
        return response()->json($retVal);
    }


    private function getDomain()
    {
        if (class_exists(\Illuminate\Http\Request::class)) {
            try {
                $request = app(\Illuminate\Http\Request::class);
                if ($request->getHost()) {
                    return $request->getHost();
                }
            } catch (\Throwable $e) {
            }
        }

        if (!empty($_SERVER['HTTP_HOST'])) {
            return $_SERVER['HTTP_HOST'];
        }

        if (!empty($_SERVER['SERVER_NAME'])) {
            return $_SERVER['SERVER_NAME'];
        }

        if (!empty($_SERVER['SERVER_ADDR'])) {
            return $_SERVER['SERVER_ADDR'];
        }

        return 'localhost';
    }

    private function getDomainQueue()
    {
        $retVal = '';
        $configDefault = config('ads::queue');
        if (!empty($configDefault) && is_array($configDefault)) {
            $locale = "US";
            if (env('LOCALIZATION') && env('APP_LOCALE') !== '') {
                $locale = strtoupper(env('APP_LOCALE'));
            }
            if (key_exists($locale, $configDefault)) {
                $retVal = $configDefault[$locale];
            } else {
                $retVal = $configDefault['DEFAULT'];
            }
        }
        return $retVal;
    }

    private function appendByClickHouse($locale, $firstId, $lastId)
    {
        $localeQuery = strtoupper($locale);
        $query = "SELECT customer_id
                      FROM mega.sb_order
                      WHERE id >= {$firstId}
                      AND id <= {$lastId}
                      AND locale = '{$localeQuery}'
                      GROUP BY customer_id
                      ORDER BY customer_id ASC";
        $queryUrl = $this->clickHouseService->getQueryUrl($query);
        $result = $this->sendHttpResponse($queryUrl, "GET");
        if (empty($result['data'])) {
            $retVal = [
                "file_path" => [],
                "exported_count" => 0
            ];
        } else {
            $getCustomerIds = [];
            foreach ($result['data'] as $row) {
                $getCustomerIds[] = $row['customer_id'];
            }
            $scannedIds = \DB::table('exported_customers')
                ->whereIn('customer_id', $getCustomerIds)
                ->pluck('customer_id')
                ->toArray();
            $newCustomerIds = array_diff($getCustomerIds, $scannedIds);
            $filePath = public_path("customer/" . $this->getDomain() . "_" . $locale . '_customer_email.csv');
            if (!empty($newCustomerIds)) {
                $getCustomer = \DB::table(\DB::raw('`' . env('DB_DATABASE_CUSTOMER', 'printerval_customer') . '`.`customer`'))
                    ->whereIn('id', $newCustomerIds)
                    ->where('status', 'ACTIVE')
                    ->select('email')
                    ->get();
                if ($getCustomer->isNotEmpty()) {
                    $this->dataExportService->appendCsvFileUniqueColumn($filePath, $getCustomer->toArray(), ['email'], 'email');
                    $insertData = [];
                    foreach ($newCustomerIds as $id) {
                        $insertData[] = [
                            'customer_id' => $id,
                            'created_at' => Carbon::now(),
                        ];
                    }
                    \DB::table('exported_customers')->insert($insertData);
                }
            }

            $retVal = [
                "file_path" => $filePath,
                "exported_count" => count($newCustomerIds)
            ];
        }
        return $retVal;
    }

    private function appendByCustomer($locale, $firstId, $lastId)
    {
        $filePath = public_path("customer/" . $this->getDomain() . "_" . $locale . '_customer_email.csv');
        $getCustomer = \DB::table(\DB::raw('`' . env('DB_DATABASE_CUSTOMER', 'printerval_customer') . '`.`customer`'))
            ->where('id', '>', $firstId)
            ->where('id', '<=', $lastId)
            ->where('status', 'ACTIVE')
            ->select('email')
            ->get();
        if ($getCustomer->isNotEmpty()) {
            $this->dataExportService->appendCsvFileUniqueColumn($filePath, $getCustomer->toArray(), ['email'], 'email');
        }
        $retVal = [
            "file_path" => $filePath,
            "exported_count" => count($getCustomer)
        ];
        return $retVal;
    }

}