<?php

namespace Modules\Ads\Controllers;

use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\FeedService;
use Modules\Ads\Controllers\Service\MerchantProduct;


class FeedController extends Controller
{
    private $feedService;
    public function __construct(FeedService $feedService)
    {
        $this->feedService = $feedService;
    }
    public function cronCreatePageFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = [
            'status' => 'ACTIVE',
            'is_trademark' => 0,
            'is_violation' => 0,
            'approve_advertising' => 1,
        ];
        if(array_key_exists('product_id_from',$input)){
            $filter['product_id_from'] = $input['product_id_from'];
        }
        if(!array_key_exists('ignore_updated_at',$input)){
            $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
        }
        if(array_key_exists('product_id_to',$input)){
            $filter['product_id_to'] = $input['product_id_to'];
        }
        if(array_key_exists('updated_at_from',$input)){
            $filter['updated_at_from'] = $input['updated_at_from'];
        }
        if(array_key_exists('updated_at_to',$input)){
            $filter['updated_at_to'] = $input['updated_at_to'];
        }
        if(array_key_exists('sold_from',$input)){
            $filter['sold_from'] = $input['sold_from'];
        }
        if(array_key_exists('ids',$input)){
            $filter['ids'] = $input['ids'];
        }
        $filter['columns'] = [
                // ORIGIN
                'product.id',
                'product.slug',
                'product.name',
                // SKU
                'product_data_feed.product_resource',
                'product_data_feed.product_map_feed_resource',
                'product_data_feed.account_id'
        ];
        $query = $this->feedService->buidFilter($filter);
        $count = 0;
        $input['prefixUrl'] = $prefixUrl;
        $products = $query->get();
        foreach ($products as $product){
            $isCreated = $this->feedService->createPageFeed($product,$input);
            if ($isCreated){
                $count ++;
            }
        }
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    public function cronRemovePageFeed(Request $request){
        set_time_limit(60 * 10);
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $input = $request->all();
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
                }
            }
        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d H:i:s",strtotime('-2 hours'));
            }
        }
        $query = $this->feedService->buildDeleteQuery($filter);
        $products = $query->get();
        $count = $this->feedService->deletePageFeed($products, $input);
        return response()->json(['status' => 'successful', 'count' => $count]);
    }

}
