<?php

namespace Modules\Ads\Controllers;

use Modules\Ads\Controllers\Service\GoogleMerchantService;
use Google\Service\ShoppingContent\SearchRequest;
use Illuminate\Support\Facades\DB;
use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Controllers\Exception;
use Modules\Ads\Controllers\Service\CustomerService;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Controllers\Service\MerchantService;
use Modules\Ads\Controllers\Service\ProductAdsService;
use Modules\Ads\Models\Category;
use Modules\Ads\Models\Product;
use Modules\Ads\Builders\QueryBuilder;


class GoogleMerchantController extends Controller
{
    private $queue;
    private $productAdsService;
    private $languages;
    private $currencyCode;
    private $languageCode;

    private $merchantId;
    private $merchantProductContentController;
    private $googleMerchantService;
    public function __construct(ProductAdsService $productAdsService, MerchantProductContentController $merchantProductContentController, GoogleMerchantService $googleMerchantService)
    {
        $this->languages = \Config::get('ads::clara-ads-general.languages',[]);
        $this->merchantProductContentController = $merchantProductContentController;
        $this->googleMerchantService = $googleMerchantService;
        $this->productAdsService = $productAdsService;
        $this->currencyCode = env('CURRENCY_UNIT','USD');
        $this->languageCode = env('APP_LANG','en');
        $this->merchantId = getOption('merchant_id', '398409240');
        $this->queue = \Config::get('ads::ads.queue',[]);
    }
    public function insert(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $input['status'] = 'ACTIVE';
        if(!array_key_exists('ignore_updated_at',$input) && !array_key_exists('updated_at_from',$input)){
            $input['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
        }
        $retVal = $this->updateProduct($input);
        return response()->json($retVal);

    }

    private function updateProduct($input){
        $localeData = $this->getLocaleData();
        $prefixUrl = $localeData['prefixUrl'];
        $countryCode = $localeData['countryCode'];
        $query = $this->productAdsService->buildProductAdsFilter($input);
        $products = $query->get();
        $data = $this->googleMerchantService->buildProduct($products,[
            'prefixUrl' => $prefixUrl,
            'country' => $countryCode,
            'language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'),
            'currency' => $this->currencyCode,
        ]);
        $count = count($data);
        $message = $this->merchantProductContentController->insertByService($data,['country' => $countryCode]);
        $lastId = null;

        if ($count > 0 && isset($data[$count -1 ]['id'])){
            $lastId = $data[$count -1 ]['id'];
        }
        return ['status' => 'successful','message' => $message, 'count' => $count, 'lastId' => $lastId];
    }

    public function delete(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $input['status'] = 'PENDING';
        if(!array_key_exists('ignore_updated_at',$input) && !array_key_exists('updated_at_from',$input)){
            $input['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
        }
        $retVal = $this->remove($input);
        return response()->json($retVal);
    }

    private function remove($input){
        $localeData = $this->getLocaleData();
        $countryCode = $localeData['countryCode'];
        $query = $this->googleMerchantService->buildDeleteQuery($input);
        $products = $query->get();
        $language = isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG');
        $input['country'] = $countryCode;
        $input['language'] = $language;
        $data = $this->googleMerchantService->buildProductDelete($products, $input);
        $count = count($data);
        $message = $this->merchantProductContentController->deleteByService($data,[
            'country' => $countryCode,
            'language' => $language,
        ]);
        return ['status' => 'successful','message' => $message, 'count' => $count, 'lastId' => $lastId];
    }
}
