<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Module;
use Modules\Ads\Models\Product;
use RecursiveIteratorIterator;
use RecursiveDirectoryIterator;

class HomeController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from ProductInteraction Module HomeController";
        }, 5);
    }
    public function index(Request $request)
    {
        $message = config("ads::app.message");
        return view('ads::product-react.index', [
            'message' => $message,
        ]);
    }
    public function productCategoryInteraction(Request $request)
    {
        $message = config("ads::app.message");
        return view('ads::product-category.index', [
            'message' => $message,
        ]);
    }

    public function updateIsViolation(Request $request) {
        $retVal = [
            'status' => 'successful',
            'result' => 0,
        ];
        if ($request->has('product_ids') && $request->has('is_violation')) {
            $ids = $request->get('product_ids');
            $ids = explode(',', $ids);
            foreach ($ids as $id) {
                $product = Product::find($id);
                $product->is_violation = $request->get('is_violation');
                $product->timestamps = false;
                $product->save();
            }
            $retVal['result'] = 1;
        }

        return $retVal;
    }
    public function updateIsAlwaysOnAds(Request $request) {
        $retVal = [
            'status' => 'successful',
            'result' => 0,
        ];
        if ($request->has('product_ids') && $request->has('is_always_on_ads')) {
            $ids = $request->get('product_ids');
            $ids = explode(',', $ids);
            foreach ($ids as $id) {
                $product = Product::find($id);
                $product->is_always_on_ads = $request->get('is_always_on_ads');
                $product->timestamps = false;
                $product->save();
            }
            $retVal['result'] = 1;
        }

        return $retVal;
    }

    public function approveByLink() {
        return view('ads::bulk.approve-by-link');
    }

    public function approveProducts() {
        $staffs = \DB::table('users')
            ->whereIn('role', ['ADMIN', 'STAFF'])
            ->get(['id', 'name']);

        return view('ads::bulk.approve-product', [
            'staffs' => $staffs
        ]);
    }

    public function setting() {
        return view('ads::setting.ads-setting');
    }

    public function shoppingFeed() {
        return view('ads::shopping-feed.index');
    }

    public function pageFeed() {
        return view('ads::page-feed.index');
    }

    public function remarketingFeed() {
        return view('ads::remarketing-feed.index');
    }

    public function merchantCategory() {
        return view('ads::merchant-category.index');
    }

    public function sizeColorMapping() {
        $generalConfig = \Config::get('ads::clara-ads-general');
        return view('ads::size-color-mapping.index', ['generalConfig' => $generalConfig]);
    }

    public function advertising() {
        return view('ads::advertising.index');
    }

    public function incorrectLanguage() {
        return view('ads::incorrect-language.index');
    }

    public function productPrice() {
        return view('ads::product-price.index');
    }

    public function importFacebookCost(Request $request){
        set_time_limit(3000);
        $response = [];
        $file = $request->file('file');
        $err = '';

        $filename = $file->getClientOriginalName();
        // create log file import
        $directoryPath = 'files/import-ads-cost';
        if (!file_exists($directoryPath)) {
            mkdir($directoryPath, 0777, true);
        }

        $filename = date('Y-m-d_H-i-s', time()) . '_' .$filename;
        $file->move($directoryPath, $filename);
        $filePath = $directoryPath.'/'.$filename;
        try {
            try{
                $fileHandle = fopen($filePath, "r");
            }catch (\Exception $ex){
                $fileHandle = FALSE;
            }
            if ($fileHandle !== FALSE){
                $limit = 1000;
                //Set up a variable to hold our current position in the file
                $offset = 0;
                $indexs = [
                    'account_key' =>'ID tài khoản|Account ID',
                    'campaign_id' =>'ID chiến dịch|Campaign ID',
                    'campaign_name' =>'Tên chiến dịch|Campaign name',
                    'cost' =>'đã chi tiêu|spent',
                    'date' =>'Bắt đầu|Reporting starts',
                    'hour' =>'Thời gian trong ngày|Time of day'
                ];
                while(!feof($fileHandle))
                {
                    $stream = fopen('php://temp', 'w');
                    //Go to where we were when we ended the last batch
                    fseek($fileHandle, $offset);
                    $i = 0;
                    $campaignData = [];
                    while (($currRow = fgetcsv($fileHandle)) !== FALSE)
                    {
                        $i++;
                        if ($i == 1 && $offset == 0){
                            for ($j = 0; $j < count($currRow); $j ++){
                                $string = $currRow[$j];
                                foreach ($indexs as $key => $pattern){
                                    if (preg_match("/$pattern/", $string)) {
                                        $indexs[$key] = $j;
                                    }
                                }

                            }
                        }else{
                            $originDate = $currRow[$indexs['date']];
                            $timeRange = $currRow[$indexs['hour']];
                            $times = explode('-', $timeRange);
                            $originDate .= ' ' . trim($times[0]);
                            $adsCostData = [
                                'account_key' => $currRow[$indexs['account_key']],
                                'campaign_id' => $currRow[$indexs['campaign_id']],
                                'cost' => $currRow[$indexs['cost']],
                                'currency' => 'USD',
                                'campaign_name' => $currRow[$indexs['campaign_name']],
                                'origin_date' => $originDate,
                                'origin_time_zone' => 'Asia/Hong_Kong'
                            ];
                            $campaignData[] = $adsCostData;
                        }


                        //If we hit our limit or are at the end of the file
                        if($i >= $limit)
                        {
                            //Update our current position in the file
                            $offset = ftell($fileHandle);
                            //Break out of the row processing loop
                            break;
                        }
                    }
                    $this->saveAdsCost(['ads_type' => 'facebook','campaignData' => $campaignData]);
                    rewind($stream);
                    fclose($stream);
                }
                fclose($fileHandle);

            }

        } catch (Exception $e) {
            $err = 'Import Fail : '. $e->getMessage();
        }

        if(!$err){
            $response['status'] = 'successful';
            $response['message'] = 'Import successful!';

        }else{
            $response['status'] = 'fail';
            $response['message'] = $err;
        }

        return response()->json($response);
    }

    private function saveAdsCost($input){
        $url = \Config::get('ads::ads.bingadsDomain','https://bingads.agoz.me') . '/ads/save-cost';
        $this->triggerSyncRequest($url,'POST', $input,['Content-Type: application/json']);
    }

    public function getListFile(){
        $folderPath = 'files/import-ads-cost';
        $retVal = [];
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($folderPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($iterator as $file) {
            if ($file->isFile()) {
                $retVal[] = $file->getFileName();
            }
        }
        return response()->json($retVal);
    }
}
