<?php

namespace Modules\Ads\Controllers;

use App\Modules\Ads\Controllers\Service\IncorrectLanguageService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use GuzzleHttp\Client;

class IncorrectLanguageController extends Controller
{
    const BATCH_SIZE = 100;
    const LIMIT = 500;
    protected $incorrectLanguageService;

    public function __construct(
        IncorrectLanguageService $incorrectLanguageService
    )
    {
        $this->incorrectLanguageService = $incorrectLanguageService;
    }

    public function find(Request $request)
    {
        if ($request->get('token') != 'VVCTTQUhXuPCKYu') {
            return response()->json(['status' => 'failed', 'meta' => [], 'result' => []]);
        }
        $response = $this->incorrectLanguageService->getData($request->all());
        return response()->json($response);
    }

    public function classifyData(Request $request)
    {
        if ($request->get('token') != 'VVCTTQUhXuPCKYu') {
            return response()->json(['status' => 'failed', 'result' => []]);
        }
        set_time_limit(3600);
        $file = $request->file('csv_file');
        $inputFileType = \PHPExcel_IOFactory::identify($file);
        $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
        $objPHPExcel = $objReader->load($file);

        // choose page
        $sheet = $objPHPExcel->setActiveSheetIndex(0);
        // get amount of rows
        $totalRow = $sheet->getHighestRow();

        $data = [];

        // csv file type
//        $delimiter = "\t"; // Default delimiter is tab
//
//        for ($i = 2; $i <= $totalRow; $i++) {
//            $row = $sheet->getCellByColumnAndRow(0, $i)->getValue();
//            if (strpos($row, ';') !== false) {
//                $delimiter = ";"; // If semicolon is found, switch to semicolon delimiter
//            }
//
//            $rowArray = str_getcsv($row, $delimiter);
//            $key = $rowArray[1] . '-' . $rowArray[2];
//
//            $data[$key][] = [
//                'sku' => $rowArray[0],
//                'name' => $rowArray[3],
//            ];
//        }

        //xlsx file type
        for ($i = 2; $i <= $totalRow; $i++) {
            $data[$sheet->getCellByColumnAndRow(1, $i)->getValue() . '-' . $sheet->getCellByColumnAndRow(2, $i)->getValue()][] = [
                'sku' => $sheet->getCellByColumnAndRow(0, $i)->getValue(),
                'name' => $sheet->getCellByColumnAndRow(3, $i)->getValue()
            ];
        }

        if (!empty($data)) {
            $client = new Client();
            foreach ($data as $key => $value) {
                // send data to each locale database
                $locale = explode('-', $key);
                if ($locale[0] == 'GB') {
                    $locale[0] = '/' . 'uk';
                } elseif ($locale[0] == 'US') {
                    $locale[0] = '';
                } else {
                    $locale[0] = '/' . strtolower($locale[0]);
                }
                $url = Url::to('/') . $locale[0] . '/ads/incorrect-language/store-data';
                \Log::info(['LogUrlStore', $url]);

                // Batch size for sending data
                $chunks = array_chunk($value, self::BATCH_SIZE);

                foreach ($chunks as $dataSend) {
                    $response = $client->post($url, [
                        'json' => [
                            'data' => $dataSend,
                            'token' => 'VVCTTQUhXuPCKYu'
                        ]
                    ]);

                    $responseData = json_decode($response->getBody(), true);
                    \Log::info(['LogImportCSV', $responseData]);
                    if (empty($responseData['status']) || $responseData['status'] != 'successful') {
                        return response()->json($responseData);
                    }
                }
            }
        }
        return redirect()->route('incorrect-language::index');
    }

    public function storeData(Request $request)
    {
        if ($request->get('token') != 'VVCTTQUhXuPCKYu') {
            return response()->json(['status' => 'failed', 'result' => []]);
        }
        $data = $request->get('data');
        if (!empty($data)) {
            \DB::table('incorrect_language')->insert($data);
            return response()->json(['status' => 'successful']);
        }
        return $data;
    }

    public function translate(Request $request)
    {
        if ($request->get('token') != 'VVCTTQUhXuPCKYu') {
            return response()->json(['status' => 'failed', 'result' => []]);
        }
        set_time_limit(3600);
        $productsIncorrectLanguage = DB::table('incorrect_language')
            ->select('sku', 'name')
            ->where('is_translate', 0)
            ->get();

        $total = 0;

        // Batch size for sending data
        $productChunks = array_chunk($productsIncorrectLanguage->toArray(), self::BATCH_SIZE);

        foreach ($productChunks as $chunk) {
            $dataSend = ['data' => []];

            foreach ($chunk as $item) {
                $dataSend['data'][] = [
                    'code' => $item->sku,
                    'content' => $item->name,
                    'target' => env('LANGUAGE_CODE')
                ];
                $total++;
            }

            $this->sendAndProcessData($dataSend);
        }

        return response()->json(['status' => 'successful', 'total' => $total]);
    }

    private function sendAndProcessData($dataSend)
    {
        if (!empty($dataSend['data'])) {
            $url = 'https://language-detector.megaads.fun/new-translation';
            $response = $this->triggerAsyncRequestPost($url, json_encode($dataSend));
            if (!empty($response) && !empty($response['result'])) {
                // Update all translated contents by is_translate = 1
                $translatedSkus = array_keys($response['result']);
                $skus = [];
                foreach ($translatedSkus as $sku) {
                    $skus[] = "'$sku'";
                }
                $skus = implode(',', $skus);
                $sql = "UPDATE `sb_incorrect_language` SET is_translate = 1 WHERE `sku` in ({$skus})";

                // filter translated content but that is equal to previous content
                foreach ($dataSend['data'] as $item) {
                    if (!empty($response['result'][$item['code']]) && $item['content'] == $response['result'][$item['code']]) {
                        unset($response['result'][$item['code']]);
                    }
                }
                $this->bulkUpdate($response['result']);
                DB::update($sql);
            }
        }
    }

    private function bulkUpdate($data)
    {
        $cases = [];
        $skus = [];

        foreach ($data as $sku => $translate_name) {
            $content = str_replace("'", '"', $translate_name);
            $skus[] = "'$sku'";
            $cases[] = "WHEN '$sku' then '$content'";
        }
        $skus = implode(',', $skus);
        $cases = implode(' ', $cases);
        $sql = "UPDATE `sb_incorrect_language` SET `translate_name` = CASE `sku` {$cases} END WHERE `sku` in ({$skus})";

        DB::update($sql);
    }

    public function updateToProduct(Request $request)
    {
        if ($request->get('token') != 'VVCTTQUhXuPCKYu') {
            return response()->json(['status' => 'failed', 'result' => []]);
        }
        set_time_limit(3600);
        $productsTranslated = DB::table('incorrect_language')
            ->select('sku', 'translate_name')
            ->where('is_translate', 1)
            ->where('translate_name', '<>', null)
            ->where('is_update', 0)
            ->get()->toArray();

        $total = 0;
        if (!empty($productsTranslated)) {
            $chunkSize = min(500, count($productsTranslated));
            $chunks = array_chunk($productsTranslated, $chunkSize);
            foreach ($chunks as $chunk) {
                $dataProduct = [
                    'update-by-id' => [],
                    'update-by-sku' => []
                ];

                foreach ($chunk as $item) {
                    $key = explode('-', $item->sku);

                    if (!empty($key[1]) && $key[0][0] == 'P') {
                        $dataProduct['update-by-id'][substr($key[0], 1)] = $item->translate_name;
                    } else {
                        $dataProduct['update-by-sku'][$item->sku] = $item->translate_name;
                    }
                    $total++;
                }
                $this->updateBulkProduct($dataProduct);
            }
        }
        return response()->json(['status' => 'successful', 'total' => $total]);
    }

    private function updateBulkProduct($dataProduct)
    {
        $now = date('Y-m-d H:i:s');
        if (!empty($dataProduct['update-by-id'])) {
            $cases = [];
            $ids = [];
            foreach ($dataProduct['update-by-id'] as $id => $translate_name) {
                $ids[] = $id;
                $cases[] = "WHEN $id then '$translate_name'";
            }
            $ids = implode(',', $ids);
            $cases = implode(' ', $cases);
            $sql = "UPDATE `sb_product` SET `name` = CASE `id` {$cases} END, `updated_at` = '{$now}' WHERE `id` in ({$ids})";
            DB::update($sql);
        }

        if (!empty($dataProduct['update-by-sku'])) {
            $cases = [];
            $skus = [];
            foreach ($dataProduct['update-by-sku'] as $sku => $translate_name) {
                $skus[] = "'$sku'";
                $cases[] = "WHEN '$sku' then '$translate_name'";
            }
            $skus = implode(',', $skus);
            $cases = implode(' ', $cases);
            $sql = "UPDATE `sb_product` SET `name` = CASE `sku` {$cases} END, `updated_at` = '{$now}' WHERE `sku` in ({$skus})";
            DB::update($sql);
        }
        $limit = self::LIMIT;
        return DB::update("UPDATE `sb_incorrect_language` SET is_update = 1 WHERE is_translate = 1 and is_update = 0 LIMIT {$limit}");
    }
}