<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\DB;
use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\BingController;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Controllers\Service\BingProductService;
use Modules\Ads\Controllers\Service\BingService;
use Modules\Ads\Controllers\Service\GoogleMerchantService;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Controllers\Service\ProductAdsService;
use Modules\Ads\Models\Product;


class MicrosoftMerchantController extends Controller
{
    private $merchantProductService;
    private $bingProductService;
    private $merchantServiceConfig;
    private $bingController;
    private $productAdsService;
    private $googleMerchantService;
    private $currencyCode;
    private $queue;
    private $languages;
    public function __construct(
        MerchantProductService $merchantProductService,
        BingController $bingController,
        BingProductService $bingProductService,
        ProductAdsService $productAdsService,
        GoogleMerchantService $googleMerchantService
    )
    {
        $this->merchantProductService = $merchantProductService;
        $this->bingController = $bingController;
        $this->productAdsService = $productAdsService;
        $this->bingProductService = $bingProductService;
        $this->googleMerchantService = $googleMerchantService;
        $this->currencyCode = env('CURRENCY_UNIT','USD');
        $this->merchantServiceConfig = \Config::get('ads::ads.merchant_service',[]);
        $this->queue = \Config::get('ads::ads.queue',[]);
        $this->languages = \Config::get('ads::clara-ads-general.languages',[]);
    }
    public function insert(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $input['status'] = 'ACTIVE';
        if(!array_key_exists('ignore_updated_at',$input) && !array_key_exists('updated_at_from',$input)){
            $input['updated_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
        }
        $retVal = $this->updateProduct($input);
        return response()->json($retVal);

    }

    private function updateProduct($input){
        $localeData = $this->getLocaleData();
        $prefixUrl = $localeData['prefixUrl'];
        $countryCode = $localeData['countryCode'];
        $query = $this->productAdsService->buildProductAdsFilter($input);
        $products = $query->get();
        $inputData = [
            'prefixUrl' => $prefixUrl,
            'country' => $countryCode,
            'language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'),
            'currency' => $this->currencyCode,
        ];
        $inputData['merchant_id'] = $this->bingProductService->getMerchantId();
        if (array_key_exists('catalog_id',$input)){
            $inputData['catalog_id'] = $input['catalog_id'];
        }
        $data = $this->googleMerchantService->buildProduct($products,$inputData);
        $count = count($data);
        $message = $this->bingController->insertByService($data,$inputData);
        $lastId = null;

        if ($count > 0 && isset($data[$count -1 ]['id'])){
            $lastId = $data[$count -1 ]['id'];
        }
        return ['status' => 'successful','message' => $message, 'count' => $count, 'lastId' => $lastId];
    }

}
