<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class PendingProductController extends Controller
{
    public function list()
    {
        $staffs = $this->getStaffs();
        
        return view('ads::pending-product.index', [
            'staffs' => $staffs
        ]);

    }

    protected function getStaffs()
    {
        $staffs = \DB::table('users')
            ->where('role', 'STAFF')
            ->where('status', 'ACTIVE')
            ->select(['id', 'name'])
            ->get();

        return $staffs;
    }

    public function getProductCountByStaff()
    {
        $products = DB::table('ads_pending_product')
            ->join('product_n_user', 'product_n_user.product_id', 'ads_pending_product.product_id')
            ->join('users', 'product_n_user.user_id', 'users.id')
            ->where('ads_pending_product.product_id', '>', 0)
            ->where('users.role', 'STAFF')
            ->where('users.status', 'ACTIVE')
            ->selectRaw('user_id, COUNT(*) as count, sb_users.name')
            ->groupBy('user_id')
            ->get();

        return $products;
    }

    public function getProducts(Request $request)
    {
        $staffId = $request->input('staffId', null);
        $filter = $this->buildFilter($request->all());
        $query = DB::table('ads_pending_product')
            ->select('ads_pending_product.*', 'users.name as user_name')
            ->where('ads_pending_product.product_id', '>', 0)
            ->join('product_n_user', 'product_n_user.product_id', 'ads_pending_product.product_id')
            ->join('users', 'product_n_user.user_id', 'users.id');
        if ($filter['fromDate']) {
            $query->where('ads_pending_product.created_at', '>=', $filter['fromDate']);
        }
        if ($filter['toDate']) {
            $query->where('ads_pending_product.created_at', '<=', $filter['toDate']);
        }
        if ($filter['reason']) {
            $query->where('ads_pending_product.note', 'like', '%'.  $filter['reason'] . '%');
        }
        if ($staffId) {
            $query->where('product_n_user.user_id', $staffId);
        }

        $products = $query->paginate(100);

        return $products;
    }

    protected function buildFilter($filters)
    {
        $retVal = [];
        foreach ($filters as $key => $value) {
            $retVal[$key] = $value;
        }
        return $retVal;
    }
}