<?php

namespace Modules\Ads\Controllers;

use Modules\Ads\Controllers\Service\ProductAdsService;
use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Controllers\Exception;


class ProductAdsController extends Controller
{
    private $productAdsService;
    private $languages;
    private $queue;
    private $currencyCode;
    public function __construct(ProductAdsService $productAdsService)
    {
        $this->productAdsService = $productAdsService;
        $this->languages = \Config::get('ads::clara-ads-general.languages',[]);
        $this->queue = \Config::get('ads::ads.queue',[]);
        $this->currencyCode = env('CURRENCY_UNIT','USD');
    }

    public function buildProductAds(Request $request){
        $input = $request->all();
        $localeData = $this->getLocaleData();
        $prefixUrl = $localeData['prefixUrl'];
        $countryCode = $localeData['countryCode'];
        $filter = array_merge($this->getDefaultFilter(),$input);
        $query = $this->productAdsService->buildProductFilter($filter);
        $products = $query->get();
        $input = [
            'currency' => $this->currencyCode,
            'prefixUrl' => $prefixUrl,
            'country' => $countryCode,
            'language' => isset($this->languages[$countryCode]) ? $this->languages[$countryCode] : env('APP_LANG'),
        ];
        $data = $this->productAdsService->buildProduct($products,$input);
        $result = $this->productAdsService->bulkInsertOrUpdateProducts($data);
        return response()->json(['status' => 'successful', 'data' => $result]);
    }

    private function getDefaultFilter(){
        $filter = [
            'status' => 'ACTIVE',
            'approve_advertising' => 1,
            'is_trademark' => 0,
            'is_violation' => 0,
            'is_default' => 1,
        ];
        $filter['columns'] = [
            // ORIGIN
            'product.id',
            'product.slug', 'product.image_url',
            'product.is_trademark',
            'product.actor_id',
            'product.created_at',
            'product.sold',
            'product.barcode',
            // SKU
            'product_info.name as sku_name',
            'product_info.name as title_replacement',
            'product_info.variants as sku_specific_info',
            'product_info.brand as sku_brand',
            'product_info.sku as sku_code',
            'product_info.slug as sku_slug',
            'product_info.price',
            'product_info.high_price',
            'product_info.category_merchant_id as sku_category_merchant_id',
            'product_info.product_sku_id',
            'product_info.product_sku_id as sku_id',
            'product_info.is_default',
            'product.name',
        ];
        return $filter;
    }

    public function updateStatus(Request $request){
        $input = $request->all();
        $result = $this->productAdsService->updateAdsStatus($input);
        return response()->json($result);
    }
    public function updateSold(Request $request){
        $input = $request->all();
        $result = $this->productAdsService->updateSold($input);
        return response()->json($result);
    }

    public function getMaxId(Request $request){
        return $this->productAdsService->getMaxProductAdId();
    }
    public function getMaxTableId(Request $request){
        $tableName = $request->input('table_name','merchant_product');
        $column = $request->input('column','id');
        return $this->productAdsService->getMaxTableId($tableName,$column);
    }



}
