<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Modules\Ads\Models\Click;
use Modules\Ads\Models\ProductApproveAdvertising;

class ProductApproveAdvertisingService extends Controller
{
    public function index()
    {
        return view('ads::product-approve-advertising.index');
    }

    public function find(Request $request) {
        $filter = $this->buildFilter($request);
        $columns = $filter['columns'];
        $type = $request->input("zero_click", 0);
        
        if ($type == "no_click") {
            $retval = $this->getClickSort($filter, $request);
            $listProductSku = $retval["listProductSku"];
            $filter["not_skus"] = $listProductSku;
            $query = ProductApproveAdvertising::buildProductAdvertisingQuery($filter);

            //Get count
            $queryCount = clone $query;
            $queryCount->select($columns);
            $count = DB::table(DB::raw("(" . $queryCount->toSql() . ") AS x"))
                ->mergeBindings($queryCount->getQuery())
                ->count();

            //Get items
            $filter["page_id"] = $request->input("page_id", 0);
            $filter["page_size"] = $request->input("page_size", 100);
            $pageCount = $this->recordsCountToPagesCount($count, $filter['page_size']);
            
            $items = $this->getItems($query, $filter);
            $listProductSku = [];
            foreach ($items as $key => $value) {
                $listProductSku[] = $value->code;
            }
        } else if ($type == "has_click") {
            //Get count
            $retval = $this->getClickSort($filter, $request);
            $listProductSku = $retval["listProductSku"];
            $pageCount = $retval["pageCount"];
            $count = $retval["count"];
            $filter["skus"] = $listProductSku;
            $query = ProductApproveAdvertising::buildProductAdvertisingQuery($filter);

            //Get items
            $filter["page_id"] = 0;
            $filter["page_size"] = $request->input("page_size", 100);
            $items = $this->getItems($query, $filter);
        } else { 
            $query = ProductApproveAdvertising::buildProductAdvertisingQuery($filter);

            //Get count
            $queryCount = clone $query;
            $queryCount->select($columns);
            $count = DB::table(DB::raw("(" . $queryCount->toSql() . ") AS x"))
                ->mergeBindings($queryCount->getQuery())
                ->count();
            
            $filter["page_size"] = $request->input("page_size", 100);
            $filter["page_id"] = $request->input("page_id", 0);
            $pageCount = $this->recordsCountToPagesCount($count, $filter['page_size']);

            //Get items
            $items = $this->getItems($query, $filter);
            
            $listProductSku = [];
            foreach ($items as $key => $value) {
                $listProductSku[] = $value->code;
            }
        }
        $this->getItemClick($listProductSku, $filter, $items);
        $items = $items->toArray();
        if ($request->has("sort")) {
            $sort = $request->input('sort');
            $this->rebuildSortItems($items, $sort);
        }

        $meta = [
            "has_next" => $filter["page_size"] + 1 < $pageCount,
            "off_set" => $filter["page_size"] * $filter["page_id"],
            "page_count" => $pageCount,
            "page_id" => $filter["page_id"],
            "total_count" => $count,
            "page_size" => $filter["page_size"],
        ];
        $response = array(
            "status" => 'successful',
            "result" => $items,
            "meta" => $meta,
        );
        return response()->json($response);
    }

    private function buildFilter($request){
        $retVal = [];
        if ($request->has('search')){
            $retVal['search'] = $request->input('search');
        }
        if ($request->has('advertising_status')){
            $retVal['advertising_status'] = $request->input('advertising_status');
        }
        if ($request->has('dateFrom')){
            $retVal['date_from'] = $this->getDateTimeFilter($request->input('dateFrom'));
        }
        if ($request->has('dateTo')){
            $toDateTime = $this->getDateTimeFilter($request->input('dateTo'));
            $toDateTime->setTime("23", "59", "59");
            $retVal['date_to'] = $toDateTime;
        }
        if ($request->has('order')){
            $order = explode("_",$request->input('order'));
            $retVal['order'] = [
                'column' => $order[0],
                'direction' => $order[1],
            ];
        }
        $retVal['columns'] = [
            'product_approve_advertising.id', 'product_approve_advertising.product_id', 'product_approve_advertising.code',
            'product_approve_advertising.title', 'product_approve_advertising.description', 'product_approve_advertising.brand', 'advertising_status', 'product_approve_advertising.updated_at', 'product_approve_advertising.ctr'
        ];
        return $retVal;
    }

    private function getItems($query, $filter)
    {
        $pageId = $filter["page_id"] + 1;
        $pageSize = $filter["page_size"];
        if (array_key_exists('order', $filter)) {
            $order = $filter['order'];
            $query->orderBy($order['column'], $order['direction']);
        }
        if ($pageSize > 0) {
            $query->forPage(($filter["page_id"] + 1), $filter["page_size"]);
        }
        return $query->get($filter['columns']);
    }

    protected function recordsCountToPagesCount($recordsCount, $pageSize) {
        $retVal = (int) ($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        //return
        return $retVal;
    }

    protected function getDateTimeFilter($dateTime, $format = "d/m/Y") {
        $retval = FALSE;
        if (is_object($dateTime)) {
            $retval = clone $dateTime;
        }
        if ($dateTime == NULL || $dateTime == "") {
            $dateTime = "1/1/1900";
        }
        if (is_string($dateTime)) {
            $retval = \DateTime::createFromFormat($format, $dateTime);
        }
        $retval->setTime("00", "00", "00");

        return $retval;
    }

    private function rebuildSortItems(&$items, $sort) {
        if ($sort == "adwords_down") {
            usort($items, function ($a, $b) {
                return $a['click']["adwords"] <= $b['click']["adwords"] ? +1 : -1;
            });
        }
        if ($sort == "adwords_up") {
            usort($items, function ($a, $b) {
                return $a['click']["adwords"] >= $b['click']["adwords"] ? +1 : -1;
            });
        }
        if ($sort == "google_down") {
            usort($items, function ($a, $b) {
                return $a['click']["google"] <= $b['click']["google"] ? +1 : -1;
            });
        }
        if ($sort == "google_up") {
            usort($items, function ($a, $b) {
                return $a['click']["google"] >= $b['click']["google"] ? +1 : -1;
            });
        }
        if ($sort == "bing_down") {
            usort($items, function ($a, $b) {
                return $a['click']["bing ads"] <= $b['click']["bing ads"] ? +1 : -1;
            });
        }
        if ($sort == "bing_up") {
            usort($items, function ($a, $b) {
                return $a['click']["bing ads"] >= $b['click']["bing ads"] ? +1 : -1;
            });
        }
    }

    private function getClickSort($filter, $request) {
        $sort = $request->input('sort', false);
        $type = $request->input("zero_click", "all");
        $queryClicks = Click::where("date", ">=", $filter["date_from"])->where("date", "<=", $filter["date_to"]);
        $queryClicks->join("product_approve_advertising", "code", "=", "sku");
        if (array_key_exists("search", $filter)) {
            $queryClicks->where(function($where) use ($filter) {
                $where->where('product_approve_advertising.title', 'like', '%' . $filter['search'] . '%')
                    ->orWhere('product_approve_advertising.code',  'like', '%' . $filter['search'] . '%')
                    ->orWhere('product_approve_advertising.product_id',  'like', '%' . $filter['search'] . '%');
            });
        }
        if (array_key_exists("advertising_status", $filter)) {
            $queryClicks->where("product_approve_advertising.advertising_status", $filter["advertising_status"]);
        }
        if ($sort) {
            $typeSort = explode("_", $sort);
            if ($typeSort[0] == "bing") {
                $typeSort[0] = "bing ads";
            }
            if ($typeSort[1] == "down") {
                $typeSort[1] = "DESC";
            } else {
                $typeSort[1] = "ASC";
            }
            $queryClicks->where("source", $typeSort[0])
                        ->groupBy("sku")
                        ->orderBy("total_click", $typeSort[1]);
        } else {
            $queryClicks->groupBy("sku");
        }

        $count = 0;
        $pageCount = 0;
        if ($type == "has_click") {
            $queryCount = clone $queryClicks;
            $queryCount->select(["click.sku", DB::raw('SUM(clicks) as total_click')]);
            $count = DB::table(DB::raw("(" . $queryCount->toSql() . ") AS x"))
                ->mergeBindings($queryCount->getQuery())
                ->count();
            $pageSize = $request->input("page_size", 100);
            $pageId = $request->input("page_id", 0);
            $pageCount = $this->recordsCountToPagesCount($count, $pageSize);
            if ($pageSize > 0) {
                $queryClicks->forPage(($pageId + 1), $pageSize);
            }
        }
        
        $totalClicks = $queryClicks->get(["click.sku", DB::raw('SUM(clicks) as total_click')]);
        $listProductSku = [];
        foreach ($totalClicks as $key => $value) {
            $listProductSku[] = $value->sku;
        }
        $retval = [
            "listProductSku" => $listProductSku,
            "pageCount" => $pageCount,
            "count" => $count,
        ];
        return $retval;
    }

    private function getItemClick($listProductSku, $filter, &$items) {
        $clicks = Click::whereIn("sku", $listProductSku)
            ->whereIn("sku", $listProductSku)
            ->where("date", ">=", $filter["date_from"])
            ->where("date", "<=", $filter["date_to"])
            ->groupBy("sku")
            ->groupBy("source")
            ->get(["id", "source", "sku", DB::raw('SUM(clicks) as total_click')]);
        $listClickBySku = [];
        foreach ($clicks as $key => $value) {
            if (!array_key_exists($value->sku, $listClickBySku)) {
                $listClickBySku[$value->sku] = [
                    "bing ads" => 0,
                    "adwords" => 0,
                    "google" => 0,
                ];
            }
            $listClickBySku[$value->sku][$value->source] = $value->total_click;
        }
        foreach ($items as $key => $value) {
            $click = [
                "bing ads" => 0,
                "adwords" => 0,
                "google" => 0,
            ];
            if (array_key_exists($value->code, $listClickBySku)) {
                $click["bing ads"] = (int) $listClickBySku[$value->code]["bing ads"];
                $click["adwords"] = (int) $listClickBySku[$value->code]["adwords"];
                $click["google"] = (int) $listClickBySku[$value->code]["google"];
            }
            $value->click = $click;
        }
    }

    public function approvePrinterest(Request $request)
    {
        $ids = $request->input('ids');

        DB::table('product')
            ->whereIn('id', $ids)
            ->update(['approve_advertising' => 1]);

        $user = auth()->user();
        $timestamp = date('Y-m-d H:i:s');
        $dataInserts = array_map(function ($id) use ($user, $timestamp) {
            return [
                'product_id' => $id,
                'type' => 'pinterest',
                'actor_id' => $user->id,
                'updator_id' => $user->id,
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ];
        }, $ids);

        $exists = DB::table('product_feed_approve')
            ->whereIn('product_id', $ids)
            ->where('type', 'pinterest')
            ->pluck('product_id')
            ->toArray();

        $inserts = array_diff($ids, $exists);
        if (!empty($inserts)) {
            $dataInserts = array_filter($dataInserts, function ($key) use ($inserts) {
                return in_array($key['product_id'], $inserts);
            });
            DB::table('product_feed_approve')->insert($dataInserts);
        }
        return response()->json(['status' => 'successful']);
    }
}