<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Models\Campaign;
use Modules\Ads\Models\Click;
use Modules\Ads\Models\ProductCostAds;
use Modules\Ads\Models\ProductSku;

class ProductCostAdsController extends Controller
{
    public function buildProductAdsCost(Request $request) {
        set_time_limit(30 * 60 * 2);
        $response = [
            "status" => "fail"
        ];
        $date = $request->input("date", null);
        if (!$date) {
            $date = new \DateTime();
            $date->modify("-1 day");
        } else {
            $datetime = new \DateTime();
            $date = $datetime->createFromFormat('Y/m/d', $date);
        }
        $searchCampaign = Campaign::where("status", "enabled")->whereIn("campaign_type", ["SEARCH", "DISPLAY"])->get(["campaign_id", "campaign_type"]);
        $shoppingCampaign = Campaign::where("status", "enabled")->whereIn("campaign_type", ["SHOPPING", "PERFORMANCE_MAX"])->get(["campaign_id", "account", "campaign_type"]);
        try {
            $result = [];
            if (count($searchCampaign) > 0) {
                foreach ($searchCampaign as $key => $value) {
                    $hasData = $this->buildCost($value, $date);
                    if ($hasData) {
                        $result[] = $value->campaign_id;
                    }
                }
            }
            if (count($shoppingCampaign) > 0) {
                foreach ($shoppingCampaign as $key => $value) {
                    $hasData = $this->getShoppingCost($value, $date);
                    if ($hasData) {
                        $result[] = $value->campaign_id;
                    }
                }
            }
            $response = [
                "status" => "successful",
                "result" => $result,
            ];
        } catch (\Exception $e) {
            $response["message"] = $e->getMessage() . " - Line: " . $e->getLine();
        }
        return response()->json($response);
    }

    private function buildCost($campaign, $date) {
        $clicks = Click::where("campaign_id", $campaign->campaign_id)
                    ->where("date", $date->format("Y-m-d"))
                    ->groupBy("product_id")
                    ->select(["campaign_id", DB::raw("SUM(clicks) as click"), "product_id"])
                    ->get();
        $hasData = false;
        if (count($clicks) > 0) {
            $campaignCost = $this->getAdsCostByCampaign($campaign->campaign_id, $date);
            $totalClickByCampaign = 0;
            foreach ($clicks as $click) {
                $totalClickByCampaign += (int) $click->click;
            }
            if ($campaignCost > 0) {
                $costPerClick = round($campaignCost / $totalClickByCampaign, 2);
                $listNewData = [];
                foreach ($clicks as $click) {
                    $data = [
                        "product_id" => $click->product_id,
                        "campaign_id" => $campaign->campaign_id,
                        "date" => $date->format("Y-m-d"),
                        "cost" => $costPerClick * $click->click,
                        "campaign_type" => strtoupper($campaign->campaign_type),
                        "created_at" => new \DateTime(),
                        "updated_at" => new \DateTime(),
                    ];
                    $listNewData[] = $data;
                }
                $isExists = ProductCostAds::where("date", $date->format("Y-m-d"))->where("campaign_id", $campaign->campaign_id)->exists();
                if (!$isExists) {
                    ProductCostAds::insert($listNewData);
                    $hasData = true;
                }
            }
        }
        return $hasData;
    }

    private function getShoppingCost($campaign, $date) {
        $hasData = false;
        $shoppingAdsCostUrl = config("ads::ads.shopping_ads_cost_url");
        $token = config("ads::ads.shopping_ads_cost_token");
        $vndRate = config("ads::ads.vnd_rate");
        $url = $shoppingAdsCostUrl . "/shopping-product-cost?date=" . $date->format("Y-m-d") . "&customerId=" . str_replace("-", "", $campaign->account) . "&campaignId=" . $campaign->campaign_id;
        $response = $this->triggerSyncRequest($url, 'GET', [], ["token: $token"]);
        if (isset($response["status"]) && $response["status"] == "successful") {
            if (isset($response["result"]) && count($response["result"]) > 0) {
                $listNewData = [];
                foreach ($response["result"] as $sku => $cost) {
                    $costUsd = round(($cost / 1000000) / $vndRate, 2);
                    $product = ProductSku::where("sku", DB::raw("'$sku'"))->first(["product_id"]);
                    if ($product) {
                        $data = [
                            "product_id" => $product->product_id,
                            "campaign_id" => $campaign->campaign_id,
                            "date" => $date->format("Y-m-d"),
                            "cost" => $costUsd,
                            "campaign_type" => $campaign->campaign_type,
                            "created_at" => new \DateTime(),
                            "updated_at" => new \DateTime(),
                        ];
                        $listNewData[] = $data;
                    }
                }
                $isExists = ProductCostAds::where("date", $date->format("Y-m-d"))->where("campaign_id", $campaign->campaign_id)->exists();
                if (!$isExists) {
                    ProductCostAds::insert($listNewData);
                    $hasData = true;
                }
            }
        }
        return $hasData;
    }

    private function getAdsCostByCampaign($campaignId, $date) {
        $cost = 0;
        $clickerUrl = config("ads::ads.bing_ads_url");
        $url = $clickerUrl . "ads/get-data-by-campaign?date=" . $date->format("Y-m-d") . "&type=adwords&campaignId=" . $campaignId;
        $adsResponse = $this->triggerSyncRequest($url, 'GET', []);

        if (isset($adsResponse["status"]) && $adsResponse["status"] == "successful") {
            if (isset($adsResponse["data"]) && count($adsResponse["data"]) > 0) {
                $cost = isset($adsResponse["data"]["cost"]) ? $adsResponse["data"]["cost"] : 0;
            }
        }
        return $cost;
    }
}
