<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\Log;
use Modules\Ads\Models\Click;
use Modules\Ads\Models\Order;
use Modules\Ads\Models\ProductAdwordsConversion;
use Modules\Ads\Models\ProductReact;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Services\EmailService;


class ProductReactBuilderService extends ProductReactService
{
    protected $clicks = [];

    public function cronBuildAdsStatus(Request $request) {
        exit;
        set_time_limit(300);
        $globalConfig = ProductReactConfigService::getGlobalConfig();
        if ($globalConfig['term'] == 0) {
            return response()->json([
                $globalConfig
            ]);
        }
        $filter = $this->buildAdsStatusFilter($request);
        $query = ProductReact::buildProductReactQuery($filter);
        $items = $query->get($filter['columns']);
        $this->decorItems($items, array_merge($filter, [
            'advertising' => 1
        ]));
        $result = [];
        foreach ($items as $item) {
            $adsConfig = $item['ads_config'];
            $productId = $item['product_id'];
            if ($item->total_click >= $adsConfig['click_from']
                && $item->total_conversion >= $adsConfig['order_from']
                && $item->rate < $adsConfig['conversion_rate']
            ) {
                $result[] = $item;
                $key = ProductReactConfigService::getStatusKeyProduct($productId);
                ProductReactConfigService::createOrUpdateProductMeta($key, [
                    'status' => 0,
                    'product_id' => $productId
                ]);
            }
        }
        if ($result && count($result) > 0) {
            $this->sendWarningEmail(['count' => count($result)]);
        }
        $response = array(
            "status" => 'successful',
            "items" => count($items),
            "result" => $result,
        );
        return response()->json($response);
    }

    protected function sendWarningEmail($data) {
        $subject = 'Printerval: ProductReactBuilderService change ads status';
        $emailService = new EmailService();
        $emailService->sendWarningEmail($data, $subject);
    }

    protected function buildAdsStatusFilter($request) {
        $globalConfig = ProductReactConfigService::getGlobalConfig();
        $term = $globalConfig['term'];
        //do 1 ky lay tu truoc day 1 ngay
        $term++;
        $filter = $this->buildFilter($request);
        $from = $request->input('time_from', date('d/m/Y',strtotime("-$term days")));
        $to = $request->input('time_to', date('d/m/Y',strtotime("-1 days")));
        $fromDate = $this->getDateTimeFilter($from);
        $fromDate->setTime(0, 0, 0);
        $toDate = $this->getDateTimeFilter($to);
        $toDate->setTime(23, 59, 59);
        $filter['order_date_from'] = $fromDate;
        $filter['order_date_to'] = $toDate;
        $filter['order_from'] = 0;
        $filter['click_from'] = 0;
        unset($filter['page_size']);
        return $filter;

    }


    public function cronProductReact(Request $request)
    {
        set_time_limit(3600);
        ini_set('memory_limit', '2048M');
        $filter = $this->buildCronFilter($request);
        $this->handleInteractData($filter);
        return response()->json([
            'status' => 'successful'
        ]);
    }

    public function handleInteractData($filter)
    {
        $type = isset($filter['type']) ? $filter['type'] : 'all';
        $items = $this->getOrder($filter);
        if ($items && count($items) > 0) {
            $this->clicks = $this->buildClick($filter);
            foreach ($items as $item) {
                if (!$item || !$item['product_id']) {
                    continue;
                }
                if ($type == 'all') {
                    $this->handleProductReact($item);
                } else if ($type == 'adwords') {
                    $this->handleAdwordsConvention($item, $filter);
                }

            }
            foreach ($this->clicks as $click) {
                $click['conversion'] = 0;
                $click['create_date'] = $click['date'];
                if ($type == 'all') {
                    $this->handleProductReact($click);
                } else if ($type == 'adwords') {
                    $this->handleAdwordsConvention($click, $filter);
                }
            }

        }
    }

    protected function buildCronFilter($request)
    {
        $from = $request->input('time_from', date('d/m/Y', strtotime("-3 days")));
        $to = $request->input('time_to', date('d/m/Y',strtotime("-1 days")));
        $type = $request->input('type', 'all');
        $fromDate = $this->getDateTimeFilter($from);
        $toDate = $this->getDateTimeFilter($to);
        $toDate->setTime(23, 59, 59);
        $filter = [
            'time_from' => $fromDate->format('Y-m-d H:i:s'),
            'time_to' => $toDate->format('Y-m-d H:i:s'),
            'date_gte' => $fromDate->format('Y-m-d'),
            'date_lte' => $toDate->format('Y-m-d'),
            'type' => $type,
        ];
        if ($type == 'adwords') {
            $filter['campaigns'] = DB::table('campaign')->pluck('campaign_type', 'campaign_id');
        }
        return $filter;
    }

    protected function getOrder($filter)
    {
        $reportType = array_key_exists('type', $filter) ? $filter['type'] : '';
        $columns = [
            'order_item.product_id',
            'order_item.product_sku_id',
            DB::raw("DATE_FORMAT(sb_order.created_at, '%Y-%m-%d') as create_date, count(*) as conversion")
        ];
        $queryFilter = [
            'type' => Order::STATUS_OUT,
            'create_time_gte' => $filter['time_from'],
            'create_time_lte' => $filter['time_to'],
            'join_order_item' => 1,
            'group_by' => ['order_item.product_id',  'order_item.product_sku_id']
        ];
        if ($reportType && $reportType != 'all') {
            $queryFilter['join_order_meta_campaign'] = 1;
            $columns[] = 'order_meta_campaign.value as campaign_id';
        }
        $query = Order::buildOrderQuery($queryFilter);
       
        $items = $query->get($columns);
        return $items;
    }

    protected function buildClick($filter) {
        $result = [];
        $clicks = $this->getClick($filter);
        $type = isset($filter['type']) ? $filter['type'] : 'all';
        if ($clicks && count($clicks)) {
            foreach ($clicks as $click) {
                $campaignId = $type == 'adwords' ? $click->campaign_id : null;
                $key = $this->buildUniqProductKey($click->product_id, $click->product_sku_id, $click->date, $campaignId);
                $result[$key] = $click;
            }
        }
        return $result;
    }

    protected function buildUniqProductKey($pId, $pSkuId, $date, $campaignId = null) {
        $key = $pId . '-' . $pSkuId . '-' . $date;
        if ($campaignId) {
            $key .= '-' . $campaignId;
        }
        return $key;
    }

    protected function getClick($filter)
    {
        $query = Click::buildClickQuery($filter);
        $type = isset($filter['type']) ? $filter['type'] : 'all';
        $columns = [
            'product_id', 'product_sku_id', 'url', 'campaign_id', 'campaign_type', 'date',
            DB::raw('SUM(clicks) as clicks'),
            DB::raw("GROUP_CONCAT(source SEPARATOR '||') as sources"),
            DB::raw("GROUP_CONCAT(clicks SEPARATOR '||') as listClick"),
        ];
        $groupBy = [
            'product_id', 'product_sku_id', 'date'
        ];
        if ($type == 'all') {

        } else if ($type == 'adwords') {
            $query->where('source', 'adwords');
            $groupBy[] = 'campaign_id';
        }
        $query->groupBy($groupBy);
        return $query->get($columns);
    }

    protected function buildItemConversion($item, $campaigns = [])
    {
        $click = 0;
        $campaignId = isset($item['campaign_id']) ? $item['campaign_id'] : null;
        $key = $this->buildUniqProductKey($item->product_id, $item->product_sku_id, $item->create_date, $campaignId);
        $campaignType = 'UNKNOWN';
        if (isset($this->clicks[$key])) {
            $click =  $this->clicks[$key]->clicks;
            unset($this->clicks[$key]);
        }
        if (isset($campaigns[$item['campaign_id']])) {
            $campaignType = $campaigns[$item['campaign_id']];
        }
        return [
            'product_id' => $item['product_id'],
            'product_sku_id' => $item['product_sku_id'],
            'campaign_id' => $campaignId,
            'date' => $item['create_date'],
            'conversion' => $item['conversion'],
            'click' => $click,
            'campaign_type' => $campaignType,
        ];
    }

    protected function buildProductReact($item)
    {
        $click = 0;
        $mapClick = [
            'adwords' => 0,
            'organic' => 0,
            'other' => 0,
            'bing ads' => 0,
        ];
        $key = $this->buildUniqProductKey($item->product_id, $item->product_sku_id, $item->create_date);
        if (isset($this->clicks[$key])) {
            $click = $this->clicks[$key]->clicks;
            $mapClick = $this->getMapClick($this->clicks[$key]);
            unset($this->clicks[$key]);
        }
        return [
            'product_id' => $item['product_id'],
            'product_sku_id' => $item['product_sku_id'],
            'date' => $item['create_date'],
            'conversion' => $item['conversion'],
            'click' => $click,
            'adwords_click' => $mapClick['adwords'],
            'organic_click' => $mapClick['organic'],
            'other_click' => $mapClick['other'],
            'bingads_click' => $mapClick['bing ads'],
        ];
    }

    private function getMapClick($clickObj)
    {
        $listSource = explode('||', $clickObj->sources);
        $listClick = explode('||', $clickObj->listClick);
        $retVal = [
            'adwords' => 0,
            'bing ads' => 0,
            'organic' => 0,
            'other' => 0
        ];
        foreach ($listSource as $key => $value) {
            if ($value == 'adwords') {
                $retVal['adwords'] += $listClick[$key];
            } else if ($value == 'bing ads') {
                $retVal['bing ads'] += $listClick[$key];
            } else if ($value == 'google') {
                $retVal['organic'] += $listClick[$key];
            } else {
                $retVal['other'] += $listClick[$key];
            }
        }
        return $retVal;
    }


    protected function handleAdwordsConvention($item, $filter)
    {
        $campaigns = isset($filter['campaigns']) ? $filter['campaigns'] : [];
        $data = $this->buildItemConversion($item, $campaigns);
        ProductAdwordsConversion::deleteAndCreate($data);
    }

    protected function handleProductReact($item)
    {
        $data = $this->buildProductReact($item);
        ProductReact::deleteAndCreate($data);
    }



}
