<?php

namespace Modules\Ads\Controllers;

use Illuminate\Support\Facades\Log;
use Modules\Ads\Models\Click;
use Modules\Ads\Models\Option;
use Modules\Ads\Models\Order;
use Modules\Ads\Models\Product;
use Modules\Ads\Models\ProductInfo;
use Modules\Ads\Models\ProductMeta;
use Modules\Ads\Models\ProductReact;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;


class ProductReactConfigService extends Controller
{
    const ADS_CONFIG_GLOBAL = 'product_react_global';
    const ADS_CONFIG_PRODUCT = 'product_react_config';
    const ADS_STATUS_PRODUCT = 'product_react_ads_status';


    public function find(Request $request)
    {
        $productId = $request->input('product_id', '');
        $type = $productId && $productId > 0 ? 'product' : 'global';
        if ($type == 'product') {
            $key = self::getConfigKeyProduct($productId);
            $query = ProductMeta::query()->where('product_id', $productId);
        } else {
            $key = self::ADS_CONFIG_GLOBAL;
            $query = Option::query();
        }
        $item = $query->where('key', $key)->first(['value']);
        $data = [];
        if ($item && $item->value) {
            $data = json_decode($item->value, true);
        }
        return response()->json([
            'status' => 'successful',
            'data' => $data,
        ]);

    }

    public function configGlobal(Request $request)
    {
        $data = $this->buildInput($request);
        if ($data) {
            $key = self::ADS_CONFIG_GLOBAL;
            $this->createOrUpdateOption($key, $data);
        }
        $result = [
            'status' => 'successful',
        ];
        return response()->json($result);
    }

    public function configProduct(Request $request)
    {
        $status = 'fail';
        $data = $this->buildInput($request);
        if ($data && array_key_exists('product_id', $data)) {
            $key = self::getConfigKeyProduct($data['product_id']);
            self::createOrUpdateProductMeta($key, $data);
            $status = 'successful';
        }
        $result = [
            'status' => $status,
        ];
        return response()->json($result);
    }


    public function configAdsStatus(Request $request)
    {
        $responseStatus = 'fail';
        $productId = $request->input('product_id', 0);
        $status = $request->input('status', 0);
        $status = (int) $status;
        if ($productId) {
            $key = self::getStatusKeyProduct($productId);
            self::createOrUpdateProductMeta($key, [
                'status' => $status,
                'product_id' => $productId
            ]);
            $responseStatus = 'successful';
        }
        $result = [
            'status' => $responseStatus
        ];
        return response()->json($result);
    }

    public static function getConfigKeyProduct($productId)
    {
        return self::ADS_CONFIG_PRODUCT;
    }

    public static function getStatusKeyProduct($productId)
    {
        return self::ADS_STATUS_PRODUCT;
    }


    protected function buildInput($request)
    {
        $result = [];
        $params = [
            'click_from', 'order_from', 'conversion_rate', 'term'
        ];
        foreach ($params as $key) {
            $result[$key] = $request->input($key, 0);
        }
        if ($request->has('product_id')) {
            $result['product_id'] = $request->input('product_id');
        }
        return $result;

    }

    public static function createOrUpdateProductMeta($key, $data)
    {
        $productId = $data['product_id'];
        $meta = ProductMeta::where('product_id', $productId)
            ->where('key', $key)
            ->first();
        if ($meta && isset($meta->id)) {
            $meta->value = json_encode($data);
            $meta->save();
        } else {
            ProductMeta::insert([
                'product_id' => $productId,
                'key' => $key,
                'value' => json_encode($data),
            ]);
        }
        Log::info('createOrUpdateProductMeta' . $key, [
            'item' => $data,
            'request' => isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '',
            'user' => auth()->user()
        ]);
    }


    protected function createOrUpdateOption($key, $data)
    {
        $option = $this->getOption($key);
        if ($option && isset($option->id)) {
            $positionData = json_decode($option->value, true);
            foreach ($data as $productId => $position) {
                $positionData[$productId] = $position;
            }
            $option->value = json_encode($positionData);
            $option->save();
        } else {
            Option::insert([
                'name' => $key,
                'key' => $key,
                'value' => json_encode($data),
                'type' => 'json'
            ]);
        }

    }

    protected function getOption($key)
    {
        return Option::where('key', $key)->first();
    }

    public static function getGlobalConfig() {
        $result = [
            'click_from' => 0,
            'order_from' => 0,
            'conversion_rate' => 0,
            'term' => 0,
        ];
        $option = Option::where('key', self::ADS_CONFIG_GLOBAL)
            ->first(['value']);
        if ($option && $option->value) {
            $result = json_decode($option->value, true);
        }
        return $result;
    }

    public static function getProductMeta($productId, $type = 'config') {
        $result = [];
        if ($type == 'config') {
            $key = self::getConfigKeyProduct($productId);
        } else {
            $key = self::getStatusKeyProduct($productId);
        }

        $item = ProductMeta::where('product_id', $productId)->where('key', $key)->first();
        if ($item && $item->value) {
            $result = json_decode($item->value, true);
        }
        return $result;
    }


}
