<?php

namespace Modules\Ads\Controllers;

use Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ProductRunAdsController extends Controller
{
    public function index(Request $request) {
        return view('ads::product-run-ads.index');
    }

    public function save(Request $request)
    {
        set_time_limit(1800);

        $productIds = explode(',', $request->get('product_ids'));
        if (empty($productIds)) {
            return [
                'status' => 'fail',
                'message' => 'product ids is empty'
            ];
        }
        $user = Auth::user();

        $saveData = [];
        foreach ($productIds as $id) {
            $saveData[] = [
                'product_id' => $id,
                'created_at' => date('Y-m-d H:i:s')
            ];
        }

        foreach (array_chunk($saveData, 100) as $chunk) {
            DB::table('product_run_ads')->insert($chunk);
        }


        return [
            'status' => 'successful',
            'result' => $productIds
        ];
    }

    public function find(Request $request)
    {
        $query = DB::table('product_run_ads')    
            ->join("product", "product.id", "product_run_ads.product_id")
            ->select([
                "product_run_ads.id", "product_run_ads.product_id", "product.name", "product.slug", "product.image_url", "product_run_ads.created_at"
            ]);

        $keys = [
            'product_id',
        ];

        foreach ($keys as $key) {
            if ($request->get($key)) {
                $query->where("product_run_ads.$key", $request->get($key));
            }
        }
        if ($request->get('date_from')) {
            $query->where('product_run_ads.created_at', '>=', $request->get('date_from'));
        }
        if ($request->get('date_to')) {
            $query->where('product_run_ads.created_at', '<=', $request->get('date_to'));
        }

        $pageSize = $request->get('page_size', 50);
        $pageId = $request->get('page_id', 0);
        $query->limit($pageSize)->offset($pageSize * $pageId);

        $meta = $this->getMetaData($request->all());

        $result = $query->get();

        return [
            'status' => 'successful',
            'result' => $result,
            'meta' => $meta
        ];
    }


    public function getMetaData($filter)
    {
        $pageId = 0;
        $pageSize = 50;
        if (!empty($filter['page_size'])) {
            $pageSize = intval($filter['page_size']);
        }
        if (!empty($filter['page_id'])) {
            $pageId = intval($filter['page_id']);
        }
        $meta = [
            'page_id' => $pageId,
            'page_size' => $pageSize,
            'page_count' => 0,
            'has_next' => true,
            'total_count' => 0,
        ];

        return $meta;
    }

    public function pushAds(Request $request) {
        $productIds = explode(',', $request->get('product_ids'));
        if (empty($productIds)) {
            return [
                'status' => 'fail',
                'message' => 'product ids is empty'
            ];
        }
        $user = Auth::user();
        DB::table('product_run_ads')
            ->whereIn('product_id', $productIds)
            ->update([
                'is_push_ads' => 1,
                'ads_id' => $user ? $user->id : 0,
                'updated_at' => date('Y-m-d H:i:s')
            ]);

        return [
            'status' => 'successful',
            'result' => $productIds
        ];
    }

    public function delete(Request $request, $id) {
        $params = Route::current()->parameters();
        $id = $params['id'];

        DB::table('product_run_ads')->where('id', $id)->delete();
        return [
            'status' => 'successful',
            'result' => $id
        ];
    }

    public function bulkDelete(Request $request) {
        $productIds = explode(',', $request->get('product_ids'));
        if (empty($productIds)) {
            return [
                'status' => 'fail',
                'message' => 'product ids is empty'
            ];
        }
        DB::table('product_run_ads')->whereIn('product_id', $productIds)->delete();
        return [
            'status' => 'successful',
            'result' => $productIds
        ];
    }

}