<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Modules\Ads\Models\Category;
use Modules\Ads\Controllers\Service\ProductToAdvertiseById;
use Modules\Ads\Controllers\Service\ProductToAdvertiseBySku;
class ProductToAdvertiseController extends Controller
{
    protected $productToAdvertiseById = null;
    protected $productToAdvertiseBySku = null;
    public function __construct(ProductToAdvertiseById $productToAdvertiseById,
                                ProductToAdvertiseBySku $productToAdvertiseBySku
                                )
    {
        $this->productToAdvertiseById = $productToAdvertiseById;
        $this->productToAdvertiseBySku = $productToAdvertiseBySku;
    }


    public function index(Request $request)
    {   
        $accountConfigs = config('google_ads.accounts', []);
        if (empty($accountConfigs)) {
            throw new \Exception('The module Product Advertising require the config "Google ads account" in /config/google_ads.php');
        }
        $accounts = [];
        foreach ($accountConfigs as $key => $value) {
            $account = [
                'code' => $value['customer_id'], 
                'title' => $value['name'] . ' (' . $value['customer_id'] .')'
            ];
            $accounts[] = $account;
        }
        $categories = Category::where('type', '=', 'PRODUCT')
                            ->get(['name as title', 'id']);
        return view('ads::product-advertise.index', [
            'accounts' => $accounts,
            'categories' => $categories
        ]);
    }

    public function buildCampaignClick(Request $request) {
        $isGroup = \Config::get('ads::ads.is_group');
        if ($isGroup) {
            $response = $this->productToAdvertiseById->buildCampaignClick($request);

        } else {
            $response = $this->productToAdvertiseBySku->buildCampaignClick($request);

        }
        return response()->json($response);
    }


    public function find(Request $request) {
        set_time_limit(0);
        ini_set('memory_limit', '2048M');
        $isGroup = \Config::get('ads::ads.is_group');
        $filter = $this->productToAdvertiseById->buildFilters($request);
        if ($isGroup) {
            $response = $this->productToAdvertiseById->getData($filter, $request);

        } else {
            $response = $this->productToAdvertiseBySku->getData($filter, $request);

        }
        return response()->json($response);
    }

    public function exportExcel(Request $request) {
        set_time_limit(0);
        ini_set('memory_limit', '2048M');
        $filters = $this->buildFilters($request);
        $products = $this->getData($filters, $request);
        $this->exportToExcel($products);
    }

}
