<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Controller;
use Module;
use Modules\Ads\Models\AdsProductPerformance;
use Modules\Ads\Models\Product;
use Modules\Ads\Services\ProductWarningService;
use Response;

class ProductWarningController extends Controller
{
    protected $productWarningService;

    public function __construct()
    {        
       
        $this->productWarningService = new ProductWarningService();
    }
    public function index(Request $request)
    {
        $message = config("ads::app.message");
        return view('ads::product-warning.index', [
            'message' => $message,
        ]);
    }

    public function getListProductWarning(Request $request) {
        $dataFilter = [
            'page_id' => $request->input('page_id'),
            'name' => $request->input('name'),
            'sort' => $request->input('sort'),
            'sku' => $request->input('sku'),
            'crawl_status' => $request->input('crawl_status'),
            'start_date' => $request->input('start_date'),
            'end_date' => $request->input('end_date'),
        ];

        $result = $this->productWarningService->find($dataFilter);

        return Response::json([
            'status' => 'successful',
            'result' => $result    
        ]);
    }

    public function updateCrawlStatus(Request $request) {
        $retval = [
            'status' => 'failed'
        ];

        $result = $this->productWarningService->updateCrawlStatus($request->all());

        if($result) {
            $retval = [
                'status' => 'successful'
            ];
        }

        return Response::json($retval);
    }
}
