<?php

namespace Modules\Ads\Controllers;

use Module;
use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\RedditService;
use Modules\Ads\Controllers\Service\MerchantProduct;
use Modules\Ads\Controllers\Service\MerchantProductService;


class RedditController extends Controller
{
    private $merchantProductService;
    private $redditProductService;
    public function __construct(MerchantProductService $merchantProductService, RedditService $redditProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->redditProductService = $redditProductService;
    }
    public function cronUpdateFeed(Request $request){
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $buildFilterData = $this->redditProductService->buildFilterData($input);
        $products = $buildFilterData['products'];
        $input = $buildFilterData['input'];
        $locale = $buildFilterData['locale'];
        $count = $this->redditProductService->buildProducts($products, $input);
        $this->redditProductService->store($input, $locale);
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

    public function cronRemoveProduct(Request $request){
        $start = microtime(true);
        $input = $request->all();
        $timeLimit = 60*30;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        ini_set("memory_limit", "3072M");
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        $isLocalization = env('LOCALIZATION');
        $locale = env('APP_LOCALE');
        $countryCode = 'us';
        if ($prefixUrl == '' && $isLocalization && $locale != '') {
            $prefixUrl = '/' . $locale;
            $countryCode = $locale;
        }
        if ($countryCode == 'uk'){
            $countryCode = 'gb';
        }
        $countryCode = strtoupper($countryCode);
        $filter = $input;
        if (array_key_exists('skip_ads',$input)){
            if(!array_key_exists('updated_at_from',$input)){
                if(!array_key_exists('ignore_updated_at',$input)){
                    $filter['updated_at_from'] = date("Y-m-d 00:00:00",strtotime('-1 day'));
                }
            }
        }else{
            if(array_key_exists('deleted_at_from',$input)){
                $filter['deleted_at_from'] = $input['deleted_at_from'];
            }else{
                $filter['deleted_at_from'] =  date("Y-m-d 00:00:00",strtotime('-1 day'));
            }
        }
        $filter['columns'] = [
            // ORIGIN
            'product.id'
        ];
        $query = $this->redditProductService->buildDeleteQuery($filter);
        $chunkCount = 100000;
        $count = 0;
        $query->chunk($chunkCount, function($products) use($prefixUrl,$countryCode, $input, &$count, $start, $locale){
            $input['prefixUrl'] = $prefixUrl;
            $input['country'] = $countryCode;
            $data = $this->redditProductService->buildRemoveProducts($products, $input);
            $count += count($data);
            $input['removeProducts'] = $data;
            $this->redditProductService->remove($input, $locale);
        });
        $totalTime = microtime(true) - $start;
        return response()->json(['status' => 'successful', 'result' => $count]);
    }

}
