<?php

namespace Modules\Ads\Controllers;

use Illuminate\Http\Request;
use Module;
use Modules\Ads\Controllers\Service\SearchAdService;

class SearchAdController extends Controller
{
    private $searchServiceService;
    public function __construct(SearchAdService $searchServiceService)
    {
        $this->searchServiceService = $searchServiceService;
    }

    public function createAd(Request $request){
        $input = $request->all();
        $timeLimit = 60*60*2;
        if (array_key_exists('time_limit',$input)){
            $timeLimit = $input['time_limit'];
        }
        set_time_limit($timeLimit);
        $prefixUrl = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        if (!array_key_exists('created_at_from',$input)){
            $input['created_at_from'] = date("Y-m-d H:i:s",strtotime('-2 hours'));
        }
        $products = $this->searchServiceService->getProducts($input);
        $count = 0;
        foreach($products as $item){
            try{
                if ($this->searchServiceService->isCreate($item->id)){
                    continue;
                }
                $keywords = $this->searchServiceService->getKeyword($item);
                $input['product'] = $item;
                $input['keywords'] = $keywords;
                $adgroupData = $this->searchServiceService->saveAdgroup($input);
                $input['prefixUrl'] = $prefixUrl;
                $input['adgroup_id'] = $adgroupData['adgroupId'];
                $input['resourceName'] = $adgroupData['resourceName'];
                $this->searchServiceService->saveAd($input);
                $this->searchServiceService->saveKeywordAd($input);
                $count++;
            }catch (\Exception $ex){
                \Log::error($ex->getMessage() . $ex->getTraceAsString());
            }


        }
        return response()->json([
            'status' => 'successful',
            'result' => $count
        ]);
    }
}
