<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

class AwinService extends BaseService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];
    private $languages;

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
        $this->languages = \Config::get('ads::clara-ads-general.languages',[]);
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = ucwords(strtolower($product->title_replacement));
        $shippingFees = $this->merchantProductService->getShipping($product,$input);
        $this->merchantProductService->buildSpecificInfo($product);
        $shipping = [];
        foreach($shippingFees as $shippingItem){
            $shipping[] = $shippingItem['price'];
            break;
        }
        $productType = $this->merchantProductService->getProductType($product);
        $categories = explode(">",$productType);
        $item = [
                $country . $product->id,
                $title,
                $this->merchantProductService->getDescription($product,$title),
                trim($categories[count($categories)-1]),
                $product->category_id,
                (URL('/') . $prefixUrl . "/" . $product->slug . "-p" . $product->id),
                $this->merchantProductService->buildImage($product),
                $product->price,
                $productType,
                $product->sku_category_merchant_id,
                isset($shipping[0])?$shipping[0]:0,
                'new',
                $this->merchantProductService->getLabel1($product),
                $this->merchantProductService->getLabel2($product),
                $product->sold >0 ? 'ordered':'',
                $currency,
                (isset($this->languages[$country]) ? $this->languages[$country] : env('APP_LANG')) .'_'.$country,

        ];
        $key = $country . $product->id;
        $this->items[$key] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/awin';
        $items = $this->items;
        $existsProducts = ['product_id' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[0]])) {
                $currRow = $items[$currRow[0]];
                unset($items[$currRow[0]]);
            }
            if (!isset($existsProducts[$currRow[0]])){
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[0]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'product_id',
            'product_name',
            'description',
            'category_name',
            'category_id',
            'deep_link',
            'image_url',
            'price',
            'merchant_product_category_path',
            'google_taxonomy',
            'delivery_cost',
            'condition',
            'custom1',
            'custom2',
            'custom3',
            'custom4',
            'custom5',
            'colour',
            'currency',
            'language',

        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            if (empty($product->sku_category_merchant_id)){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }

    public function getProductBySellerId($input){
        $sellerId = isset($input['sellerId']) ? $input['sellerId'] :0;
        if (!empty($sellerId)){
            if (!array_key_exists('created_at_from',$input)){
                $input['created_at_from'] = date('Y-m-d 00:00:00',strtotime('-3 months'));
            }
            $retVal = DB::table('product_n_user')
                ->where('user_id',$sellerId)
                ->pluck('product_id')->toArray();
        }
        if (empty($retVal)){
            $retVal = [0];
        }
        return $retVal;
    }
    public function remove($input, $locale = 'us'){
        $removeProducts = $input['removeProducts'];
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/awin';
        $this->processFile($input,function($currRow,$stream) use (&$removeProducts){
            if (!isset($removeProducts[$currRow[0]])) {
                fputcsv($stream, $currRow);
                $removeProducts[$currRow[0]] = 1;
            }
        });
    }

    public function clean($input, $locale = 'us'){
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/awin';
        $retVal = 0;
        $existsProducts = [];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal){
            if (!isset($existsProducts[$currRow[0]])) {
                $retVal++;
                $existsProducts[$currRow[0]] = 1;
                fputcsv($stream, $currRow);
            }
        });
        return $retVal;
    }
}