<?php


namespace App\Modules\Ads\Controllers\Service;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;


class BaseService
{
    const FIELD_CONFIG = ['order_by', 'limit', 'page', 'columns'];

    protected function triggerAsyncRequest($url, $params = "", $method = "get") {
        $channel = curl_init();
        if ($method == "get" || $method == "GET") {
            curl_setopt($channel, CURLOPT_URL, $url . "?" . $params);
        } else if ($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_URL, $url);
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, $params);
        }
        curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT_MS, 600);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        curl_exec($channel);
        curl_close($channel);
    }

    protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = []) {
        $ch = curl_init();
        $timeout = 200;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($headers) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        if ($method != 'GET') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        }

        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($ch);
        curl_close($ch);
        $retVal =  json_decode($data, true);
        if (empty($retVal)){
            $retVal = $data;
        }
        return $retVal;
    }
    protected function cleanFile($input, $index = 8)
    {
        $retVal = 0;
        $existsProducts = [];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,$index,&$retVal){
            if (!isset($existsProducts[$currRow[$index]])) {
                $retVal++;
                $existsProducts[$currRow[$index]] = 1;
                fputcsv($stream, $currRow);
            }
        });
    }

    public function buildRemoveProducts($products,$input = []){
        $country = $input['country'];
        $retVal = [];
        foreach ($products as $product) {
            $retVal[$country . $product->id] = $country . $product->id;
        }
        return $retVal;
    }

    public function buildDeleteQuery($filter)
    {
        $productQuery = DB::table('product');
        if (array_key_exists('skip_ads', $filter)) {
            $productQuery->where(function ($query) {
                $query->orWhere('is_trademark', '=', 1);
                $query->orWhere('is_violation', '=', 1);
                $query->orWhere('approve_advertising', '=', 0);
                $query->orWhere('status', '!=', 'ACTIVE');
            });
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('deleted_at_from', $filter)){
            $productQuery->where('product.deleted_at', '>=', $filter['deleted_at_from']);
        }
        if(array_key_exists('actor_ids', $filter)){
            $productQuery->whereIn('product.actor_id', $filter['actor_ids']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->orderBy('product.id');
        }else{
            $productQuery->orderBy('product.updated_at','desc');
        }
        $productQuery->select(['product.id']);
        return $productQuery;
    }

    public function processFile($input,$doWhenRead = null, $doWhenDone = null , $headerRow = []){
        $fileName = $input['fileName'];
        $tempFile = 'temp_' . $fileName;
        $localeFolder = $input['localeFolder'];
        if (!file_exists($localeFolder)) {
            mkdir($localeFolder, 0777, true);
        }
        $filePath = $localeFolder . '/' . $fileName;
        $tempPath = $localeFolder . '/' . $tempFile;
        if (array_key_exists('truncate',$input)){
            file_put_contents($tempPath,"");
            file_put_contents($filePath,"");
        }
        if(!array_key_exists('append',$input)){
            try{
                $fileHandle = fopen($filePath, "r");
            }catch (\Exception $ex){
                $fileHandle = FALSE;
            }
            if ($fileHandle !== FALSE){
                $limit = 1000;
                //Set up a variable to hold our current position in the file
                $offset = 0;
                while(!feof($fileHandle))
                {
                    $stream = fopen('php://temp', 'w');
                    if (!empty($headerRow) && $offset ==0){
                        fputcsv($stream, $headerRow);
                    }
                    //Go to where we were when we ended the last batch
                    fseek($fileHandle, $offset);
                    $i = 0;
                    while (($currRow = fgetcsv($fileHandle)) !== FALSE)
                    {
                        $i++;
                        //Do something with the current row
                        if ($doWhenRead && is_callable($doWhenRead)) {
                            $doWhenRead($currRow,$stream);
                        }

                        //If we hit our limit or are at the end of the file
                        if($i >= $limit)
                        {
                            //Update our current position in the file
                            $offset = ftell($fileHandle);

                            //Break out of the row processing loop
                            break;
                        }
                    }
                    rewind($stream);
                    $content = stream_get_contents($stream);
                    fclose($stream);
                    file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
                }
                fclose($fileHandle);
            }else{
                $stream = fopen('php://temp', 'w');
                fputcsv($stream, $headerRow);
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        }
        if ($doWhenDone && is_callable($doWhenDone)) {
            $doWhenDone($tempPath);
        }
        if (array_key_exists('rename',$input)){
            if (file_exists($tempPath)) {
                rename($tempPath, $filePath);
            }
        }
    }

    public function getProductTrend($input){
        $key = Route::currentRouteName() .'_'.$input['fileName'];
        $stringIds = getOption($key,'');
        $ids = [];
        if (!empty($stringIds)){
            $ids = explode(',',$stringIds);
        }
        if (!array_key_exists('limit',$input)){
            $input['limit'] = 100000;
        }
        if (!empty($ids)){
            $input['created_at_from'] = date('Y-m-d 00:00:00',strtotime('-2 days'));
        }elseif (!array_key_exists('created_at_from',$input)){
            $input['created_at_from'] = date('Y-m-d 00:00:00',strtotime('-3 months'));
        }
        $retVal = DB::table('order_item')->join('order','order.id','=','order_item.order_id')
            ->where('order.payment_status','PAID')
            ->where('order.created_at','>',$input['created_at_from'])
            ->groupBy('order_item.product_id')
            ->pluck('order_item.product_id')->toArray();
        if (!empty($retVal)){
            $retVal = array_unique(array_merge($ids,$retVal));
        }else{
            $retVal = $ids;
        }
        $exists = DB::table('option')->where('key',$key)->exists();
        if ($exists) {
            DB::table('option')->where('key',$key)->update(["value" => implode(',',$retVal)]);
        } else {
            $data = [
                'key' => $key,
                'name' => json_encode($input),
                'type' => 'text',
                'value' => implode(',',$retVal)
            ];
            DB::table('option')->where('key',$key)->insert($data);
        }
        return $retVal;
    }
    protected function removeNonAlphabet($string){
      return preg_replace('/[^A-Za-z0-9 .]/', '', $string);
    }

    public function checkProductSoldFromDate($input){
     return DB::table('order_item')->join('order','order.id','=','order_item.order_id')
        ->where('order.payment_status','PAID')
        ->where('order.created_at','>',$input['order_date_from'])
        ->where('order_item.product_id',$input['product_id'])
        ->exists();
      }

    public function getListByFilter($model, $params, $relationships = [])
    {
        $columns = Schema::getColumnListing($model->getTable());
        $query = $model->newQuery();
        $query = $query->select($params['columns'] ?? ['id']);
        foreach ($params as $field => $value) {
            if (!in_array($field, self::FIELD_CONFIG)) {
                if (is_array($value)) {
                    if (!in_array($field, $columns)) {
                        continue;
                    }
                    $query = $query->whereIn($field, $value);
                } else {
                    if ($field == 'sold_from') {
                        $query = $query->where('sold', '>=', $value);
                    } else if ($field == 'product_id_from') {
                        $query = $query->where('id', '>=', $value);
                    } else if ($field == 'product_id_to') {
                        $query = $query->where('id', '<=', $value);
                    } else if ($field == 'created_at_from') {
                        $query = $query->where('created_at', '>=', $this->formatDateTime($value));
                    } else if ($field == 'created_at_to') {
                        $query = $query->where('created_at', '<=', $this->formatDateTime($value));
                    } else if ($field == 'updated_at_from') {
                        $query = $query->where('updated_at', '>=', $this->formatDateTime($value));
                    } else if ($field == 'updated_at_to') {
                        $query = $query->where('updated_at', '<=', $this->formatDateTime($value));
                    } else if (!in_array($field, $columns)) {
                        continue;
                    } else {
                        $query = $query->where($field, $value);
                    }
                }
            }
            if ($field == 'order_by') {
                foreach ($value as $keyOrderBy => $valueOrderBy) {
                    if (!in_array($keyOrderBy, $columns)) {
                        continue;
                    }
                    $query = $query->orderBy($keyOrderBy, $valueOrderBy);
                }
            }
        }

        if (!empty($relationships)) {
            foreach ($relationships as $relationship) {
                $query = $query->with($relationship);
            }
        }

        if (!empty($params['limit'])) {
            $query = $query->paginate($params['limit']);
        } else {
            $query = $query->get();
        }
        return $query;
    }

    public function updateCsvProducts($filePath, $products = [], $uniqueColumn = null, $isGz = false, $productConvertDelete = [])
    {
        if (empty($products)) {
            throw new \Exception("Products data is required");
        }
        if (!$uniqueColumn) {
            throw new \Exception("Unique column must be provided");
        }

        $actualFilePath = $filePath;
        if ($isGz) {
            $actualFilePath = preg_match('/\.gz$/i', $filePath) ? $filePath : $filePath . '.gz';
        }
        $tempPath = $actualFilePath . '.tmp';

        $fileExists = file_exists($actualFilePath);

        $columns = array_keys($products[0]);

        $rows = [];
        $updatedCount = 0;
        $insertedCount = 0;
        $deleteProductId = [];

        if ($fileExists) {
            if ($isGz) {
                $fpRead = gzopen($actualFilePath, 'r');
                if ($fpRead === false) throw new \Exception("Cannot open gz file for reading");

                while (!gzeof($fpRead)) {
                    $line = gzgets($fpRead);
                    if (!$line) continue;
                    $row = str_getcsv(trim($line));
                    if (count($row) != count($columns)) continue;

                    $rowAssoc = [];
                    foreach ($columns as $i => $col) {
                        $rowAssoc[$col] = $row[$i] ?? '';
                    }
                    if (isset($rowAssoc[$uniqueColumn])) {
                        $rows[$rowAssoc[$uniqueColumn]] = $rowAssoc;
                    }
                }
                gzclose($fpRead);
            } else {
                if (($fpRead = fopen($actualFilePath, 'r')) !== false) {
                    while (($row = fgetcsv($fpRead)) !== false) {
                        if (count($row) != count($columns)) continue;
                        $rowAssoc = [];
                        foreach ($columns as $i => $col) {
                            $rowAssoc[$col] = $row[$i] ?? '';
                        }
                        if (isset($rowAssoc[$uniqueColumn])) {
                            $rows[$rowAssoc[$uniqueColumn]] = $rowAssoc;
                        }
                    }
                    fclose($fpRead);
                }
            }
        }

        foreach ($products as $product) {
            if (!isset($product[$uniqueColumn])) {
                throw new \Exception("Each product must have the unique column '$uniqueColumn'");
            }
            $key = $product[$uniqueColumn];

            if (isset($product['mpn']) && in_array($product['mpn'], $productConvertDelete)) {
                if (!empty($rows[$key])) {
                    $deleteProductId[] = $this->convertDeleteProductId($product['mpn']);
                    unset($rows[$key]);
                }
                continue;
            }

            if (isset($rows[$key])) {
                foreach ($product as $col => $val) {
                    $rows[$key][$col] = $val;
                }
                $updatedCount++;
            } else {
                $rows[$key] = $product;
                $insertedCount++;
            }
        }

        if ($isGz) {
            $fpWrite = gzopen($tempPath, 'w9');
            if ($fpWrite === false) throw new \Exception("Cannot write gz temp file");

            foreach ($rows as $row) {
                $csvLine = fopen('php://temp', 'r+');
                $lineData = [];
                foreach ($columns as $col) $lineData[] = $row[$col] ?? '';
                fputcsv($csvLine, $lineData);
                rewind($csvLine);
                gzwrite($fpWrite, stream_get_contents($csvLine));
                fclose($csvLine);
            }

            gzclose($fpWrite);
        } else {
            if (($fpWrite = fopen($tempPath, 'w')) !== false) {
                foreach ($rows as $row) {
                    $lineData = [];
                    foreach ($columns as $col) $lineData[] = $row[$col] ?? '';
                    fputcsv($fpWrite, $lineData);
                }
                fclose($fpWrite);
            } else {
                throw new \Exception("Cannot write temp file");
            }
        }

        rename($tempPath, $actualFilePath);

        return [
            'updated' => $updatedCount,
            'inserted' => $insertedCount,
            'deleted' => $deleteProductId
        ];
    }

    public function sendRequest($urlDetail, $method = 'POST', $headers = [], $params = [])
    {
        try {
            $client = new \GuzzleHttp\Client([
                'timeout' => 120,
                'verify' => true,
            ]);

            $options = [
                'headers' => $headers ?? [],
            ];

            if (strtoupper($method) === 'GET') {
                if (!empty($params)) {
                    $options['query'] = $params;
                }
                $response = $client->get($urlDetail, $options);
            } elseif (strtoupper($method) === 'POST') {
                if (!empty($params)) {
                    $options['json'] = $params;
                }
                $response = $client->post($urlDetail, $options);
            } else {
                throw new \Exception("Unsupported method: $method");
            }

            $bodyContent = json_decode($response->getBody()->getContents(), true);
            return [
                'status' => $response->getStatusCode(),
                'data' => $bodyContent,
            ];
        } catch (\Exception $e) {
            return [
                'status' => 500,
                'error' => $e->getMessage(),
            ];
        }
    }
}