<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Ads\Controllers\AdsController;
use Modules\Ads\Models\BingProduct;
use Modules\Ads\Models\Category;
use Modules\Ads\Models\Country;
use Modules\Ads\Models\MerchantProduct;
use Modules\Ads\Models\ProductSku;
use Module;
use Cache;

class BingProductService extends BaseService
{


    public function __construct()
    {

    }

    public function buildDeleteQuery($filter)
    {
        $productQuery = DB::table('product');
        $productQuery->join('bing_product', 'product.id', 'bing_product.product_id');
        if (array_key_exists('skip_ads', $filter)) {
            $productQuery->where(function ($query) {
                $query->orWhere('approve_advertising', '=', 0);
                $query->orWhere('is_trademark', '=', 1);
                $query->orWhere('is_violation', '=', 1);
                $query->orWhere('status', '!=', 'ACTIVE');
            });
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('deleted_at_from', $filter)){
            $productQuery->where('product.deleted_at', '>=', $filter['deleted_at_from']);
        }
        if(array_key_exists('actor_ids', $filter)){
            $productQuery->whereIn('product.actor_id', $filter['actor_ids']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->orderBy('bing_product.product_id');
        }else{
            $productQuery->orderBy('product.updated_at','desc');
        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }else{
            $productQuery->select(['bing_product.product_id','bing_product.sku','bing_product.id']);

        }
        return $productQuery;
    }




/*
 * update product if exist
 * create product if not exist
 * return list product sku need remove on google merchant
 * */
    public function saveBingProduct($productId, $sku){
        $retVal = [];
        $isExists = false;
        $query = BingProduct::where('product_id', $productId);
        $products = $query->get();
        foreach ($products as $item){
            if ($item->sku != $sku){
                $retVal[] = ['productId' => $item->product_id, 'sku' => $item->sku, 'merchantProductId' => $item->id];
            }else{
                $isExists = true;
                $item->updated_at = date('Y-m-d H:i:s');
                $item->save();
            }
        }
        if (!$isExists){
            $merchantProduct = new BingProduct();
            $merchantProduct->product_id = $productId;
            $merchantProduct->sku = $sku;
            $merchantProduct->created_at = date('Y-m-d H:i:s');
            $merchantProduct->updated_at = date('Y-m-d H:i:s');
            $merchantProduct->save();
        }
        return $retVal;
    }

    public function removeBingProduct($productIds){
        $data = array_chunk($productIds,50);
        foreach ($data as $ids){
            BingProduct::whereIn('product_id', $ids)->delete();
        }
    }

    public function buildProductDelete($products, $input = []){
        $retVal = [];
        $language = $input['language'];
        $country = $input['country'];
        foreach ($products as $product ){
            $item = [
                'language' => $language,
                'country' => $country,
                'product_code' => $product['sku'],
                'id' => $product['productId'],
                'merchantProductId' => $product['merchantProductId'],
                'merchantId' => $this->getMerchantId(),
            ];
            $retVal[] = $item;
        }
        return $retVal;
    }

    public function createDeleteBingProduct($data){
        if (Schema::hasTable('bing_product_delete')) {
            $chunkData = array_chunk($data,50);
            foreach ($chunkData as $items) {
                DB::table('bing_product_delete')->insert($items);
            }
        }
    }

    public function clearProductCreateFail($productIds){
        $data = array_chunk($productIds,50);
        foreach ($data as $ids){
            DB::table('bing_product')->whereIn('product_id', $ids)->delete();
        }
    }

    public function getMerchantId(){
        return getOption('bing_merchant_id', '187758');
    }
}
