<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;

class BingService extends BaseService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = $this->replaceInvalidCharacter(ucwords(strtolower($product->title_replacement)));
        $shippingFees = $this->merchantProductService->getShipping($product,$input);
        $this->merchantProductService->buildSpecificInfo($product);
        $shipping = [];
        foreach($shippingFees as $shippingItem){
            $shipping[] = $shippingItem['country'] . ':' . $shippingItem['price'];
            break;
        }
        $item = [
                $product->sku_code,
                $title,
                $title,
                (URL('/') . $prefixUrl . "/" . $product->sku_slug),
                $this->merchantProductService->buildImage($product),
                'in stock',
                $product->price . ' ' . $currency,
                '',
                $country . $product->id,
                $this->merchantProductService->getProductType($product),
                $product->sku_category_merchant_id,
                $this->merchantProductService->getBrand($product),
                implode(',', $shipping)
        ];
        $key = $country . $product->id;
        $this->merchantProductService->buildProductInfo($product,$item);
        $item[] = $input['fileName'];
        $this->items[$key] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/bing';
        $items = $this->items;
        $existsProducts = ['mpn' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[8]])) {
                $currRow = $items[$currRow[8]];
                unset($items[$currRow[8]]);
            }
            if (!isset($existsProducts[$currRow[8]])){
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[8]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'id',
            'title',
            'description',
            'link',
            'image_link',
            'availability',
            'price',
            'gtin',
            'mpn',
            'product_type',
            'google_product_category',
            'brand',
            'shipping(country:price)',
            'age_group',
            'size',
            'color',
            'gender',
            'custom_label_0',
        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }

    private function replaceInvalidCharacter($string){
        return str_replace(["\\"],'',$string);
    }

    public function remove($input, $locale = 'us'){
        $removeProducts = $input['removeProducts'];
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/bing';
        $this->processFile($input,function($currRow,$stream) use (&$removeProducts){
            if (!isset($removeProducts[$currRow[8]])) {
                fputcsv($stream, $currRow);
                $removeProducts[$currRow[8]] = 1;
            }
        });
    }

    public function clean($input, $locale = 'us'){
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/bing';
        $retVal = 0;
        $existsProducts = [];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal){
            if (!isset($existsProducts[$currRow[8]])) {
                $retVal++;
                $existsProducts[$currRow[8]] = 1;
                fputcsv($stream, $currRow);
            }
        });
        return $retVal;
    }
}