<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;

class BounceCommerceService extends BaseService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];
    protected $increasePriceConfig = [];

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
        $config = DB::table('option')->where('key','price-change::ads-additional-price')->first(['value']);
        if (!empty($config) && !empty($config->value)){
            $this->increasePriceConfig = json_decode($config->value,true);
        }
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = $this->merchantProductService->escapeSpecialCharacters(ucwords(strtolower($product->title_replacement)));
        $description = $this->merchantProductService->getDescription($product,$title);
        $item = [
                $product->sku_code,
                $title,
                $description,
                (URL('/') . $prefixUrl . "/" . $product->slug . "-p" . $product->id. "?spid=" . $product->product_sku_id),
                $this->merchantProductService->buildImage($product),
                'in stock',
                $product->price . ' ' . $currency,
                '',
                $country . $product->id,
                $this->merchantProductService->getProductType($product),
                $product->sku_category_merchant_id,
                $product->sku_brand,
                'new'

        ];
        $key = $country . $product->id;
        $this->items[$key] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/bounce';
        $items = $this->items;
        $existsProducts = ['mpn' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[8]])) {
                $currRow = $items[$currRow[8]];
                unset($items[$currRow[8]]);
            }
            if (!isset($existsProducts[$currRow[8]])){
                $currRow[3] = $this->addPram($currRow[3]);
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[8]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'id',
            'title',
            'description',
            'link',
            'image_link',
            'availability',
            'price',
            'gtin',
            'mpn',
            'product_type',
            'google_product_category',
            'brand',
            'condition',
        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            if (empty($product->sku_category_merchant_id)){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }
    public function remove($input, $locale = 'us'){
        $removeProducts = $input['removeProducts'];
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/bounce';
        $this->processFile($input,function($currRow,$stream) use (&$removeProducts){
            if (!isset($removeProducts[$currRow[8]])) {
                fputcsv($stream, $currRow);
                $removeProducts[$currRow[8]] = 1;
            }
        });
    }

    private function addPram($url){
        return $url;
    }

    private function increasePrice($price,$rate){
        $price = roundUp($price * $rate,2);
        return $price;
    }
}