<?php

namespace Modules\Ads\Controllers\Service;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
class ClickHouseService
{
    protected $config;

    public function __construct()
    {
        $this->config = config('ads::ads.click_house');
    }
    public function getQueryUrl(string $query)
    {
        $database = $this->config['default_database'];
        $password = $this->config['default_password'];
        return $this->config['api_url'] . '?' . http_build_query([
                'database' => $database,
                'user'     => $this->config['default_username'],
                'password' => $password,
                'query'    => $query . ' FORMAT JSON',
            ]);
    }
}
