<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use App\Modules\Ads\Models\PlatformFileAds;
use App\Modules\Ads\Models\ProductAds;
use Carbon\Carbon;

class CriteoService extends BaseService
{
    protected $productAds;

    public function __construct(ProductAds $productAds)
    {
        $this->locale = !empty(env('APP_LOCALE')) ? env('APP_LOCALE') : 'us';
        $this->productAds = $productAds;
    }

    public function getProductAds($filters)
    {
        $filters['columns'] = [
            'id', 'title', 'sku', 'link', 'image_link', 'brand', 'google_product_category', 'price','high_price', 'status',
            'product_type', 'custom_label_0', 'custom_label_1', 'custom_label_2', 'custom_label_3', 'custom_label_4'
        ];
        return $this->getListByFilter($this->productAds,$filters);
    }

    public function createDataSource()
    {
        $retVal = [];
        $lastFile = PlatformFileAds::query()->where('platform', 'criteo')->orderBy('id', 'desc')->first();
        $lastDataSourceId = $lastFile ? (intval($lastFile->data_source_id) + 1) : 1;
        $retVal['dataSourceId'] = $lastDataSourceId;
        return $retVal;
    }

    public function convertProduct($product)
    {
        $currency = env('CURRENCY_UNIT','USD');

        $retVal = [];
        $retVal['id'] = $this->locale . $product->id;
        $retVal['title'] = $product->title;
        $retVal['description'] = $product->title;
        $retVal['product_type'] = $product->product_type;
        $retVal['link'] = $product->link;
        $retVal['image_link'] = getImageCdn($product->image_link, 630, 630);
        $retVal['availability'] = "in stock";
        $retVal['brand'] = $product->brand;
        $retVal['google_product_category'] = $product->google_product_category;
        $retVal['sale_price'] = $product->price . " " . $currency;
        $retVal['price'] = ($product->high_price < $product->price) ? $product->high_price . " " .$currency : $retVal['sale_price'];
        $retVal['gtin'] = "";
        $retVal['custom_label_0'] = $product->custom_label_0;
        $retVal['custom_label_1'] = $product->custom_label_1;
        $retVal['custom_label_2'] = $product->custom_label_2;
        $retVal['custom_label_3'] = $product->custom_label_3;
        $retVal['custom_label_4'] = $product->custom_label_4;
        $retVal['mpn'] = $this->locale . $product->id;
        $retVal['star'] = "5";
        $retVal['adult'] = "";
        return $retVal;
    }

    public function formatDateTime($time, $format = "Y-m-d H:i:s")
    {
        $carbon = Carbon::parse($time);
        return $carbon->format($format);
    }

    public function convertDeleteProductId($mpn)
    {
        if (substr($mpn, 0, strlen($this->locale)) === $this->locale) {
            return substr($mpn, strlen($this->locale));
        }
        return null;
    }
}