<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;

class CustomerService extends BaseService
{
    protected $publicPath = null;

    public function __construct()
    {
        $this->publicPath = base_path() . '/public/';
    }

    /***
     * @param $input
     * @param $locale
     */
    public function store($input)
    {
        $input['localeFolder'] = $this->publicPath .'feeds/customer';
        $items = $input['items'];
        $exists = [];
        $this->processFile($input,function(&$currRow,&$stream) use (&$exists,&$retVal, &$items){
            if (isset($items[$currRow[0]])) {
                $currRow = $items[$currRow[0]];
                unset($items[$currRow[0]]);
            }
            if (!isset($exists[$currRow[0]])){
                fputcsv($stream, $currRow);
                $exists[$currRow[0]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        });
    }
}