<?php

namespace Modules\Ads\Controllers\Service;

class DataExportService
{
    /**
     * Thêm dữ liệu vào file CSV (append)
     *
     * @param string $filePath Đường dẫn file CSV
     * @param array $data Mảng dữ liệu
     * @return void
     */
    /**
     * Append data to a CSV file, skipping rows with duplicate values in a specified column.
     *
     * @param string $filePath Path to the CSV file.
     * @param array $data Array of rows to append.
     * @param array|null $header Optional header row.
     * @param string|null $uniqueColumn Column name to check for duplicates. If null, no duplicate check.
     *
     * @throws \Exception
     */
    function appendCsvFileUniqueColumn(string $filePath, array $data, array $header = null, string $uniqueColumn = null)
    {
        if (empty($data)) {
            throw new \Exception("Data array is empty.");
        }

        $dir = dirname($filePath);
        if (!is_dir($dir) && !mkdir($dir, 0777, true) && !is_dir($dir)) {
            throw new \Exception("Cannot create directory: {$dir}");
        }

        $existingValues = [];
        $fileExists = file_exists($filePath);

        if ($uniqueColumn && $fileExists && ($fpRead = fopen($filePath, 'r')) !== false) {
            $existingHeader = fgetcsv($fpRead);
            if ($existingHeader !== false) {
                $uniqueIndex = array_search($uniqueColumn, $existingHeader);
                if ($uniqueIndex !== false) {
                    while (($row = fgetcsv($fpRead)) !== false) {
                        $existingValues[$row[$uniqueIndex]] = true;
                    }
                } else {
                    throw new \Exception("Unique column '{$uniqueColumn}' not found in existing CSV header.");
                }
            }
            fclose($fpRead);
        }

        $fp = fopen($filePath, 'a');
        if (!$fp) {
            throw new \Exception("Cannot open file for writing: {$filePath}");
        }

        if (!$fileExists || filesize($filePath) === 0) {
            $headerRow = $header ?? array_keys((array)$data[0]);
            fputcsv($fp, $headerRow);
        }

        foreach ($data as $row) {
            $rowArray = (array)$row;

            if ($uniqueColumn && isset($rowArray[$uniqueColumn]) && isset($existingValues[$rowArray[$uniqueColumn]])) {
                continue; // bỏ qua trùng
            }

            fputcsv($fp, $rowArray);

            if ($uniqueColumn && isset($rowArray[$uniqueColumn])) {
                $existingValues[$rowArray[$uniqueColumn]] = true; // đánh dấu đã tồn tại
            }
        }

        fclose($fp);
    }





}