<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use App\Modules\Ads\Models\PlatformFileAds;
use App\Modules\Ads\Models\ProductAds;
use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;

class FacebookService extends BaseService
{
    protected $productAds;

    public function __construct(ProductAds $productAds)
    {
        $this->locale = !empty(env('APP_LOCALE')) ? env('APP_LOCALE') : 'us';
        $this->productAds = $productAds;
    }

    public function getProductAds($filters)
    {
        $filters['columns'] = [
            'id', 'title', 'sku', 'link', 'image_link', 'brand', 'google_product_category', 'price', 'status',
            'product_type', 'color', 'size', 'gender', 'age_group', 'shipping', 'material',
            'custom_label_0', 'custom_label_1', 'custom_label_2', 'custom_label_3', 'custom_label_4'
        ];
        return $this->getListByFilter($this->productAds,$filters);
    }

    public function createDataSource()
    {
        $retVal = [];
        $lastFile = PlatformFileAds::query()->where('platform', 'facebook')->orderBy('id', 'desc')->first();
        $lastDataSourceId = $lastFile ? (intval($lastFile->data_source_id) + 1) : 1;
        $retVal['dataSourceId'] = $lastDataSourceId;
        return $retVal;
    }

    public function convertProduct($product)
    {
        $retVal = [];
        $retVal['id'] = $product->sku;
        $retVal['title'] = $product->title;
        $retVal['description'] = $product->title;
        $retVal['link'] = $product->link;
        $retVal['image_link'] = getImageCdn($product->image_link, 630, 630);
        $retVal['availability'] = "in stock";
        $retVal['brand'] = $product->brand;
        $retVal['google_product_category'] = $product->google_product_category;
        $retVal['price'] = $product->price;
        $retVal['product_type'] = $product->product_type;
        $retVal['custom_label_0'] = $product->custom_label_0;
        $retVal['custom_label_1'] = $product->custom_label_1;
        $retVal['custom_label_2'] = $product->custom_label_2;
        $retVal['custom_label_3'] = $product->custom_label_3;
        $retVal['custom_label_4'] = $product->custom_label_4;
        $retVal['color'] = $product->color;
        $retVal['size'] = $product->size;
        $retVal['gender'] = $product->gender;
        $retVal['age_group'] = $product->age_group;
        $retVal['shipping'] = $this->convertShipping($product->shipping);
        $retVal['mpn'] = $this->locale . $product->id;
        $retVal['material'] = $product->material;
        $retVal['condition'] = "new";
        return $retVal;
    }

//
    public function convertShipping($shipping)
    {
        $result = null;
        $arr = json_decode($shipping, true);
        $first = $arr[0];
        $parts = explode(":", $first);
        $result = $parts[0] . ':' . $parts[count($parts) - 1];
        return $result;
    }

    public function formatDateTime($time, $format = "Y-m-d H:i:s")
    {
        $carbon = Carbon::parse($time);
        return $carbon->format($format);
    }
    public function convertDeleteProductId($mpn)
    {
        if (substr($mpn, 0, strlen($this->locale)) === $this->locale) {
            return substr($mpn, strlen($this->locale));
        }
        return null;
    }
}