<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Modules\Ads\Models\ProductDataFeed;

class FeedService extends BaseService
{
    private $googleAdsApiToken;
    private $googleAdsApiUrl;
    public function __construct()
    {
        $this->googleAdsApiToken = \Config::get('ads::ads.google_ads_api_token');
        $this->googleAdsApiUrl = \Config::get('ads::ads.google_ads_api_url','');
    }
    public function buidFilter($filter){
        $productQuery = DB::table('product')->join(DB::raw("sb_product_n_category force index(pId_cId)"), 'product_n_category.product_id', 'product.id')->where('product_n_category.is_parent', 0);

        if(array_key_exists('status', $filter)){
            $productQuery->where('product.status', $filter['status']);
        }
        if(array_key_exists('approve_advertising', $filter)){
            $productQuery->where('product.approve_advertising', $filter['approve_advertising']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->from(DB::raw("sb_product USE INDEX (PRIMARY)"));
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('is_trademark', $filter)){
            $productQuery->where('product.is_trademark', $filter['is_trademark']);
        }
        if(array_key_exists('is_violation', $filter)){
            $productQuery->where('product.is_violation', $filter['is_violation']);
        }
        if(array_key_exists('sold_from', $filter)){
            $productQuery->where('product.sold', '>=', $filter['sold_from']);
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('categoryIds', $filter)){
            $productQuery->whereIn('product_n_category.category_id', $filter['categoryIds']);
        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }

        return $productQuery;
    }
    public function buildDeleteQuery($filter)
    {
        $productQuery = DB::table('product');
        if (array_key_exists('skip_ads', $filter)) {
            $productQuery->where(function ($query) {
                $query->orWhere('is_trademark', '=', 1);
                $query->orWhere('is_violation', '=', 1);
                $query->orWhere('approve_advertising', '=', 0);
                $query->orWhere('status', '!=', 'ACTIVE');
            });
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('deleted_at_from', $filter)){
            $productQuery->where('product.deleted_at', '>=', $filter['deleted_at_from']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        $productQuery->select(['product.id']);
        return $productQuery;
    }

    public function createPageFeed($product, $input){
        $retVal = false;
        $item['url'] = URL('/'). $input['prefixUrl'] . '/' . $product->slug . '-p' . $product->id;
        $item['label'] = $product->name;
        if ($product->account_id == $input['customerId']){
            if (!empty($product->product_resource)){
                $item['productResourceName'] = $product->product_resource;
            }
            if (!empty($product->product_map_feed_resource)){
                $item['productMapFeedResourceName'] = $product->product_map_feed_resource;
            }
        }
        $params = [
            'customerId' => $input['customerId'],
            'item' => $item,
            'feedResourceName' => $input['feedResourceName']
        ];
        $url = $this->googleAdsApiUrl . '/asset/update-page-feed';
        $result = $this->triggerSyncRequest($url,'POST', $params, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
        if(!empty($result['result']) && is_array($result['result'])){
            $dataSave = [
                'account_id' => $input['customerId'],
                'product_id' => $product->id,
                'feed_resource' => $input['feedResourceName'],
                'product_resource' => $result['result']['productResourceName'],
                'product_map_feed_resource' => $result['result']['productMapFeedResourceName'],
            ];
            $this->saveProductDataFeed($dataSave);
            $retVal = true;
        }
        return $retVal;
    }

    public function saveProductDataFeed($data){
        $query = ProductDataFeed::where('product_id', $data['product_id'])
                                ->where('feed_resource', $data['feed_resource']);
        $product = $query->first();
        if (empty($product)){
            $product = new ProductDataFeed();
            $product->created_at = date('Y-m-d H:i:s');
        }
        if (!empty($data['product_id'])){
            $product->product_id = $data['product_id'];
        }
        if (!empty($data['account_id'])){
            $product->account_id = $data['account_id'];
        }
        if (!empty($data['feed_resource'])){
            $product->feed_resource = $data['feed_resource'];
        }
        if (!empty($data['product_map_feed_resource'])){
            $product->product_map_feed_resource = $data['product_map_feed_resource'];
        }
        if (!empty($data['product_resource'])){
            $product->product_resource = $data['product_resource'];
        }
        $product->updated_at = date('Y-m-d H:i:s');
        $product->save();
    }

    public function deletePageFeed($products, $input){
        $retVal = 0;
        $resources = [];
        foreach ($products as $product){
            $resources[] = $product->product_map_feed_resource;
        }
        if (!empty($resources)){
            $params = [
                'customerId' => $input['customerId'],
                'productMapFeedResourceNames' => $resources
            ];
            $url = $this->googleAdsApiUrl . '/asset/delete-page-feed';
            $result = $this->triggerSyncRequest($url,'POST', $params, ['token: ' . $this->googleAdsApiToken,'Content-Type: application/json']);
            if(!empty($result['result']) && is_array($result['result'])){

                $retVal = count($result['result']);
            }
        }
        return $retVal;
    }
    public function getTreeCategoryIds($categoryId){
        $retVal = [$categoryId];
        $parent = DB::table('category')
            ->where('id',$categoryId)
            ->where('type','PRODUCT')
            ->first(['id','_lft','_rgt']);
        if (!empty($parent)){
            $retVal = DB::table('category')
                ->where('_lft','>=',$parent->_lft)
                ->where('_rgt','<=',$parent->_rgt)
                ->where('type','PRODUCT')
                ->pluck('id')->toArray();
        }
        return $retVal;
    }
}