<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Ads\Controllers\AdsController;
use Modules\Ads\Controllers\Service\Exception;
use Modules\Ads\Controllers\Service\MerchantProductService;
use Modules\Ads\Models\Category;
use Modules\Ads\Models\Country;
use Modules\Ads\Models\MerchantProduct;
use Modules\Ads\Models\ProductSku;
use Module;
use Cache;
use Modules\Ads\Services\ProductInfoGalleryService;
use Carbon\Carbon;
use Modules\Localization\Controllers\Services\ConvertPriceService;

class GoogleMerchantService extends BaseService
{
    private $merchantProductService;
    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;

    }
    public function buildProduct($products, $input = []){
        $retVal = [];
        $language = $input['language'];
        $country = $input['country'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        foreach ($products as $product){

            $item = [
                'id' => $product->id,
                'product_code' => $product->sku,
                'title' => $product->title,
                'description' => $product->description,
                'condition' => 'new',
                'sku_category_merchant_id' => !empty($product->google_product_category)?$product->google_product_category:1604,
                'product_type' => $product->product_type,
                'link' => $this->buildUrl($product, $input),
                'image_url' => $product->image_link,
                'gallery' => $this->buildProductGallery($product),
                'availability' => 'in_stock',
                'price' => $this->convertPrice($product->price),
                'high_price' => $this->convertPrice($product->high_price),
                'currency' => $currency,
                'brand' => $product->brand,
                'language' => $language,
                'country' => $country,
                'shippingFees' => $this->getShippingFees($product, $input),
                'sold' => $product->sold,
                'barcode' => $product->barcode,
                'merchantId' => $this->merchantProductService->getMerchantId($product, $input),
                'custom_label_0' => $product->custom_label_0,
                'custom_label_1' => $product->custom_label_1,
                'custom_label_2' => $product->custom_label_2,
                'custom_label_3' => $product->custom_label_3,
                'custom_label_4' => $product->custom_label_4,
                'identifier_exists' =>  'false',
                'age_group' =>  'adult',
                'age' =>  'adult',
            ];
            if ($item['high_price'] <= $item['price']){
                $item['high_price'] = $item['price'];
            }
            if (!empty($product->color)){
                $item['color'] = $product->color;
            }
            if (!empty($product->gender)){
                $item['gender'] = $product->gender;
            }
            if (!empty($product->age_group)){
                $item['age_group'] = $product->age_group;
                $item['age'] = $product->age_group;
            }
            if (!empty($product->size)){
                $item['size'] = $product->size;
            }
            if (!empty($product->material)){
                $item['material'] = $product->material;
            }
            $this->setAutoMinPrice($item);
            $retVal[$item['id']] = $item;
        }
        return $retVal;
    }
    public function setAutoMinPrice(&$item){
        try {
            $defaultMargin = 0.15;
            $item['cost_of_goods_sold'] = roundUp($item['price'] * 0.75,2);
            $item['auto_pricing_min_price'] = roundUp($item['price'] * (1-$defaultMargin),2);
            $item['cost_of_goods_sold'] = $this->convertPrice($item['cost_of_goods_sold']);
            $item['auto_pricing_min_price'] = $this->convertPrice($item['auto_pricing_min_price']);
        }catch (Exception $e){
        }
    }


    private function buildUrl($product, $input = []){
        $retVal = $product->link;
        $prefixUrl = $input['prefixUrl'];
        $urlData =  parse_url($retVal);
        $path = $urlData['path'];
        $paths = explode('/',$path);
        if (count($paths) == 2 && !empty($prefixUrl)){
            $retVal = $urlData['scheme'] . '://' . $urlData['host'] .$prefixUrl . $path . (isset($urlData['query']) ? '?' . $urlData['query'] : '');
        }
        return $retVal;
    }
    private function convertPrice($price){
        $retVal = $price;
        $convertService = new ConvertPriceService();
        if (method_exists($convertService, 'convertPriceCurrency')) {
            $retVal = $convertService->convertPriceCurrency($price, false);
        }
        return $retVal;
    }

    private function getShippingFees($product, $input){
        $retVal = [];
        $countryCode = $input['country'];
        $currency = $input['currency'];
        try {
            $shippingData = json_decode($product->shipping, true);
            $countryCodes = $this->merchantProductService->getShippingCoutries($countryCode,$product);
            $generalConfig = \Config::get('ads::clara-ads-general');
            if (isset($generalConfig['shippingIgnoreCountry'][$countryCode]) && is_array($generalConfig['shippingIgnoreCountry'][$countryCode])){
                foreach ($generalConfig['shippingIgnoreCountry'][$countryCode] as $code){
                    if (isset($countryCodes[$code])){
                        unset($countryCodes[$code]);
                    }
                }
            }
            foreach ($shippingData as $item){
                $data = explode(":",$item);
                if (!in_array($data[0],$countryCodes)){
                    continue;
                }
                $shippingItem = [
                    'country' => $data[0],
                    'shippingTime' => [
                        'min_handling_time' => $data[1],
                        'max_handling_time' => $data[2],
                        'min_transit_time' => $data[3],
                        'max_transit_time' => $data[4],
//                        'shipping_fee' => $this->convertPrice($data[5]),
                    ],
                    'price' => $this->convertPrice($data[6]),
                    'currency' => $currency,
                ];
                $retVal[] = $shippingItem;
            }
        }catch (\Exception $e){
            \Log::error("ShippingInfo: $product->id" . $e->getMessage());
        }
        return $retVal;
    }

    private function buildProductGallery($product){
        $retVal = [];
        try {
            $retVal = json_decode($product->images, true);
        }catch (\Exception $e){
            \Log::error("Images: $product->id" . $e->getMessage());
        }
        return $retVal;
    }

    public function buildDeleteQuery($filter)
    {
        $query = DB::table('product_ads')->join('merchant_product','product_ads.id','=','merchant_product.product_ads_id');

        if(array_key_exists('updated_at_from', $filter)){
            $query->where('product_ads.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $query->where('product_ads.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $query->where('product_ads.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $query->where('product_ads.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('status', $filter)){
            $query->where('product_ads.status', '=', $filter['status']);
        }
        if(array_key_exists('status', $filter)){
            $query->where('product_ads.status', '=', $filter['status']);
        }
        $query->where('product_ads.sold',0);
        if(array_key_exists('columns', $filter)){
            $query->select($filter['columns']);
        }else{
            $query->select(['merchant_product.id','merchant_product.sku','merchant_product.id']);
        }
        return $query;
    }

    public function buildProductDelete($products, $input){
        $data = [];
        foreach ($products as $product){
            $data[$product->id] = [
                    'language' => $input['language'],
                    'country' => $input['country'],
                    'product_code' => $product->sku,
                    'id' => $product->product_id,
                    'merchantProductId' => $product->id,
                    'merchantId' => $this->merchantProductService->getMerchantId($product->product_id,$input)
            ];
        }
        return $data;
    }


}
