<?php

namespace App\Modules\Ads\Controllers\Service;

class IncorrectLanguageService
{
    protected $items = [];

    public function getData($filters)
    {
        $sku = isset($filters['sku']) ? $filters['sku'] : '';
        $name = isset($filters['name']) ? $filters['name'] : '';
        $translate_name = isset($filters['translate_name']) ? $filters['translate_name'] : '';
        $is_translate = isset($filters['is_translate']) ? $filters['is_translate'] : null;
        $is_update = isset($filters['is_update']) ? $filters['is_update'] : null;
        $page_size = isset($filters['page_size']) ? $filters['page_size'] : 20;
        $page_id = isset($filters['page_id']) ? $filters['page_id'] : 0;

        $query = \DB::table('incorrect_language');
        if (!empty($sku)) {
            $query->where('sku', 'like', '%' . $sku . '%');
        }
        if (!empty($name)) {
            $query->where('name', 'like', '%' . $name . '%');
        }
        if (!empty($translate_name)) {
            $query->where('translate_name', 'like', '%' . $translate_name . '%');
        }
        if (isset($is_translate)) {
            $query->where('is_translate', $is_translate);
        }
        if (isset($is_update)) {
            $query->where('is_update', $is_update);
        }
        $count = $query->count();
        $offset = $page_id * $page_size;
        $items = $query->limit($page_size)->offset($offset)->get();
        $pageCount = $this->recordsCountToPagesCount($count, $page_size);

        $meta = [
            'has_next' => $page_size + 1 < $pageCount,
            'off_set' => $page_size * $page_id,
            'page_count' => $pageCount,
            'page_id' => $page_id,
            'total_count' => $count,
            'page_size' => $page_size,
        ];

        return array(
            "status" => 'successful',
            "result" => $items,
            "meta" => $meta,
        );
    }

    protected function recordsCountToPagesCount($recordsCount, $pageSize)
    {
        $retVal = (int)($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        return $retVal;
    }
}