<?php

namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Ads\Controllers\AdsController;
use Modules\Ads\Models\Category;
use Modules\Ads\Models\Country;
use Modules\Ads\Models\MerchantProduct;
use Modules\Ads\Models\ProductSku;
use Module;
use Cache;
use Modules\Ads\Services\ProductInfoGalleryService;
use Carbon\Carbon;

class MerchantProductService extends BaseService
{
    private $adsController;
    // ds sp dung quang cao
    private $productDisapproveAdvertising;
    private $productHasAnOrder;
    private $productSoldClone;
    private $contentUsers;
    private $experimentProductConfig;
    private $changeImageDomainProductConfig;
    private $apparelAccessoriesGMC;
    private $tshirtGMC;
    private $optionLabel;
    private $automationDiscountConfig;
    private $automationProductIds;
    private $ignoreChangeImageDomain;
    private $merchantAccountConfig;
    private $productTotalSale;
    private $labelRegex;
    private $customLabelSources;
    private $adsConfig;

    static $cacheShippingTemplate = [];
    static $countryCache = [];
    static $productCrawlCache = [];
    public function __construct(AdsController $adsController)
    {
        $this->adsController = $adsController;
        $this->productDisapproveAdvertising = $this->getProductDisapprove();
        $this->productHasAnOrder = $this->getProductHasAnOrder();
        $this->productSoldClone = $this->getSoldProductClone();
        $this->experimentProductConfig = getOptionByDomain('experimentProduct');
        $this->automationDiscountConfig = getOptionByDomain('automationDiscount');
        $this->automationProductIds= getOptionByDomain('automationProductIds',[]);
//        var_dump($this->automationDiscountConfig);die;
        $this->ignoreChangeImageDomain = getOptionByDomain('merchant_ignore_change_image_domain');
        $this->changeImageDomainProductConfig = getOptionByDomain('changeImageDomainProduct');
        $this->labelRegex = getOptionByDomain('ads_label_regex_priority');
        $this->apparelAccessoriesGMC = \Config::get('ads::clara-ads-general.apparelAccessoriesGMC',[]);
        $this->tshirtGMC = \Config::get('ads::clara-ads-general.tshirtGMC',[]);
        $this->optionLabel = \Config::get('ads::clara-ads-general.optionLabel',0);
        $this->merchantAccountConfig = getOptionByDomain('merchant_account_config', []);
        $this->productTotalSale = $this->getProductTotalSale();
        $this->customLabelSources = \Config::get('ads::ads.customLabelSources',[]);
        $this->adsConfig = \Config::get('ads::ads',[]);
//        $this->contentUsers = $this->getUserContent();

    }
    public function buidFilter($filter){
        $forceIndex = false;
        $productQuery = DB::table('product');
        $productInfoTable = 'product_info';
        if (array_key_exists('pInfo',$filter)){
            $productInfoTable = $productInfoTable . '_' .$filter['pInfo'];
        }
        $productQuery->join($productInfoTable.' as product_info', 'product.id', 'product_info.product_id')
            ->join('product_n_category', 'product_n_category.product_id', 'product.id')
//            ->join('product_approve_advertising', 'product_approve_advertising.product_id', 'product.id')
            ->where('product_n_category.is_parent', 0);
        if (Schema::hasTable('ads_shipping_info')){
            $productQuery->leftJoin('ads_shipping_info','ads_shipping_info.product_id','=','product.id');
        }
        if (Schema::hasTable('score_product') && array_key_exists('score', $filter)){
            $productQuery->join('score_product','score_product.id','=','product.id');
            $scoreTarget = $this->getScoreTarget();
            $productQuery->where(function($query) use ($scoreTarget){
                $query->where('score_product.score','>=', $scoreTarget)
                    ->orWhere('product.sold','>',0);
            });
        }
        if(array_key_exists('status', $filter)){
            $productQuery->where('product.status', $filter['status']);
        }
        if(array_key_exists('approve_advertising', $filter)){
            $productQuery->where('product.approve_advertising', $filter['approve_advertising']);
        }
//        if(array_key_exists('advertising_status', $filter)){
//            $productQuery->where('product_approve_advertising.advertising_status', $filter['advertising_status']);
//        }
        if(array_key_exists('social_status', $filter)){
            $productQuery->join('product_feed_approve', 'product_feed_approve.product_id', 'product.id');
        }
        if(array_key_exists('social_type', $filter)){
            $productQuery->where('product_feed_approve.type', $filter['social_type']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('is_trademark', $filter)){
            $productQuery->where('product.is_trademark', $filter['is_trademark']);
        }
        if(array_key_exists('is_default', $filter)){
            $productQuery->where('product_info.is_default', $filter['is_default']);
        }
        if(array_key_exists('category_merchant_id_from', $filter)){
            $productQuery->where('product_info.category_merchant_id', '>=', $filter['category_merchant_id_from']);
        }
        if(array_key_exists('is_violation', $filter)){
            $productQuery->where('product.is_violation', $filter['is_violation']);
        }
        if(array_key_exists('sold_from', $filter)){
            $productQuery->where('product.sold', '>=', $filter['sold_from']);
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('ids', $filter)){
            $forceIndex = true;
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('categoryIds', $filter)){
            $productQuery->whereIn('product_n_category.category_id', $filter['categoryIds']);
        }
        if(array_key_exists('actor_ids', $filter)){
            $productQuery->whereIn('product.actor_id', $filter['actor_ids']);
        }
        if (array_key_exists('seller', $filter)){
            $productQuery->join('product_n_user','product_n_user.product_id','=','product.id');
        }
        if(array_key_exists('sellerIds', $filter)){
            $productQuery->whereIn('product_n_user.user_id',$filter['sellerIds']);
        }
        if(array_key_exists('ignoreSellerIds', $filter)){
            $productQuery->whereNotIn('product_n_user.user_id',$filter['ignoreSellerIds']);
        }
        $productQuery->groupBy('product.id');
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }
        if (Schema::hasTable('ads_shipping_info')){
            $productQuery->addSelect('ads_shipping_info.shipping_info');
            $productQuery->addSelect('ads_shipping_info.product_sku_id as shipping_product_sku_id');
        }
        if (array_key_exists('order_by', $filter)){
            $productQuery->orderBy($filter['order_by']);
        }elseif(!array_key_exists('ignore_chunk', $filter)){
//            if(array_key_exists('product_id_from', $filter)){
//                $productQuery->orderBy('product.id');
//            }else{
//                $productQuery->orderBy('product.updated_at','desc');
//            }
        }else{
            $forceIndex = true;
        }
        if ($forceIndex){
            $productQuery->from(DB::raw("`sb_product` FORCE INDEX(`PRIMARY`)"));
        }
        return $productQuery;
    }

    public function buildDeleteQuery($filter)
    {
        $productQuery = DB::table('product');
        $productQuery->join('merchant_product', 'product.id', 'merchant_product.product_id');
        if (array_key_exists('product_info', $filter)){
            $productQuery->join('product_info', 'product.id', 'product_info.product_id');
        }
        if (array_key_exists('skip_ads', $filter)) {
            $productQuery->where(function ($query) {
                $query->orWhere('approve_advertising', '=', 0);
                $query->orWhere('is_trademark', '=', 1);
                $query->orWhere('is_violation', '=', 1);
                $query->orWhere('status', '!=', 'ACTIVE');
            });
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('deleted_at_from', $filter)){
            $productQuery->where('product.deleted_at', '>=', $filter['deleted_at_from']);
        }
        if(array_key_exists('actor_ids', $filter)){
            $productQuery->whereIn('product.actor_id', $filter['actor_ids']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        $productQuery->where('product.sold',0);
//        if(array_key_exists('product_id_from', $filter)){
//            $productQuery->orderBy('merchant_product.product_id');
//        }else{
//            $productQuery->orderBy('product.updated_at','desc');
//        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }else{
            $productQuery->select(['merchant_product.product_id','merchant_product.sku','merchant_product.id']);

        }
        return $productQuery;
    }

    public function getProductDisapprove(){
        $query =  DB::table('product_disapprove_advertising');
        return $query->pluck('product_id')->toArray();
    }
    public function getSoldProductClone(){
        $query =  DB::table('product_meta');
        $query->where('key','product_has_order');
        $retVal = $query->pluck('product_id')->toArray();
        return $retVal;
    }

    public function getProductHasAnOrder(){
        // bo dieu kien nay
        return [];
        $query =  DB::table('order')
            ->join('order_item','order.id','order_item.order_id')
            ->where('order.created_at','>=',date('Y-m-d', strtotime("-30 days")))
            ->groupBy('order_item.product_id');
        $retVal = $query->pluck('order_item.product_id')->toArray();
        return $retVal;
    }

    public function getProductType($product, $input = []){
//        $label = $this->getLabel($product);
        $retVal = Category::getBreadcrumbById($product->category_id);
//        if (!empty($label)){
//            $retVal = $label . ' > ' . $retVal;
//        }
        return $retVal;
    }
    public function isSkip($item,$input = [])
    {
        $retVal = false;
        if (!isset($item->slug[0]) || $item->slug[0] == '-') {
            $retVal = true;
        } elseif ($item->price <= 0) {
            $retVal = true;
        } elseif (empty(trim($item->image_url)) || strpos($item->image_url, 'http') === false) {
            $retVal = true;
        } elseif (strlen($item->slug) > 255) {
//            $retVal = true;
        } elseif(empty($item->price)){
            $retVal = true;
        }else{
            $config = \Config::get('ads::clara-ads-general');
            if (isset($config['keywordExtraneous']) && !empty($config['keywordExtraneous'])) {
                preg_match('/' . $config['keywordExtraneous'] . '/i', $item->title_replacement, $matches);
                if (!empty($matches)){
                    $retVal = true;
                }
            }
        }
        return $retVal;
    }

    public function buildSpecificInfo(&$product)
    {
        $isJson = false;
        try {
            $info = json_decode($product->sku_specific_info);
            $product->color = !empty($info->color)?$info->color:'Black/White';
            $product->size = !empty($info->size)?$info->size:'one size fits all';
            $product->gender = $info->gender;
            $product->age_group = $info->age_group;
            if (isset($info->material)){
                $product->material = $info->material;
            }
            $isJson = true;
        }catch (\Exception $exception){

        }
        $product->specific_info = [];
        if (!$isJson){
            $specs = explode(',', $product->sku_specific_info);
            for ($i = 0; $i < count($specs); $i++) {
                $spec = $specs[$i];
                $specPair = explode(':', $spec);

                if(count($specPair) === 2) {
                    for ($j = 0; $j < count($specPair); $j++) {
                        $specPair[$j] = trim($specPair[$j]);
                    }

                    $specPair = array_values($specPair);
                    $product->specific_info[$specPair[0]] = $specPair[1];
                }
            }
        }
    }

    public function buildImage($product){
        $retVal = $product->image_url;
        $productImages = $this->getReplaceImage($product->id);
        $ignore = false;
        $changeVersion = false;
        if (isset($productImages[$product->id])){
            if ($productImages[$product->id] == 'replace'){
                $retVal = $this->replaceDomain($product->image_url);
            }elseif($productImages[$product->id] == 'ignore'){
                $ignore = true;
            }elseif($productImages[$product->id] ==  'version'){
                $changeVersion = true;
            }else{
                $retVal = $productImages[$product->id];
            }
        }
        if ($this->isExperiment($product->id)){
            $retVal = getImageCdn($product->image_url,630,630);
        }
        if ($this->isHighRisk($product->id)){
            $productImage = $product->image_url . '?is_high_risk=' . date("Ymd", strtotime('monday this week'));
            $retVal = getImageCdn($productImage,630,630);
        }elseif ($this->isChangeImageDomain($product->id) && !$ignore){
            $retVal = $this->replaceDomain($product->image_url);
        }
        if ($changeVersion && $product->sold < 1){
            $retVal = $this->addParamsToUrl($retVal,['v'=>1]);
        }
        return $retVal;
    }

    public function getDescription($product, $title){
        $retVal = $title;
        $description = DB::table('product_description')
            ->where('description','!=', '')
            ->where('product_id',$product->id)
            ->whereNotNull('description')
            ->get(['product_id','description']);
        foreach ($description as $brief){
            $retVal = $brief->description;
            break;
        }
        $trans = [
            'https://Printerval.com' => 'Printerval.com',
            'https://printerval.com' => 'Printerval.com'
        ];
        $retVal = strip_tags($retVal);
        $retVal = strtr($retVal,$trans);
        $retVal = $this->escapeSpecialCharacters($retVal);
        return $retVal;
    }

    public function getProductAdsTitle($product, $title){
        $retVal = $title;
        if (Schema::hasTable('product_ads_title')) {
            $productTitle = DB::table('product_ads_title')
                ->where('title', '!=', '')
                ->where('id', $product->id)
                ->whereNotNull('title')
                ->first();
            if (!empty($productTitle)){
                $retVal = $this->escapeSpecialCharacters($productTitle->title);
            }
        }
        return $retVal;
    }
    public function escapeSpecialCharacters($string) {
        $string = stripslashes($string);
        $string = str_replace("\\", "\\\\", $string); // Escape backslashes
        $string = str_replace('"', '\"', $string); // Escape double quotes
        return $string;
    }
    private function replaceDomain($imageUrl){
        $appUrl = env('APP_URL','https://printerval.com');
        $domain = parse_url($appUrl, PHP_URL_HOST);
        $trans = [
            "assets.$domain" => 'asset.prtvstatic.com',
            "cdn.$domain/image" => 'liveview.prtvstatic.com/image',
            "cdn.$domain/sticker" => 'sticker.prtvstatic.com/sticker',
            "cdn.$domain/unsafe" => 'liveview.prtvstatic.com/unsafe',
            "liveview.$domain" => 'liveview.prtvstatic.com',
            "sticker-liveview.$domain" => 'sticker.prtvstatic.com'
        ];
        return strtr($imageUrl,$trans);
    }

    private function getReplaceImage($productId){
        $retVal = [];
        $images = DB::table('ads_product_sku')
            ->where('image_url','!=', '')
            ->where('product_id',$productId)
            ->whereNotNull('image_url')
            ->get(['product_id','image_url']);
        foreach ($images as $image){
            $retVal[$image->product_id] = $image->image_url;
        }
        return $retVal;
    }

    private function getExcludeCondition($product, $input = []){

        $retVal = '';
        if ($product->is_always_on_ads == 0){
            $outOfStockProducts = $input['outOfStockProducts'];
            if (in_array($product->id,$this->productDisapproveAdvertising)){
                $retVal = 'Display ads, Shopping ads';
            }elseif (isset($outOfStockProducts[$product->id])){
                $retVal = 'Display ads, Shopping ads';
            }
        }
        return $retVal;
    }
/*
 * update product if exist
 * create product if not exist
 * return list product sku need remove on google merchant
 * */
    public function saveMerchantProduct($productId, $sku){
        $retVal = [];
        $isExists = false;
        $query = MerchantProduct::where('product_id', $productId);
        $products = $query->get();
        foreach ($products as $item){
            if ($item->sku != $sku){
                $retVal[] = ['productId' => $item->product_id, 'sku' => $item->sku, 'merchantProductId' => $item->id];
            }else{
                $isExists = true;
                $item->updated_at = date('Y-m-d H:i:s');
                $item->save();
            }
        }
        if (!$isExists){
            $merchantProduct = new MerchantProduct();
            $merchantProduct->product_id = $productId;
            $merchantProduct->sku = $sku;
            $merchantProduct->created_at = date('Y-m-d H:i:s');
            $merchantProduct->updated_at = date('Y-m-d H:i:s');
            $merchantProduct->save();
        }
        return [];
//        return $retVal;
    }

    public function removeMerchantProduct($productIds){
        $data = array_chunk($productIds,50);
        foreach ($data as $ids){
            MerchantProduct::whereIn('product_id', $ids)->delete();
        }
    }
    public function getLabel($product){
        $retVal = '';
        if ($product->sold > 0){
            $retVal = 'ordered';
        }elseif (isset($product->created_at)){
            $createTime = strtotime($product->created_at);

            $last30days = strtotime('-30 days');
            $last60days = strtotime('-60 days');
            $last90days = strtotime('-90 days');
            $last120days = strtotime('-120 days');
            $last150days = strtotime('-150 days');
            $last180days = strtotime('-180 days');
            $last210days = strtotime('-210 days');
            $last240days = strtotime('-240 days');
            $last270days = strtotime('-270 days');
            $last300days = strtotime('-300 days');
            $last330days = strtotime('-330 days');
            $last360days = strtotime('-360 days');

            if ($createTime >= $last30days){
                $retVal = 'last30days';
            } elseif ($createTime >= $last60days && $createTime < $last30days){
                $retVal = 'last60days';
            } elseif ($createTime >= $last90days && $createTime < $last60days){
                $retVal = 'last90days';
            } elseif ($createTime >= $last120days && $createTime < $last90days){
                $retVal = 'last120days';
            } elseif ($createTime >= $last150days && $createTime < $last120days){
                $retVal = 'last150days';
            } elseif ($createTime >= $last180days && $createTime < $last150days){
                $retVal = 'last180days';
            } elseif ($createTime >= $last210days && $createTime < $last180days){
                $retVal = 'last210days';
            } elseif ($createTime >= $last240days && $createTime < $last210days){
                $retVal = 'last240days';
            } elseif ($createTime >= $last270days && $createTime < $last240days){
                $retVal = 'last270days';
            } elseif ($createTime >= $last300days && $createTime < $last270days){
                $retVal = 'last300days';
            } elseif ($createTime >= $last330days && $createTime < $last300days){
                $retVal = 'last330days';
            } elseif ($createTime >= $last360days && $createTime < $last330days){
                $retVal = 'last360days';
            } else {
                $retVal = 'over360days';
            }
        }
        return $retVal;
    }
    public function getLabel2($product){
        $retVal = '';
        if (isset($product->created_at)){
            $createTime = strtotime($product->created_at);
            $last7days = strtotime('-7 days');
            $last30days = strtotime('-30 days');
            $last60days = strtotime('-60 days');
            $last90days = strtotime('-90 days');
            $last120days = strtotime('-120 days');
            $last150days = strtotime('-150 days');
            $last180days = strtotime('-180 days');
            $last210days = strtotime('-210 days');
            $last240days = strtotime('-240 days');
            $last270days = strtotime('-270 days');
            $last300days = strtotime('-300 days');
            $last330days = strtotime('-330 days');
            $last360days = strtotime('-360 days');
            $productCrawl = $this->getProductCrawl($product);
            if (!empty($productCrawl) && $createTime >= $last7days){
                $retVal = 'last7days';
            }elseif ($createTime >= $last30days){
                $retVal = 'last30days';
            } elseif ($createTime >= $last60days && $createTime < $last30days){
                $retVal = 'last60days';
            } elseif ($createTime >= $last90days && $createTime < $last60days){
                $retVal = 'last90days';
            } elseif ($createTime >= $last120days && $createTime < $last90days){
                $retVal = 'last120days';
            } elseif ($createTime >= $last150days && $createTime < $last120days){
                $retVal = 'last150days';
            } elseif ($createTime >= $last180days && $createTime < $last150days){
                $retVal = 'last180days';
            } elseif ($createTime >= $last210days && $createTime < $last180days){
                $retVal = 'last210days';
            } elseif ($createTime >= $last240days && $createTime < $last210days){
                $retVal = 'last240days';
            } elseif ($createTime >= $last270days && $createTime < $last240days){
                $retVal = 'last270days';
            } elseif ($createTime >= $last300days && $createTime < $last270days){
                $retVal = 'last300days';
            } elseif ($createTime >= $last330days && $createTime < $last300days){
                $retVal = 'last330days';
            } elseif ($createTime >= $last360days && $createTime < $last330days){
                $retVal = 'last360days';
            } else {
                $retVal = 'over360days';
            }
        }
        return $retVal;
    }
    public function getShippingFromLocation($product,$input){
        $retVal = '';
        $countryCode = $input['country'];
        $countryId = -1;
        $country = self::getCountryByCode($countryCode);
        if (!empty($country)){
            $countryId = $country->id;
        }
//        $startTime = microtime(true);
        $result = getProductCost($product->product_sku_id,'product_sku_id',$countryId);
        if (isset($result['warehouse'])){
            $retVal = $result['warehouse']['location'];
        }
        $endTime = microtime(true);
//        $executionTime = $endTime - $startTime;
//        $executionTimeInMilliseconds = $executionTime * 1000;
//        \Log::error("getShippingFromLocation: $product->id |  $product->product_sku_id | " . $executionTimeInMilliseconds . " ms");
        return strtolower($retVal);
    }
    public function getBrand($product){
        $retVal = $product->sku_brand;
        if (empty($retVal)){
            $retVal = 'Josey Devaluation';
        }
        return $retVal;
    }

    public function getShipping($product, $input = []){
        $retVal = [];
        $cacheData = [];
        $currency = $input['currency'];
        $countryCode = $input['country'];
        $shippingCountryCodes = [];
        if (isset($input['shippingCountryCodes'])){
            $shippingCountryCodes = $input['shippingCountryCodes'];
        }
        $countryCodes = $this->getShippingCoutries($countryCode, $product, $shippingCountryCodes);
        if (!empty($product->shipping_info) && empty($shippingCountryCodes)){
            try{
                if ($product->product_sku_id == $product->shipping_product_sku_id){
                    $shippingCache = json_decode($product->shipping_info,true);
                    foreach ($shippingCache as $item){
                        if (is_array($item)){
                            break;
                        }
                        $data = explode(":",$item);
                        if (!in_array($data[0],$countryCodes)){
                           continue;
                        }
                        $shippingItem = [
                            'country' => $data[0],
                            'shippingTime' => [
                                'min_handling_time' => $data[1],
                                'max_handling_time' => $data[2],
                                'min_transit_time' => $data[3],
                                'max_transit_time' => $data[4],
                                'shipping_fee' => $data[5],
                            ],
                            'price' => $data[6],
                            'currency' => $currency,
                        ];
                        $retVal[] = $shippingItem;
                    }
                }
            }catch (\Exception $e){
                \Log::error("ShippingInfo: $product->id |  $product->product_sku_id" . $e->getMessage());
            }
        }
        if (empty($retVal)){
            $stripeFee = doubleval(config("cart::stripe.include_fee", 0))/100;
            foreach ($countryCodes as $cCode){
                $shippingItem = [];
                $country = self::getCountryByCode($cCode);
                if (!empty($country)){
                    $shippingItem['country'] = $cCode;
                    $shippingInfo = $this->getShippingTime($product, $country->id);
                    $fee = 0;
                    if (!empty($shippingInfo)){
                        $shippingItem['shippingTime'] = $shippingInfo;
                        $fee = doubleval($shippingInfo['shipping_fee']) + round((doubleval($product->price) + doubleval($shippingInfo['shipping_fee'])) * $stripeFee,2);
                    }else{
                        continue;
                    }
//                    $listValidCategories = config("sa.category_tax_us", []);
//                    if (!empty($listValidCategories) && $cCode == 'US'){
//                        $categories = \DB::table("product_n_category")->where("product_id", $product->id)->get(["category_id"]);
//                        $categoryIds = [];
//                        foreach ($categories as $item) {
//                            $categoryIds[] = $item->category_id;
//                        }
//                        $otherTaxFee = config("cart::sa.other_tax_fee", 5);
//                        foreach ($categoryIds as $key => $value) {
//                            if (in_array($value, $listValidCategories)) {
//                                $fee = $fee + $otherTaxFee;
//                                break;
//                            }
//                        }
//                    }
//                    if (!empty($input['shippingFromLocation']) && $input['shippingFromLocation'] == 'china'){
//                        $fee = $fee + round((doubleval($product->price) + doubleval($shippingInfo['shipping_fee'])) * 0.2,2);
//                    }
                    $shippingItem['price'] = $fee;
                    $shippingItem['currency'] = $currency;
                    $retVal[] = $shippingItem;
                    $cacheItem = [
                        $cCode,
                        $shippingInfo['min_handling_time'],
                        $shippingInfo['max_handling_time'],
                        $shippingInfo['min_transit_time'],
                        $shippingInfo['max_transit_time'],
                        $shippingInfo['shipping_fee'],
                        $shippingItem['price']
                        ];
                    $cacheData[] = implode(":",$cacheItem);
                }
            }
            if (empty($shippingCountryCodes)){
                $this->saveShippingInfo(['product_id' => $product->id, 'product_sku_id' => $product->product_sku_id,'shipping_info' => json_encode($cacheData)]);
            }
        }
        return $retVal;
    }

    public function cacheShippingInfo($product,$countryCode){
        $cacheData = [];
            $stripeFee = doubleval(config("cart::stripe.include_fee", 0))/100;
            $countryCodes = $this->getShippingCoutries($countryCode, $product);
            foreach ($countryCodes as $cCode){
                $country = self::getCountryByCode($cCode);
                if (!empty($country)){
                    $shippingInfo = $this->getShippingTime($product, $country->id);
                    $fee = 0;
                    if (!empty($shippingInfo)){
                        $fee = doubleval($shippingInfo['shipping_fee']) + round((doubleval($product->price) + doubleval($shippingInfo['shipping_fee'])) * $stripeFee,2);
                    }else{
                        continue;
                    }
//                    $listValidCategories = config("sa.category_tax_us", []);
//                    if (!empty($listValidCategories) && $cCode == 'US'){
//                        $categories = \DB::table("product_n_category")->where("product_id", $product->id)->get(["category_id"]);
//                        $categoryIds = [];
//                        foreach ($categories as $item) {
//                            $categoryIds[] = $item->category_id;
//                        }
//                        $otherTaxFee = config("cart::sa.other_tax_fee", 5);
//                        foreach ($categoryIds as $key => $value) {
//                            if (in_array($value, $listValidCategories)) {
//                                $fee = $fee + $otherTaxFee;
//                                break;
//                            }
//                        }
//                    }
//                    if (!empty($input['shippingFromLocation']) && $input['shippingFromLocation'] == 'china'){
//                        $fee = $fee + round((doubleval($product->price) + doubleval($shippingInfo['shipping_fee'])) * 0.2,2);
//                    }
                    $cacheItem = [
                        $cCode,
                        $shippingInfo['min_handling_time'],
                        $shippingInfo['max_handling_time'],
                        $shippingInfo['min_transit_time'],
                        $shippingInfo['max_transit_time'],
                        $shippingInfo['shipping_fee'],
                        $fee
                    ];
                    $cacheData[] = implode(":",$cacheItem);
                }
            }
            DB::table('ads_shipping_info')->where('product_id',$product->id)->update(['created_at' => date('Y-m-d H:i:s'),'shipping_info' => json_encode($cacheData)]);
            return $cacheData;
    }

    public function getShippingTime($product,$countryId){
        $retVal = [];
        if (function_exists('getShippingInfo')) {
            $templateId = self::getTemplate($product->id);
            if ($templateId) {
                $shippingInfo = self::getShippingTemplate($templateId, $product, $countryId);
            } else {
                $shippingInfo = getShippingInfo($product, $countryId);
            }
            if (isset($shippingInfo['standard'])){
                $retVal['min_handling_time'] = $shippingInfo['standard']['handling_min_time'];
                $retVal['max_handling_time'] = $shippingInfo['standard']['handling_max_time'];
                $retVal['min_transit_time'] = $shippingInfo['standard']['delivery_min_time'];
                $retVal['max_transit_time'] = $shippingInfo['standard']['delivery_max_time'];
                $retVal['shipping_fee'] = $shippingInfo['standard']['shipping_fee'];
            }else{
                \Log::error("getShippingInfo Error return productId: $product->id | skuId: $product->sku_id | countryId: $countryId" . json_encode($shippingInfo));
            }
        }
        return $retVal;
    }

    protected static function getShippingTemplate($templateId, $product, $countryId) {
        $key = $templateId . $countryId;
        if (!array_key_exists($key, self::$cacheShippingTemplate)) {
            self::$cacheShippingTemplate[$key] = getShippingInfo($product, $countryId);
        }
        return self::$cacheShippingTemplate[$key];

    }

    protected static function getTemplate($productId) {
        $item = DB::table('product_n_template')->where('product_id', $productId)->first(['template_id']);
        return isset($item->template_id) ? $item->template_id : null;
    }


    public function getShippingCoutries($countryCode, $product,$shippingCountryCodes = []){
        $productId = $product->id;
        $countryCodes[$countryCode] = $countryCode;
        $generalConfig = \Config::get('ads::clara-ads-general');
        if (isset($generalConfig['shippingCountry'][$countryCode]) && is_array($generalConfig['shippingCountry'][$countryCode])){
            foreach ($generalConfig['shippingCountry'][$countryCode] as $code){
                $countryCodes[$code] = $code;
            }
        }
        if (isset($product->sold) && $product->sold == 0){
            if (isset($generalConfig['shippingProductIdLimitCountry'][$countryCode])){
                $maxId = $generalConfig['shippingProductIdLimitCountry'][$countryCode];
                if ($productId > $maxId){
                    $countryCodes = [$countryCode];
                }
            }
        }
        foreach ($shippingCountryCodes as $cCode){
            $countryCodes[$cCode] = $cCode;
        }
        return array_unique($countryCodes);
    }
    public function getCountryOfSales($countryCode){
        $countryCodes = [$countryCode];
        $generalConfig = \Config::get('ads::clara-ads-general');
        if (isset($generalConfig['countryOfSales'][$countryCode]) && is_array($generalConfig['countryOfSales'][$countryCode])){
            $countryCodes = array_merge($countryCodes,$generalConfig['countryOfSales'][$countryCode]);
        }
        return $countryCodes;
    }
    /*
     * Danh sach country chỉ push sản phẩm đã bán đc hàng
     * */
    public function getCountryOfSaleSold($countryCode){
        $countryCodes = [];
        $generalConfig = \Config::get('ads::clara-ads-general');
        if (isset($generalConfig['countryOfSaleSold'][$countryCode]) && is_array($generalConfig['countryOfSaleSold'][$countryCode])){
            $countryCodes = array_merge($countryCodes,$generalConfig['countryOfSaleSold'][$countryCode]);
        }
        return $countryCodes;
    }
    public function buildProduct($products, $input = []){
        $retVal = [];
        $prefixUrl = $input['prefixUrl'];
        $language = $input['language'];
        $country = $input['country'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        foreach ($products as $product){
            $isSkip = $this->isSkip($product);
            if ($isSkip){
                continue;
            }
            $this->buildSpecificInfo($product);
            $shippingFromLocation = $this->getShippingFromLocation($product,$input);
            $input['shippingFromLocation'] = $shippingFromLocation;
            $shippingFees = $this->getShipping($product,$input);
//            $shippingFees = [];
            $title = ucwords(strtolower($product->title_replacement));
            $title = $this->escapeSpecialCharacters($title);
            if (empty($title)){
                continue;
            }
            $label1 = $this->getLabel1($product);
            $item = [
                'id' => $product->id,
                'product_code' => $product->sku_code,
                'title' => $this->getProductAdsTitle($product,$title),
                'description' => $this->getDescription($product,$title),
                'condition' => 'new',
                'sku_category_merchant_id' => !empty($product->sku_category_merchant_id)?$product->sku_category_merchant_id:1604,
                'product_type' => $this->getProductType($product,$input),
                'link' => (URL('/') . $prefixUrl . "/" . $product->slug . "-p" . $product->id . "?spid=" . $product->product_sku_id),
                'image_url' => $this->buildImage($product),
                'gallery' => $this->getProductGallery($product),
                'availability' => 'in_stock',
                'excluded_destination' => $this->getExcludeCondition($product, ['outOfStockProducts' => $this->adsController->getOutOfStockProducts($prefixUrl)]),
                'price' => $product->price,
                'high_price' => $product->high_price < $product->price ? $product->price : $product->high_price,
                'currency' => $currency,
                'brand' => $this->getBrand($product),
                'language' => $language,
                'country' => $country,
                'shippingFees' => $shippingFees,
                'sold' => $product->sold,
                'merchantId' => $this->getMerchantId($product, $input),
                'custom_label_1' => $label1,
                'custom_label_2' => $this->getLabel2($product),
                'custom_label_3' => $product->sold >0 ? 'ordered':'',
                'custom_label_4' => $this->getLabel4($product),
                'material' =>  !empty($product->material)?$product->material:'',
                'identifier_exists' =>  'false'
            ];
//            $item['external_seller_id'] = str_slug($item['brand']);
            $item['barcode'] = isset($product->barcode)?$product->barcode:'';
            $label0 = $this->getLabel0($product);
            if (empty($label0)){
                $label0 = !empty($product->barcode)?$product->barcode:$this->getLabelNoDedicatedCampaign($product,['label1' => $label1]);
            }
            $item['custom_label_0'] = $label0;
//            if (isset($item['sku_category_merchant_id']) && isset($this->tshirtGMC[$item['sku_category_merchant_id']])){
//                $item['cost_of_goods_sold'] = roundUp($product->price * 0.7,2);
//                $item['auto_pricing_min_price'] = roundUp($product->price * 0.8,2);
//            }
            $this->setAutoMinPrice($item);
            $this->buildProductInfo($product,$item);
            $retVal[$item['id']] = $item;
        }
        return $retVal;
    }

    public function buildProductDelete($products, $input = []){
        $retVal = [];
        $language = $input['language'];
        $country = $input['country'];
        foreach ($products as $product ){
            $item = [
                'language' => $language,
                'country' => $country,
                'product_code' => $product['sku'],
                'id' => $product['productId'],
                'merchantProductId' => $product['merchantProductId'],
                'merchantId' => $this->getMerchantId($product['productId'],$input),
            ];
            $retVal[$product['merchantProductId']] = $item;
//            if (!array_key_exists('ignoreDatabase',$input)){
//                $this->removeMerchantProduct($product['productId'],$product['sku']);
//            }
        }
        return $retVal;
    }

    public function buildDeleteTempQuery($filter)
    {
        $productQuery = DB::table('merchant_product');
        $productQuery->join('product', 'product.id', 'merchant_product.product_id');
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('merchant_product.product_id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('merchant_product.product_id',$filter['ids']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('merchant_product.product_id','<=', $filter['product_id_to']);
        }
        $productQuery->where('product.sold','<=', 0);
        $productQuery->orderBy('merchant_product.product_id');
        $productQuery->select(['merchant_product.product_id','merchant_product.sku', 'merchant_product.id']);
        return $productQuery;
    }

    public function changeProductUpdatedAt($productId){
        if (!is_array($productId)){
            $productId = [$productId];
        }
        DB::table('product')->whereIn('id', $productId)->update(['updated_at' => date('Y-m-d H:i:s')]);

    }

    public function getProductExprieIds($filter){
        $productQuery = DB::table('merchant_product');
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('merchant_product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('merchant_product.product_id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('merchant_product.product_id','<=', $filter['product_id_to']);
        }
        return $productQuery->pluck('product_id');

    }

    public function buidFilterVariant($filter){
        $productQuery = DB::table('product');
        $productQuery->join('product_sku', 'product.id', 'product_sku.product_id')
            ->join('product_n_category', 'product_n_category.product_id', 'product.id')
            ->join('category_google_merchant', 'category_google_merchant.category_id', 'product_n_category.category_id')
            ->where('product_n_category.is_parent', 0);

        if(array_key_exists('status', $filter)){
            $productQuery->where('product.status', $filter['status']);
        }
        if(array_key_exists('approve_advertising', $filter)){
            $productQuery->where('product.approve_advertising', $filter['approve_advertising']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('is_trademark', $filter)){
            $productQuery->where('product.is_trademark', $filter['is_trademark']);
        }
        if(array_key_exists('category_merchant_id_from', $filter)){
            $productQuery->where('category_google_merchant.category_merchant_id', '>=', $filter['category_merchant_id_from']);
        }
        if(array_key_exists('is_violation', $filter)){
            $productQuery->where('product.is_violation', $filter['is_violation']);
        }
        if(array_key_exists('sold_from', $filter)){
            $productQuery->where('product.sold', '>=', $filter['sold_from']);
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('product.updated_at', '>=', $filter['updated_at_from']);
        }
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->orderBy('product.id');
        }else{
            $productQuery->orderBy('product.updated_at','desc');
        }

        return $productQuery;
    }

    public function buildProductVariant($products, $input = []){
        $retVal = [];
        $prefixUrl = $input['prefixUrl'];
        $language = $input['language'];
        $country = $input['country'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        foreach ($products as $product){

            $isSkip = $this->isSkip($product);
            if ($isSkip){
                continue;
            }
            $shippingFees = $this->getShipping($product,$input);
            $title = $this->getVariantTitle($product,$input);
            $slug = $product->slug . '-p' . $product->id;
            if (!empty($product->sku_id)){
                $slug .= '?spid=' .$product->sku_id;
            }
            $item = [
                'id' => empty($product->sku_id)?$product->id:$product->sku_id,
                'product_code' => empty($product->sku_code)?$product->sku:$product->sku_code,
                'title' => $title,
                'description' => $title,
                'condition' => 'new',
                'sku_category_merchant_id' => $product->category_merchant_id,
                'product_type' => $this->getProductType($product, $input),
                'link' => (URL('/') . $prefixUrl . "/" . $slug),
                'image_url' => empty($product->sku_image)?$product->image_url:$product->sku_image,
                'availability' => 'in_stock',
                'excluded_destination' => '',
                'price' => empty($product->sku_price)?$product->price:$product->sku_price,
                'currency' => $currency,
                'brand' => 'Printerval',
                'language' => $language,
                'country' => $country,
                'shippingFees' => $shippingFees,
            ];
            $retVal[] = $item;
        }
        return $retVal;
    }

    private function getVariantTitle($product){
        $title = $product->name;
        $sku = ProductSku::where('id',$product->sku_id)->first();
        if (!empty($sku->product_name)){
            $title = $sku->product_name;
        }
        return ucwords(strtolower($title));
    }

    public function getUserContent(){
        $retVal = [];
        $users = DB::select("select u.id, u.name, u.email from `sb_permission` as p
                            join sb_role_n_permission as rp on rp.permission_id = p.id and p.value = 'content_product'
                            join sb_role_n_user as ru on ru.role_id = rp.role_id
                            join sb_users as u on u.id = ru.user_id");
        foreach ($users as $item){
            $retVal[$item->id] = $item->name;
        }
        return $retVal;
    }
  /*
    product_id @int
    product_sku_id @int
    shipping_info @array
  */
    private function saveShippingInfo($input = []){
        if (Schema::hasTable('ads_shipping_info')){
            DB::table('ads_shipping_info')->where('product_id',$input['product_id'])->delete();
            $input['created_at'] = date('Y-m-d H:i:s');
            DB::table('ads_shipping_info')->insert($input);
        }
    }

    public function getProductGallery($product){
        $productId = $product->id;
        $productImage = $product->image_url;
        $retVal = [];
        if ($this->isHighRisk($productId)){
            $dayOfWeek = date('w');
            if ($dayOfWeek == 0 || $dayOfWeek > 3){
                $productImage = $productImage . '?is_high_risk=' . date("Ymd", strtotime('monday next week'));
                $retVal[] = getImageCdn($productImage,630,630);
            }
        }else{
            $retVal = $this->getAdditionalImages($product);

        }
        return $retVal;

    }

    private function isExperiment($productId){
        return false;
        $retVal = false;
        if (
            !empty($this->experimentProductConfig) &&
            isset($this->experimentProductConfig->from) &&
            isset($this->experimentProductConfig->to)
        ){
            if (
                $productId >= $this->experimentProductConfig->from &&
                $productId <= $this->experimentProductConfig->to
            ){
                $retVal = true;
            }
        }
        return $retVal;
    }

    private function isChangeImageDomain($productId){
        $retVal = false;
        if (!isset($this->ignoreChangeImageDomain->{$productId})){
            if (!empty($this->changeImageDomainProductConfig)){
                if (isset($this->changeImageDomainProductConfig->from)){
                    if ($productId >= $this->changeImageDomainProductConfig->from){
                        $retVal = true;
                    }
                    if (isset($this->changeImageDomainProductConfig->to)){
                        if ($productId > $this->changeImageDomainProductConfig->to){
                            $retVal = false;
                        }
                    }
                }
            }
        }
        return $retVal;
    }

    public function buildProductInfo(&$product, &$item){
        $isBuild = false;
        if(isset($item['sku_category_merchant_id'])){
           if (isset($this->apparelAccessoriesGMC[$item['sku_category_merchant_id']])){
               $isBuild = true;
           }
        }else{
            $isBuild = true;
        }
        if ($isBuild){
            $shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
            $age = 'adult';
            $size = 'one size fits all';
            $color = 'Black/White';
            $gender = 'unisex';
            if (isset($product->color) && !empty($product->color)){
                $color = $product->color;
            }
            if (isset($product->age) && !empty($product->age)){
                $age = $product->age;
            }
            if (isset($product->size) && !empty($product->size)){
                $size = $product->size;
            }
            if (isset($product->gender) && !empty($product->gender)){
                $gender = $product->gender;
            }
            if (!empty($product->specific_info)){
                $product = get_object_vars($product);
                $age = isset($shoppingFeedConfig['columns']['g:age_group']) ? call_user_func_array($shoppingFeedConfig['columns']['g:age_group'], [&$product]) : ' ';
                $size = isset($shoppingFeedConfig['columns']['g:size']) ? call_user_func_array($shoppingFeedConfig['columns']['g:size'], [&$product]) : ' ';
                $color = isset($shoppingFeedConfig['columns']['g:color']) ? call_user_func_array($shoppingFeedConfig['columns']['g:color'], [&$product]) : ' ';
                $gender = isset($shoppingFeedConfig['columns']['g:gender']) ? call_user_func_array($shoppingFeedConfig['columns']['g:gender'], [&$product]) : '';
            }
            $item['age'] = $age;
            $item['age_group'] = $age;
            $item['size'] = $size;
            $item['color'] = $color;
            $item['gender'] = $gender;
        }
    }

    public function buildProductPrice($products, $input = []){
        $retVal = [];
        $language = $input['language'];
        $country = $input['country'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        foreach ($products as $product){
            $item = [
                'id' => $product->id,
                'product_code' => $product->sku,
                'price' => $product->price,
                'high_price' => $product->high_price < $product->price?$product->price:$product->high_price,
                'currency' => $currency,
                'language' => $language,
                'country' => $country,
                'merchantId' => $this->getMerchantId($product,$input)
            ];
            $retVal[$product->id] = $item;
        }
        return $retVal;
    }
    
    public function getMerchantId($product, $input = []){
        if (isset($input['merchant_id'])){
            $retVal = $input['merchant_id'];
        }else{
            if (isset($product->id)){
                $productId = $product->id;
            }else{
                $productId = $product;
            }
            $defaultMerchantId = getOption('merchant_id', '398409240');
            $retVal =$defaultMerchantId;
            foreach ($this->merchantAccountConfig as $config){
                if ($productId >= $config->from && $productId <= $config->to){
                    $retVal = $config->merchantId;
                    break;
                }
            }
        }

        return $retVal;
    }

    public function buildDeleteQueryByScore($filter)
    {
        $productQuery = DB::table('merchant_product');
        $productQuery->join('score_product', 'score_product.id', 'merchant_product.product_id');
        $productQuery->join('product', 'product.id', 'merchant_product.product_id');
        $productQuery->where('score_product.score', '<', $filter['score']);
        $productQuery->where('merchant_product.is_delete',0);
//        $productQuery->where(function($query){
//            $query->orWhere('product.status', '!=', 'active')
//                ->orWhere('product.is_violation', 1)
//                ->orWhere('product.is_trademark', 1);
//        });
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('sold', $filter)){
            $productQuery->where('product.sold', $filter['sold']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }else{
            $productQuery->select(['merchant_product.product_id','merchant_product.sku','product.id','product.sold','score_product.score']);
        }
        return $productQuery;
    }

    public function getScoreTarget(){
        $retVal = 0;
        if (Schema::hasTable('score_product')){
            $limit = getOption('gmc.limit');
            $score = DB::table('score_product_order')->where('order','<',$limit)->min('score');
            if (!empty($score)){
                $retVal = $score;
            }
        }
        return $retVal;
    }

    public function updateDeleteMerchantProduct($productIds, $isDelete = 1){
        if (Schema::hasColumn('merchant_product', 'is_delete') && !empty($productIds) ){
            $chunks = array_chunk($productIds,200);
            foreach ($chunks as $updateIds){
                MerchantProduct::whereIn('product_id', $updateIds)->update(['is_delete' => $isDelete]);
            }
        }
    }

    public function logDeleteMerchantProduct($productIds){
        DB::table('merchant_product_log')->whereIn('product_id',$productIds)->delete();
        $data = [];
        foreach ($productIds as $id){
            $data[] = ['product_id' => $id, 'created_at' => date('Y-m-d H:i:s')];
        }
        DB::table('merchant_product_log')->insert($data);
    }

    public function getProductIdsByScore($filter)
    {
        $productQuery = DB::table('product');
        $productQuery->leftJoin('merchant_product', 'product.id', 'merchant_product.product_id');
        $productQuery->join('score_product', 'product.id', 'score_product.id');
        $productQuery->join('product_info', 'product.id', 'product_info.product_id');
        $productQuery->where('score_product.score', '>=', $filter['score']);
        $productQuery->where('product.status', 'active');
        $productQuery->where('product.is_trademark', 0);
        $productQuery->where('product.is_violation', 0);
        $productQuery->whereNull('product.deleted_at');
        $productQuery->whereNull('merchant_product.product_id');
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('product.id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('approve_advertising', $filter)){
            $productQuery->where('product.approve_advertising', $filter['approve_advertising']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('product.id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('ids', $filter)){
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if(array_key_exists('columns', $filter)){
            $productQuery->select($filter['columns']);
        }else{
            $productQuery->select(['product.id','score_product.score','product.sold']);
        }
        $productQuery->from(DB::raw("`sb_product` FORCE INDEX(`PRIMARY`)"));
        return $productQuery->get()->toArray();
    }

    public function insertPreCalculate($products, $tableName){
        if (!empty($products)){
            $data = array_chunk($products,10000);
            foreach ($data as $items){
                foreach ($items as $product){
                    $isExists = DB::table($tableName)
                        ->where('id', $product->id)->exists();
                    $row = [
                        'id' => $product->id,
                        'score' => $product->score,
                        'created_at' => date('Y-m-d H:i:s')
                    ];
                    if (Schema::hasColumn($tableName, 'sold') && isset($product->sold)){
                        $row['sold'] = $product->sold;
                    }
                    if (!$isExists){
                        DB::table($tableName)->insert([$row]);
                    }else{
                        DB::table($tableName)
                            ->where('id', $product->id)->update($row);
                    }
                }
            }
        }
    }

    public function getProductCalculate($tableName,$limit = 2000, $ignoreDelete = false, $filter = []){
        $query = DB::table($tableName)
            ->limit($limit);
        if (array_key_exists('order',$filter)){
            $query->orderBy($filter['order'][0],$filter['order'][1]);
        }
        $retVal  = $query->pluck('id')->toArray();
        if (!$ignoreDelete){
            $this->deleteProductCalculate($retVal,$tableName);
        }
        return $retVal;
    }
    public function deleteProductCalculate($ids,$tableName){
        DB::table($tableName)->whereIn('id',$ids)->delete();
    }

    public function getProductBuildInfo($ids){
        $infoIds = DB::table('product_info')->whereIn('product_id',$ids)->pluck('product_id')->toArray();
        return array_diff($ids,$infoIds);
    }

    public function isHighRisk($productId){
        $retVal = false;
        $meta = DB::table('product_meta')->where('product_id',$productId)->where('key','is_high_risk')->where('value',1)->first();
        if (!empty($meta)){
            $retVal = true;
        }
        return $retVal;
    }

    public function createDeleteMerchantProduct($data){
        if (Schema::hasTable('merchant_product_delete')) {
            $chunkData = array_chunk($data,50);
            foreach ($chunkData as $items) {
                DB::table('merchant_product_delete')->insert($items);
            }
        }
    }

    public function clearProductCreateFail($productIds){
        $data = array_chunk($productIds,50);
        foreach ($data as $ids){
            DB::table('merchant_product')->whereIn('product_id',$ids)->delete();
        }
    }

    public function getProduct($filter){
        $query = DB::table('product');
        if (array_key_exists('created_at_from',$filter)){
            $query->where('created_at','>=',$filter['created_at_from']);
        }
        if (array_key_exists('product_id_from',$filter)){
            $query->where('id','>=',$filter['product_id_from']);
        }
        if (array_key_exists('max',$filter)){
            $query->orderBy('id','DESC');
        }
        $product = $query->first(['id','created_at']);
        return $product;
    }

    public function getProductEvent($filter){
        $query = DB::table('season_event_n_product');
        if (array_key_exists('id_from',$filter)){
            $query->where('id','>=',$filter['id_from']);
        }
        if (array_key_exists('id_to',$filter)){
            $query->where('id','<=',$filter['id_to']);
        }
        if (array_key_exists('max',$filter)){
            $query->orderBy('id','DESC');
            $query = $query->first(['id']);
        }
        return $query;
    }

    public function queryReport($filter = []){
        $query = DB::table('product')
            ->where('is_trademark',0)
            ->where('is_violation',0)
            ->where('status','active');
        if (array_key_exists('approve_advertising',$filter)){
            $query->where('approve_advertising',$filter['approve_advertising']);
        }
//        if (array_key_exists('score_product',$filter)){
            $query->join('score_product','score_product.id','=','product.id');
//            $query->join('product_info','product_info.product_id','=','product.id');
            $query->where('score_product.score','>=',$filter['score']);
//        }
        if (array_key_exists('product_id_from',$filter)){
            $query->where('product.id','>=',$filter['product_id_from']);
        }
        if (array_key_exists('product_id_to',$filter)){
            $query->where('product.id','<',$filter['product_id_to']);
        }
        if (array_key_exists('product_info',$filter)){
            $query->leftJoin('product_info','product_info.product_id','=','product.id');
            $query->whereNull('product_info.product_id');
        }
        if (array_key_exists('merchant_product',$filter)){
            $query->join('merchant_product','merchant_product.product_id','=','product.id');
            $query->where('merchant_product.is_delete',0);
        }
        return $query;
    }

    public function saveReport($data, $filter){
        if (Schema::hasTable('merchant_product_not_push')) {
           DB::table('merchant_product_not_push')
               ->where('product_first_id', '>=', $filter['product_id_from'])
               ->where('product_first_id', '<=', $filter['product_id_to'])
               ->delete();
            DB::table('merchant_product_not_push')->insert($data);
        }
    }

    public function getOptionByKey($key, $default = ''){
        $retVal = $default;
        $option = DB::table('option')->where('key', $key)->first(['value']);
        if (!empty($option->value)){
            $retVal = $option->value;
        }
        return $retVal;
    }
    public function saveOptionByKey($key, $value = ''){
        $isExists = DB::table('option')->where('key', $key)->exists();
        if ($isExists){
            $option = DB::table('option')->where('key', $key)->update(['value' => $value]);
        }else{
            $option = DB::table('option')->insert(['value' => $value, 'key' => $key]);
        }
    }

    public function getSellerInfo($product){
        $retVal = "";
        $seller = DB::table('product_n_user')
            ->join('users','users.id','=','product_n_user.user_id')
            ->whereNotNull('users.seller_token')
            ->where('users.seller_token', '!=', "")
            ->where('product_n_user.product_id', '=', $product->id)
            ->first(['email']);
        if (isset($seller->email)){
            $retVal = "Seller > $seller->email > ";
        }
        return $retVal;
    }

    public function getAdditionalImages($product){
        $retVal = [];
        if (Schema::hasTable('product_info_gallery')){
            $images = DB::table('product_info_gallery')->where('product_id',$product->id)->pluck('image_url')->toArray();;
            foreach ($images as $image){
                $retVal[] = $this->replaceDomain($image);
            }
        }
        if (empty($retVal)){
            $retVal[] = $this->replaceDomain($product->image_url);
        }
        $count = count($retVal);
//        $start = microtime(true);
        $retVal = ProductInfoGalleryService::appendMoreGallery($product->product_sku_id,$retVal,8-$count);
//        $processTime = microtime(true) - $start;
//        \Log::info("getAdditionalImages productId: $product->id | skuId: $product->sku_id | processTime: $processTime");
        return array_slice($retVal,0,10);
    }

    public function setAutoMinPrice(&$item){
        try {
            $automationDiscountConfig = $this->automationDiscountConfig;
            $defaultMargin = $automationDiscountConfig->default;
            if (is_object($automationDiscountConfig->categories )){
                $automationDiscountConfig->categories  = get_object_vars($automationDiscountConfig->categories );
            }
            foreach ($automationDiscountConfig->categories as $category => $categoryDiscount) {
                // Tạo pattern regex từ category
                $pattern = '/' . $category . '/i';
                // Kiểm tra xem product_type có khớp với regex hay không
                if (preg_match($pattern, $item['product_type'])) {
                    $defaultMargin = $categoryDiscount;
                    break;
                }
            }
            $isSeller = $this->isSeller($item['id']);
            if ($isSeller){
                $defaultMargin = $defaultMargin / 2;
            }
            if (!empty($this->automationProductIds)){
                if (in_array($item['id'],$this->automationProductIds)){
                    $item['cost_of_goods_sold'] = roundUp($item['price'] * 0.75,2);
                    $item['auto_pricing_min_price'] = roundUp($item['price'] * (1-$defaultMargin),2);
                }
            }else{
                $item['cost_of_goods_sold'] = roundUp($item['price'] * 0.75,2);
                $item['auto_pricing_min_price'] = roundUp($item['price'] * (1-$defaultMargin),2);
            }
        }catch (Exception $e){
        }
    }

    public function getLabel1($product){
        $retVal = 'unknow';
        $query = DB::table('season_event_n_product')
            ->from(DB::raw('sb_season_event_n_product FORCE INDEX (pid)'))
            ->join('season_event','season_event.id','=','season_event_n_product.season_event_id')
            ->where('season_event.status','active')->where('season_event.is_advertising',1)->where('season_event_n_product.product_id',$product->id)->select(['season_event.name','season_event_n_product.category_id']);
        if (Schema::hasColumn('season_event_n_product', 'categories')){
            $query->addSelect("categories");
        }
        $event = $query->first();
        if (isset($event->name)){
            preg_match('/\[(\d+)\]/', $event->name, $matches);
            if (isset($matches[1]) && isset($event->categories)) {
                $categoryId = $matches[1];
                $categoryPath = explode(",",$event->categories);
                if (in_array($categoryId,$categoryPath)){
                    $retVal = $event->name;
                }
            }else{
                $retVal = $event->name;
            }
        }
        if (!empty($this->labelRegex) && isset($this->labelRegex->pattern)){
            if (preg_match($this->labelRegex->pattern, $product->title_replacement)){
                $retVal = !empty($this->labelRegex->label)?$this->labelRegex->label:$retVal;
            }
        }
        return $retVal;
    }

    public function getLabel0($product){
        $retVal = '';
        $isFromMeear = DB::table('original_product')
            ->where('product_id',$product->id)
            ->where('source','meear-us')
            ->exists();
        if ($isFromMeear && $this->optionLabel == 1){
            $retVal = 'meear';
        }else{
            if (Schema::hasTable('predict_product_has_sale')) {
                $isPredict = DB::table('predict_product_has_sale')
                    ->join('product_n_design', 'product_n_design.product_id', '=', 'predict_product_has_sale.product_id')
                    ->where('predict_product_has_sale.product_id', $product->id)->exists();
                if ($isPredict) {
                    $retVal = 'sale_prediction';
                }
            }
            if (Schema::hasTable('product_template_design_code') && $product->id > 1600000000) {
                if (!$this->isSeller($product->id)) {
                    $isGenerate = getTemplateDesignCode($product->id);
                    if ($isGenerate) {
                        $retVal = 'generated';
                    }
                } else {
                    $isSeller = true;
                }
            }
            $isLivePreview = DB::table('product_custom')
                ->where('product_id',$product->id)
                ->where('type','customily')
                ->exists();
            if ($isLivePreview && $this->optionLabel == 1){
                $retVal = 'live_preview';
            }
            if (Schema::hasTable('product_type')) {
                $productType = DB::table('product_type')
                    ->where('product_id', $product->id)->first(['who_made_it']);
                //Dữ liệu trong databse của Quang viết sai chính tả :(
                if (isset($productType->who_made_it) && $productType->who_made_it == 'my-sefl') {
                    $retVal = 'supplier';
                }
            }
            if (Schema::hasTable('product_custom')) {
                if (!isset($isSeller)) {
                    $isSeller = $this->isSeller($product->id);
                }
                if ($isSeller) {
                    $isCutomly = DB::table('product_custom')
                        ->where('product_id', $product->id)->exists();
                    if ($isCutomly) {
                        $retVal = 'customly';
                    }
                }
            }
            $productCrawl = $this->getProductCrawl($product);
            if (!empty($productCrawl) && isset($productCrawl->site) && isset($this->customLabelSources[$productCrawl->site])) {
                if (in_array($productCrawl->site,['etsy','redbubble'])) {
                    if (isset($product->actor_id) && $product->actor_id == 160 && $product->id >= 2021542553) {
                        $retVal = $this->customLabelSources[$productCrawl->site];
                    }
                }else {
                    $retVal = $this->customLabelSources[$productCrawl->site];
                }
            }
            if (isset($this->customLabelSources['create_your_own']) && Schema::hasTable('pod_create_your_own_template')) {
                $isCreateYourOwn = DB::table('pod_create_your_own_template')
                    ->where('product_id',$product->id)
                    ->exists();
                if ($isCreateYourOwn) {
                    $retVal = 'create_your_own';
                }
            }
        }
        if(isset($this->customLabelSources['trendLabel'])){
            $trendLabel = $this->checkProductTrend3Months($product->id);
            if (empty($trendLabel)){
                $trendLabel = $this->checkProductTrend7Days($product->id);
            }
        }
        if (empty($trendLabel)){
            if (isset($this->productTotalSale[$product->id])){
                $mediumSale = isset($this->customLabelSources['medium_sale'])?$this->customLabelSources['medium_sale']:'';
                $highSale = isset($this->customLabelSources['high_sale'])?$this->customLabelSources['high_sale']:'';
                $retVal = $this->productTotalSale[$product->id] <= 10 ? $mediumSale : $highSale;
            }
        }else{
            $retVal = $trendLabel;
        }
        if (isset($product->barcode) && in_array(strtolower($product->barcode),['blur_new_gen','ordered_low_traffic'])){
            $retVal = $product->barcode;
        }
        return $retVal;
    }

    public function getProductTotalSale($createdAtFrom = null, $createdAtTo = null){
        if (!$createdAtFrom || !$createdAtTo) {
            $yesterday = Carbon::yesterday(); // ngày hôm qua (00:00:00)
            $createdAtFrom = $yesterday->copy()->startOfDay()->format('Y-m-d H:i:s'); // hôm qua 00:00:00
            $createdAtTo   = $yesterday->copy()->endOfDay()->format('Y-m-d H:i:s');   // hôm qua 23:59:59
        }
        $retVal = [];
        $products = DB::table('order')
            ->join('order_item', 'order_item.order_id', '=', 'order.id')
            ->select(DB::raw('product_id, sum(quantity) as total_sale'))
            ->where('order.created_at', '>=',$createdAtFrom)
            ->where('order.created_at', '<=', $createdAtTo)
            ->where('order.payment_status', 'PAID')
            ->groupBy('product_id')
            ->having('total_sale', '>=', 5)
            ->get()
            ->pluck('total_sale', 'product_id');
        foreach ($products as $productId => $sale) {
            $retVal[$productId] = $sale;
        }
        return $retVal;
    }

    public function getLabelNoDedicatedCampaign($product, $input = []){
        $retVal = '';
        if (Schema::hasTable('ads_exclude_product')) {
            $isExclude = DB::table('ads_exclude_product')->where('id', $product->id)->exists();
            $label1 = $input['label1'];
            if (!$isExclude && (empty($label1) || $label1 == 'unknow')) {
                $retVal = 'no_dedicated_campaign';
            }
        }
        return $retVal;
    }

    public function getLabel4($product){
        $retVal = '';
        return $retVal;
    }


    public static function getCountryByCode($countryCode) {
        $key = $countryCode;
        if (!array_key_exists($key, self::$countryCache)) {
            self::$countryCache[$key] = Country::getByCode($countryCode);
        }
        return self::$countryCache[$key];

    }

    protected static function getProductCrawl($product) {
        $key = $product->id;
        $productCrawl = null;
        if (Schema::hasTable('product_crawl_code')) {
            $productCrawl = DB::table('product_crawl_code')
                ->where('product_id', $product->id)->first(['site']);
        }
        if (!array_key_exists($key, self::$productCrawlCache)) {
            self::$productCrawlCache[$key] = $productCrawl;
        }
        return self::$productCrawlCache[$key];

    }

    private function isSeller($productId){
        return DB::table('product_n_user')
            ->join('users','users.id','=','product_n_user.user_id')
            ->whereNotNull('users.seller_token')
            ->where('users.seller_token', '!=', "")
            ->where('product_n_user.product_id', '=', $productId)->exists();
    }
    public function getProductMissingProductInfo($filter)
    {
        $productQuery = DB::table('product');
        $productQuery->leftJoin('product_info', 'product.id', 'product_info.product_id');
        $productQuery->where('product.status', 'active');
        $productQuery->where('product.is_trademark', 0);
        $productQuery->where('product.is_violation', 0);
        $productQuery->where('product.approve_advertising', 1);
        $productQuery->whereNull('product.deleted_at');
        $productQuery->whereNull('product_info.product_id');
        if (array_key_exists('product_id_from', $filter)) {
            $productQuery->where('product.id', '>=', $filter['product_id_from']);
        }
        if (array_key_exists('product_id_to', $filter)) {
            $productQuery->where('product.id', '<=', $filter['product_id_to']);
        }
        if (array_key_exists('ids', $filter)) {
            $productQuery->whereIn('product.id', $filter['ids']);
        }
        if (array_key_exists('columns', $filter)) {
            $productQuery->select($filter['columns']);
        } else {
            $productQuery->select(['product.id']);
        }
        $productQuery->from(DB::raw("`sb_product` FORCE INDEX(`PRIMARY`)"));
        return $productQuery->get()->toArray();
    }

    public function insertProductMissingInfo($products, $tableName = 'merchant_product_info_missing')
    {
        if (!empty($products)) {
            $data = array_chunk($products, 10000);
            foreach ($data as $items) {
                foreach ($items as $product) {
                    $isExists = DB::table($tableName)
                        ->where('id', $product->id)->exists();
                    if (!$isExists) {
                        DB::table($tableName)->insert([['id' => $product->id, 'created_at' => date('Y-m-d H:i:s')]]);
                    } else {
                        DB::table($tableName)
                            ->where('id', $product->id)->update(['created_at' => date('Y-m-d H:i:s')]);
                    }
                }
            }
        }
    }

    public function deleteProductMissingInfo()
    {
        $retVal = 0;
        DB::table('merchant_product_info_missing')
            ->whereExists(function ($q) {
                $q->select(DB::raw(1))
                    ->from('product_info')
                    ->whereColumn('product_info.product_id', 'merchant_product_info_missing.id');
            })
            ->orderBy('id')
            ->chunkById(10000, function ($rows) use (&$retVal) {
                $ids = $rows->pluck('id');
                if (!empty($ids)) {
                    $retVal += count($ids);
                    DB::table('merchant_product_info_missing')
                        ->whereIn('id', $ids)
                        ->delete();
                }
            });

        return $retVal;
    }
    public function checkProductTrend7Days($productId)
    {

        // End của tuần hiện tại là đầu ngày hôm nay
        $endCurrent   = Carbon::now()->startOfDay();
        $startCurrent = (clone $endCurrent)->subDays(7);

        // Tuần trước liền kề
        $startPrev = (clone $endCurrent)->subDays(14);
        $endPrev   = (clone $endCurrent)->subDays(7);

        // Chuẩn hoá sang string để nhúng trong DB::raw (Laravel 5.6 chưa hỗ trợ binding trong biểu thức CASE dễ dàng)
        $startCurrentStr = $startCurrent->toDateTimeString(); // YYYY-MM-DD HH:MM:SS
        $endCurrentStr   = $endCurrent->toDateTimeString();
        $startPrevStr    = $startPrev->toDateTimeString();
        $endPrevStr      = $endPrev->toDateTimeString();

        $row = DB::table('order')
            ->join('order_item', 'order_item.order_id', '=', 'order.id')
            ->select(
                'order_item.product_id',
                DB::raw("
                    SUM(
                        CASE
                          WHEN sb_order.payment_status = 'PAID'
                           AND sb_order.created_at >= '{$startCurrentStr}'
                           AND sb_order.created_at <  '{$endCurrentStr}'
                        THEN sb_order_item.quantity ELSE 0 END
                    ) AS qty_week
                "),
                DB::raw("
                    SUM(
                        CASE
                          WHEN sb_order.payment_status = 'PAID'
                           AND sb_order.created_at >= '{$startPrevStr}'
                           AND sb_order.created_at <  '{$endPrevStr}'
                        THEN sb_order_item.quantity ELSE 0 END
                    ) AS qty_prev_week
                ")
            )
            // Giới hạn quét dữ liệu từ đầu tuần trước để tối ưu
            ->where('order.created_at', '>=', $startPrevStr)
            ->where('order_item.product_id', $productId)
            ->groupBy('order_item.product_id')
            ->having('qty_week', '>=', 1)
            ->having('qty_prev_week', '=', 0)
            ->first();

        return $row ? 'trend7days' : null;
    }

    /**
     * Kiểm tra sản phẩm có trend trong 3 tháng gần nhất (3 tháng đầy đủ trước tháng hiện tại)
     * - Tháng -3 (cũ nhất) >= 10 orders (PAID)
     * - Tháng -2           >= 10 orders (PAID)
     * - Tháng -1 (gần nhất) > 20 orders (PAID)
     *
     * @param  int|string  $productId
     * @return string|null
     */
    public function checkProductTrend3Months($productId)
    {
        $now = Carbon::now();

        // Xác định 3 tháng dương lịch đầy đủ trước tháng hiện tại
        // Ví dụ hôm nay 2025-09-12 -> lấy Jun, Jul, Aug 2025
        $startMonthLatest = $now->copy()->startOfMonth()->subMonth();   // đầu tháng gần nhất (tháng -1)
        $endMonthLatest   = $now->copy()->startOfMonth();               // đầu tháng hiện tại (exclusive)
        $startMonthMid    = $startMonthLatest->copy()->subMonth();      // đầu tháng -2
        $endMonthMid      = $startMonthLatest->copy();                  // đầu tháng -1
        $startMonthOld    = $startMonthMid->copy()->subMonth();         // đầu tháng -3
        $endMonthOld      = $startMonthMid->copy();                     // đầu tháng -2

        // Chuẩn hoá về chuỗi để gắn vào DB::raw
        $sOld  = $startMonthOld->toDateTimeString();
        $eOld  = $endMonthOld->toDateTimeString();
        $sMid  = $startMonthMid->toDateTimeString();
        $eMid  = $endMonthMid->toDateTimeString();
        $sLat  = $startMonthLatest->toDateTimeString();
        $eLat  = $endMonthLatest->toDateTimeString();

        // Đếm số đơn (distinct order.id) theo từng tháng
        $row = DB::table('order')
            ->join('order_item', 'order_item.order_id', '=', 'order.id')
            ->select(
                'order_item.product_id',
                // Tháng -3 (cũ nhất)
                DB::raw("
                    COUNT(DISTINCT CASE 
                        WHEN sb_order.payment_status = 'PAID'
                         AND sb_order.created_at >= '{$sOld}'
                         AND sb_order.created_at <  '{$eOld}'
                    THEN sb_order.id END) AS orders_m1
                "),
                // Tháng -2
                DB::raw("
                    COUNT(DISTINCT CASE 
                        WHEN sb_order.payment_status = 'PAID'
                         AND sb_order.created_at >= '{$sMid}'
                         AND sb_order.created_at <  '{$eMid}'
                    THEN sb_order.id END) AS orders_m2
                "),
                // Tháng -1 (gần nhất)
                DB::raw("
                    COUNT(DISTINCT CASE 
                        WHEN sb_order.payment_status = 'PAID'
                         AND sb_order.created_at >= '{$sLat}'
                         AND sb_order.created_at <  '{$eLat}'
                    THEN sb_order.id END) AS orders_m3
                ")
            )
            // Giới hạn khung thời gian cần quét (từ đầu tháng -3)
            ->where('order.created_at', '>=', $sOld)
            ->where('order_item.product_id', $productId)
            ->groupBy('order_item.product_id')
            ->having('orders_m1', '>=', 10)
            ->having('orders_m2', '>=', 10)
            ->having('orders_m3', '>',  20)
            ->first();

        return $row ? 'trend3months' : null;
    }

    public function addParamsToUrl($url, $params = []) {
        // Phân tích URL thành các phần
        $parsedUrl = parse_url($url);

        // Lấy query hiện có (nếu có)
        $query = [];
        if (isset($parsedUrl['query'])) {
            parse_str($parsedUrl['query'], $query);
        }

        // Gộp query cũ và mới (param mới ghi đè nếu trùng key)
        $query = array_merge($query, $params);

        // Tạo lại query string
        $newQuery = http_build_query($query);

        // Dựng lại URL
        $newUrl =
            (isset($parsedUrl['scheme']) ? "{$parsedUrl['scheme']}://" : '') .
            (isset($parsedUrl['host']) ? $parsedUrl['host'] : '') .
            (isset($parsedUrl['path']) ? $parsedUrl['path'] : '') .
            (!empty($newQuery) ? "?$newQuery" : '') .
            (isset($parsedUrl['fragment']) ? "#{$parsedUrl['fragment']}" : '');

        return $newUrl;
    }

    public function getProductExpired($filter){
        $productQuery = DB::table('merchant_product');
        if(array_key_exists('updated_at_to', $filter)){
            $productQuery->where('merchant_product.updated_at','<=', $filter['updated_at_to']);
        }
        if(array_key_exists('updated_at_from', $filter)){
            $productQuery->where('merchant_product.updated_at','>=', $filter['updated_at_from']);
        }
        if(array_key_exists('product_id_from', $filter)){
            $productQuery->where('merchant_product.product_id','>=', $filter['product_id_from']);
        }
        if(array_key_exists('product_id_to', $filter)){
            $productQuery->where('merchant_product.product_id','<=', $filter['product_id_to']);
        }
        if(array_key_exists('ids', $filter)){
            if (!is_array($filter['ids'])){
                $filter['ids'] = explode(",",$filter['ids']);
            }
            $productQuery->whereIn('merchant_product.product_id', $filter['ids']);
        }

        return $productQuery->get(['merchant_product.product_id','merchant_product.sku']);
    }

    public function buildProductExpired($products, $input = []){
        $retVal = [];
        $language = $input['language'];
        $country = $input['country'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        foreach ($products as $product){
            $item = [
                'id' => $product->product_id,
                'product_code' => $product->sku,
                'language' => $language,
                'country' => $country,
                'merchantId' => $this->getMerchantId($product->product_id,$input)
            ];
            $retVal[$item['id']] = $item;
        }
        return $retVal;
    }

    public function getProductFromCrawl(){
        $maxId = DB::table('product_crawl_code')->max('id');
        $fromId = $maxId - 10000;
        $productCrawlIds = DB::table('product_crawl_code')->where('id','>=', $fromId)->pluck('product_id')->toArray();
        $userIds = DB::table('users')->where('role','STAFF')->where('status','active')->pluck('id')->toArray();
        $productIds = DB::table('product')->where('created_at','>=', date('Y-m-d 00:00:00',strtotime('-1 days')))
            ->whereIn('actor_id',$userIds)
            ->where('status','active')
            ->where('approve_advertising',1)
            ->where('is_violation',0)
            ->where('is_trademark',0)
            ->pluck('id')->toArray();
        $retVal = array_unique(array_merge($productCrawlIds,$productIds));
        return $retVal;

    }

}
