<?php 
namespace Modules\Ads\Controllers\Service;

class MerchantService
{
    protected $merchantProductService;
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];

    public function __construct(MerchantProductService $merchantProductService)
    {
        $this->merchantProductService = $merchantProductService;
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $prefixUrl = $input['prefixUrl'];
        $currency = env('CURRENCY_UNIT','USD');
        $input['currency'] = $currency;
        $country = $input['country'];
        $title = ucwords(strtolower($product->title_replacement));
        $shippingFees = $this->merchantProductService->getShipping($product,$input);
        $this->merchantProductService->buildSpecificInfo($product);
        $item = [
                $product->sku_code,
                $title,
                $title,
                (URL('/') . $prefixUrl . "/" . $product->sku_slug),
                $this->merchantProductService->buildImage($product),
                'in stock',
                $product->price . ' ' . $currency,
                '',
                $country . $product->id,
                $this->merchantProductService->getProductType($product),
                $product->sku_category_merchant_id,
                $product->sku_brand,
                'new'

        ];
        $product = get_object_vars($product);
        $shoppingFeedConfig = $this->shoppingFeedConfig;
        $age = isset($shoppingFeedConfig['columns']['g:age_group']) ? call_user_func_array($shoppingFeedConfig['columns']['g:age_group'], [&$product]) : ' ';
        $size = isset($shoppingFeedConfig['columns']['g:size']) ? call_user_func_array($shoppingFeedConfig['columns']['g:size'], [&$product]) : ' ';
        $color = isset($shoppingFeedConfig['columns']['g:color']) ? call_user_func_array($shoppingFeedConfig['columns']['g:color'], [&$product]) : ' ';
        $gender = isset($shoppingFeedConfig['columns']['g:gender']) ? call_user_func_array($shoppingFeedConfig['columns']['g:gender'], [&$product]) : '';
        $item[] = $age;
        $item[] = $size;
        $item[] = $color;
        $item[] = $gender;
        foreach($shippingFees as $shippingItem){
            $item[] = $shippingItem['country'] . '::' . $shippingItem['price'] . ' ' . $currency . ':' . $shippingItem['shippingTime']['min_handling_time'] . ':' . $shippingItem['shippingTime']['max_handling_time'] . ':' . $shippingItem['shippingTime']['min_transit_time'] . ':' . $shippingItem['shippingTime']['max_transit_time'];
        }
        $this->items[$country . $product['id']] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $fileName = $input['fileName'];
        $tempFile = 'temp_' . $fileName;
        $localeFolder = $this->publicPath .'feeds/' . $locale . '/merchant';
        if (!file_exists($localeFolder)) {
            mkdir($localeFolder, 0777, true);
        }
        $filePath = $localeFolder . '/' . $fileName;
        $tempPath = $localeFolder . '/' . $tempFile;
        if (array_key_exists('truncate',$input)){
            file_put_contents($tempPath,"");
        }
        if(!array_key_exists('append',$input)){
            try{
                $fileHandle = fopen($filePath, "r");
            }catch (\Exception $ex){
                $fileHandle = FALSE;
            }
            if ($fileHandle !== FALSE){
                $limit = 1000;
                //Set up a variable to hold our current position in the file
                $offset = 0;
                while(!feof($fileHandle))
                {
                    $stream = fopen('php://temp', 'w');
                    //Go to where we were when we ended the last batch
                    fseek($fileHandle, $offset);
                    $i = 0;
                    while (($currRow = fgetcsv($fileHandle, null, "\t")) !== FALSE)
                    {
                        $i++;

                        //Do something with the current row
                        if (isset($this->items[$currRow[8]])) {
                            $currRow = $this->items[$currRow[8]];
                            unset($this->items[$currRow[8]]);
                        }
                        fputcsv($stream, $currRow, "\t");

                        //If we hit our limit or are at the end of the file
                        if($i >= $limit)
                        {
                            //Update our current position in the file
                            $offset = ftell($fileHandle);

                            //Break out of the row processing loop
                            break;
                        }
                    }
                    rewind($stream);
                    $content = stream_get_contents($stream);
                    fclose($stream);
                    file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
                }
                fclose($fileHandle);

            }
        }

        if (!empty($this->items)) {
            $stream = fopen('php://temp', 'w');
            foreach ($this->items as $line) {
                fputcsv($stream, $line, "\t");
            }
            rewind($stream);
            $content = stream_get_contents($stream);
            fclose($stream);
            file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
        }
        if (array_key_exists('rename',$input)){
            rename($tempPath, $filePath);
        }
    }


    private function resetItems() {
        $this->items = [];
    }
    private function addHeader($input){
        $head = [
            'id',
            'title',
            'description',
            'link',
            'image_link',
            'availability',
            'price',
            'gtin',
            'mpn',
            'product_type',
            'google_product_category',
            'brand',
            'condition',
            'age_group',
            'size',
            'color',
            'gender'
        ];
        $countryCodes = $this->merchantProductService->getShippingCoutries($input['country']);
        foreach ($countryCodes as $countryCode){
            $head[] = 'shipping(country:postal_code:price:min_handling_time:max_handling_time:min_transit_time:max_transit_time)';
        }
        $this->items['mpn'] = $head;
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        if (array_key_exists('truncate',$input)){
            $this->addHeader($input);
        }
        $count = 0;
        foreach ($products as $product) {
            $isSkip = $this->merchantProductService->isSkip($product);
            if ($isSkip){
                continue;
            }
            if (empty($product->sku_category_merchant_id)){
                continue;
            }
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }
}