<?php 
namespace Modules\Ads\Controllers\Service;

use App\Modules\Ads\Controllers\Service\BaseService;
use Illuminate\Support\Facades\DB;

class PageFeedService extends BaseService
{
    protected $publicPath = null;
    protected $items = [];
    protected $shoppingFeedConfig = [];

    public function __construct()
    {
        $this->publicPath = base_path() . '/public/';
        $this->shoppingFeedConfig = \Config::get('ads::clara-ads-shopping-feed');
    }

    /***
     * @param $product
     * @param $input
     */
    public function add($product, $input)
    {
        $country = $input['country'];
        $item = [
            URL('/'). $input['prefixUrl'] . '/' . $product->slug . '-p' . $product->id,
            $country . $product->id

        ];
        $key = $country . $product->id;
        $this->items[$key] = $item;
    }


    /***
     * @param $input
     * @param $locale
     */
    public function store($input, $locale = 'us')
    {
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/pagefeed';
        $items = $this->items;
        $existsProducts = ['Custom label' => 1];
        $this->processFile($input,function(&$currRow,&$stream) use (&$existsProducts,&$retVal, &$items){
            if (isset($items[$currRow[1]])) {
                $currRow = $items[$currRow[1]];
                unset($items[$currRow[1]]);
            }
            if (!isset($existsProducts[$currRow[1]])){
                fputcsv($stream, $currRow);
                $existsProducts[$currRow[1]] = 1;
            }
        }, function($tempPath) use (&$items){
            if (!empty($items)) {
                $stream = fopen('php://temp', 'w');
                foreach ($items as $line) {
                    fputcsv($stream, $line);
                }
                rewind($stream);
                $content = stream_get_contents($stream);
                fclose($stream);
                file_put_contents($tempPath, $content,FILE_APPEND | LOCK_EX);
            }
        },$this->getHeader());
    }


    private function resetItems() {
        $this->items = [];
    }
    private function getHeader(){
        return [
            'Page URL',
            'Custom label'
        ];
    }

    public function buildProducts($products,$input = []){
        $this->resetItems();
        $count = 0;
        foreach ($products as $product) {
            $this->add($product,$input);
            $count ++;
        }
        return $count;
    }
    public function remove($input, $locale = 'us'){
        $removeProducts = $input['removeProducts'];
        if (empty($locale)){
            $locale = 'us';
        }
        $input['localeFolder'] = $this->publicPath .'feeds/' . $locale . '/pagefeed';
        $this->processFile($input,function($currRow,$stream) use (&$removeProducts){
            if (!isset($removeProducts[$currRow[1]])) {
                fputcsv($stream, $currRow);
                $removeProducts[$currRow[1]] = 1;
            }
        });
    }
}