<?php

namespace Modules\Ads\Controllers\Service;

use Illuminate\Http\Request;
use Modules\Ads\Services\CampaignService;
use PHPExcel;
use PHPExcel_IOFactory;
use Module;
use Cache;

class ProductToAdvertiseBase
{
    protected $campaignService = null;
    protected $campaigns = [];
    protected $pageSize = 20;

    public function __construct(
                                CampaignService $campaignService
                                )
    {
        $this->campaignService = $campaignService;
        $this->campaigns = $this->initCampaignLists();
    }

    protected function initCampaignLists() {
        $retVal = [];
        if (Cache::has('campaignLists')){
            $value = Cache::get('campaignLists');
            $retVal = json_decode($value, true);
        } else {
            $campaigns = $this->campaignService->find(['columns' => 'campaign_id,campaign_name,campaign_type,account,status'])->toArray();
            $retVal = $campaigns;
            Cache::add('campaignLists', json_encode($campaigns), 1440);
        }
        return $retVal;
    }

    public function clearResult($items, $filter) {
        $retVal = [];
        foreach($items as $item) {
            $newArrs = [];
            foreach($item['ads'] as $ad) {
                if (isset($filter['account_key']) && $ad['account_key'] == $filter['account_key']) {
                    $newArrs[] = $ad;
                }
            }
            if (!empty($newArrs)) {
                foreach($newArrs as $key => $ad) {
                    if (isset($filter['campaign_type']) && $ad['campaign_type'] != $filter['campaign_type']) {
                        unset($newArrs[$key]);
                    }
                }
            } else {
                foreach($item['ads'] as $ad) {
                    if (isset($filter['campaign_type']) && $ad['campaign_type'] == $filter['campaign_type']) {
                        $newArrs[] = $ad;
                    }
                }
            }
            $newArrs = array_values($newArrs);
            foreach($newArrs as $key => $ad) {
                if (isset($filter['ad_type']) && $ad['ad_type'] != $filter['ad_type']) {
                    unset($newArrs[$key]);
                }
            }
            $newArrs = array_values($newArrs);
            if (!empty($newArrs)) {
                $item['ads'] = $newArrs;
            }
            $retVal[] = $item;
        }
        return $retVal;
    }

    public function buildFilters($request) {
        $params = ['keyword', 'campaign_id', 'status', 'not_advertising', 'not_click', 'feed_status', 
                    'account_key', 'campaign_type', 'ad_type', 'category_id', 'stock', 'is_export'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->input($param);
            }
        }
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;

        $retVal['fromDate'] = $fromDate->setTime(0, 0, 0);
        $retVal['toDate'] = $toDate->setTime(23,59,59);
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('_', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        }
        $isExport = (isset($retVal['is_export']) &&  $retVal['is_export']) ? $retVal['is_export'] : null;
        if ($isExport != null && $isExport) {
            $retVal['pageSize'] = 400000;
        } else {
            $retVal['pageSize'] = $this->pageSize;
        }
        $retVal['pageId'] = $request->has('page_id') ? $request->input('page_id') : 0;
        return $retVal;
    }

    public function exportToExcel($items) {
        /** Build excel file to export */
        $objPHPExcel = new PHPExcel();
        /** Setup properties for file excel */
        $objPHPExcel->getProperties()
                ->setCreator("Temporaris")
                ->setLastModifiedBy("Temporaris")
                ->setTitle("Template Relevé des heures intérimaires")
                ->setSubject("Template excel")
                ->setDescription("Template excel permettant la création d'un ou plusieurs relevés d'heures")
                ->setKeywords("Template excel");

        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->getActiveSheet()->SetCellValue('A1', "STT");
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', "Mã sản phẩm");
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', "Tên sản phẩm");
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', "Link");
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', "Tồn kho");
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', "Trạng thái");
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', "Trạng thái feed");
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', "Click");
        $objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setSize(12);

        $i = 1;
        $j = 0;
        foreach ($items as $item) {
            $i++;
            $j++;
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $j);

            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $item['sku']);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $item['title']);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $item['link']);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $item['inventory']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $item['status']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, 'Chưa lên feed');
            if ($item['is_push_merchant_feed']) {
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, 'Đã lên feed');
            }
            $clicks = [];
            if (isset($item['click_campaign_types']) && is_array($item['click_campaign_types'])) {
                foreach($item['click_campaign_types'] as $campaign) {
                    $clicks[] = $campaign->campaign_type . ' : ' . $campaign->click;
                }
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, implode(', ', $clicks));
        }

        $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="Bao_cao_SP_can_qc' . date("Y-m-d") . time() . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
    }
}
