<?php

namespace Modules\Ads\Controllers\Service;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\ProductToAdvertiseBase;
use Modules\Ads\Services\ProductToAdvertisingService;
use Modules\Ads\Services\ProductInfoService;
use Modules\Ads\Services\ProductNCategoryService;
use Modules\Ads\Services\ProductService;
use Modules\Ads\Services\ProductApproveAdvertisingService;
use Modules\Ads\Services\ClickService;

class ProductToAdvertiseById extends ProductToAdvertiseBase
{
    protected $productToAdvertisingService = null;
    protected $productInfoService = null;
    protected $productNCategoryService = null;
    protected $productService = null;
    protected $productApproveAdvertising = null;
    protected $clickService = null;
    protected $pageSize = 20;

    public function __construct(
        ProductToAdvertisingService $productToAdvertisingService,
                                ProductInfoService $productInfoService,
                                ProductNCategoryService $productNCategoryService,
                                ProductService $productService,
                                ProductApproveAdvertisingService $productApproveAdvertisingService,
                                ClickService $clickService
    )
    {
        $this->productToAdvertisingService = $productToAdvertisingService;
        $this->productInfoService = $productInfoService;
        $this->productNCategoryService = $productNCategoryService;
        $this->productService = $productService;
        $this->productApproveAdvertisingService = $productApproveAdvertisingService;
        $this->clickService = $clickService;
    }

    public function buildCampaignClick($request) {
        $input = $request->all();
        $currentDate = new \DateTime();
        $fromDate = array_key_exists('dateFrom', $input) ? \DateTime::createFromFormat('d/m/Y', $input['dateFrom']) : $currentDate;
        $toDate = array_key_exists('dateTo', $input) ? \DateTime::createFromFormat('d/m/Y', $input['dateTo']) : $currentDate;
        $filters = array();
        $filters['fromDate'] = $fromDate->setTime(0, 0, 0);
        $filters['toDate'] = $toDate->setTime(23,59,59);
        $filters['codes'] = array_key_exists('codes', $input) ? $input['codes'] : [];
        $clickCampaigns = $this->clickService->getClickProductToAdvertise($filters, 'campaign_id');
        $campaignByIds = [];
        foreach($this->campaigns as $item) {
            $campaignByIds[$item['campaign_id']] = $item;
        }
        foreach($clickCampaigns as $item) {
            if (isset($campaignByIds[$item->campaign_id])) {
                $item->campaign = $campaignByIds[$item->campaign_id];
            }
        }
        $response = [
            'status' => 'successful',
            'result' => $clickCampaigns
        ];
        return $response;
    }

    public function getData($filter, $request) {
        if (isset($filter['not_advertising']) && $filter['not_advertising']) {
            $filter['status'] = 'pending';
        }
        if (isset($filter['category_id'])) {
            $filter['productIds'] = $this->buildProductCodeByCategory($filter);
        }
        $pageId = $filter['pageId'];
        $pageSize = $filter['pageSize'];
        $clickByCodes = [];
        if (isset($filter['sort']) && !$filter['not_click'] && ($filter['sort'] == 'click_asc' || $filter['sort'] == 'click_desc')) {
            unset($filter['pageId']);
            unset($filter['pageSize']);
            $orderBy = $filter['orders'];
            unset($filter['orders']);
            $filter = $this->buildFilterByFeedStatus($filter);
            $productIds = $this->getResult($filter, 'lists');
            $filter['productIds'] = $productIds;
            $filter['pageSize'] = $pageSize;
            $filter['pageId'] = $pageId;
            $filter['orders'] = $orderBy;
            $result = $this->clickService->getClickProductToAdvertise($filter);
            $productIds = [];
            $clickByProductIds = [];
            foreach($result as $item) {
                $productIds[] = $item->product_id;
                $clickByProductIds[$item->product_id] = $item;
            }
            $filterProductAdvertising = [
                'productIds' => $productIds
            ];
            $items = $this->getResult($filterProductAdvertising);
            $items = $items->toArray();
            $newItems = [];
            foreach($items as $item) {
                $newItem = $item;
                $newItem['click'] = 0;
                if (isset($clickByProductIds[$newItem['product_id']])) {
                    $newItem['click'] = $clickByProductIds[$item['product_id']]->click;
                }
                $newItems[] = (object) $newItem;
            }
            usort($newItems, function($a, $b) {
                return $a->click < $b->click;
            });
            $items = [];
            foreach($newItems as $item) {
                $items[] = (array) $item;
            }
            unset($filter['pageId']);
            unset($filter['pageSize']);
            unset($filter['orders']);
            $pageId = $request->input('page_id', 0);
            $filter['metric'] = "count";
            $adwordsItemCount = $this->clickService->getClickProductToAdvertise($filter);
            unset($filter['metric']);
        } else {
            if ($filter['not_click']) {
                if (!isset($filter['productIds'])) {
                    $itemNotClicks = $this->productToAdvertisingService->find(['columns' => 'product_id']);
                    $itemNotClickProductIds = [];
                    foreach ($itemNotClicks as $item) {
                        $itemNotClickProductIds[] = $item->product_id;
                    }
                    $filter['productIds'] = $itemNotClickProductIds;
                }
                $clickFilter = $filter;
                unset($clickFilter['pageId']);
                unset($clickFilter['pageSize']);
                unset($clickFilter['orders']);
                $resultClicks = $this->clickService->getClickProductToAdvertise($clickFilter);
                $productIdClicked = [];
                foreach($resultClicks as $item) {
                    $productIdClicked[] = $item->product_id;
                }
                $newProductIds = [];
                foreach ($filter['productIds'] as $item) {
                    if (!in_array($item, $productIdClicked)) {
                        $newProductIds[] = $item;
                    }
                }
                if (!empty($newProductIds)) {
                    $filter['productIds'] = $newProductIds;
                } else {
                    $filter['productIds'] = ['-1'];
                }
            }
            if (isset($filter['not_click']) && $filter['not_click'] && isset($filter['campaign_id'])) {
                unset($filter['campaign_id']);
            }
            $filter = $this->buildFilterByFeedStatus($filter);
            unset($filter['orders']);
            $adwordsItem = $this->getResult($filter);
            $items = $adwordsItem->toArray();
            unset($filter['pageId']);
            unset($filter['pageSize']);
            $pageId = $request->input('pageId', 0);
            $filter['metric'] = "count";
            $adwordsItemCount = $this->getResult($filter);
            $productIds = [-1];
            foreach($items as $item) {
                $productIds[] = $item['product_id'];
            }
            unset($filter['metric']);
            $filter['productIds'] = $productIds;
            $resultClicks = $this->clickService->getClickProductToAdvertise($filter);
            $clickByProductIds = [];
            foreach($resultClicks as $item) {
                $clickByProductIds[$item->product_id] = $item->click;
            }
            $newResults = [];
            foreach($items as $item) {
                $newItem = $item;
                $newItem['click'] = 0;
                if (isset($clickByProductIds[$item['product_id']])) {
                    $newItem['click'] = $clickByProductIds[$item['product_id']];
                }
                $newResults[] = $newItem;
            }
            $items = $newResults;
        }
        $pagesCount = $this->clickService->recordsCountToPagesCount($adwordsItemCount, $this->pageSize);
        $items = $this->clearResult($items, $filter);
        $productIds = [];
        foreach($items as $item) {
            $productIds[] = $item['product_id'];
        }
        $filter['productIds'] = $productIds;
        $statusFeed = $this->buildStatusMerchantFeed($productIds);
        $newResult = [];
        foreach($items as $item) {
            $newItem = $item;
            $newItem['is_push_merchant_feed'] = 0;
            if (isset($statusFeed[$item['product_id']])) {
                $newItem['is_push_merchant_feed'] = $statusFeed[$item['product_id']];
            }
            $newResult[] = $newItem;
        }
        $items = $newResult;
        $clickCampaigns = $this->clickService->getClickProductToAdvertise($filter, 'campaign_type');
        $clickCampaignByIds = [];
        foreach($clickCampaigns as $item) {
            if (!array_key_exists($item->product_id, $clickCampaignByIds)) {
                $clickCampaignByIds[$item->product_id] = [];
            }
            $clickCampaignByIds[$item->product_id][] = $item;
        }
        $result = [];
        foreach($items as $item) {
            $newItem = $item;
            if (isset($clickCampaignByIds[$item['product_id']])) {
                $newItem['click_campaign_types'] = $clickCampaignByIds[$item['product_id']];
            }
            $result[] = $newItem;
        }
        if (isset($filter['is_export']) && $filter['is_export']) {
            return $result;
        } else {
            $response = array(
                "status" => 'success',
                "products" => $result,
                'pagesCount' => $pagesCount,
                'pageId' => $pageId
            );
            return $response;
        }
    }

    private function buildStatusMerchantFeed($productIds) {
        $productIds = array_unique($productIds);
        $productIds = array_values($productIds);
        $products = $this->productService->find(['ids' => $productIds, 'columns' => 'id,approve_advertising']);
        $statusByIds = [];
        foreach ($products as $product) {
            $statusByIds[$product->id] = $product->approve_advertising;
        }
        return $statusByIds;
    }

    private function getResult($filter, $mode = '') {
        if (isset($filter['account_key']) || isset($filter['campaign_type']) || isset($filter['ad_type']) || isset($filter['campaign_id'])) {
            $items = $this->productToAdvertisingService->find($filter);
            $productIds = [];
            if (is_object($items)) {
                foreach ($items as $item) {
                    $productIds[] = $item->product_id;
                }
            }
            if (!empty($productIds)) {
                $productIds = array_unique($productIds);
                $filter['productIds'] = $productIds;
            } else {
                $filter['productIds'] = ["-1"];
            }
        }
        $filter['with'] = ['ads'];
        $items = $this->productToAdvertisingService->find($filter);
        if ($mode == 'lists') {
            $productIds = [-1];
            foreach ($items as $item) {
                $productIds[] = $item->product_id;
            }
            return $productIds;
        } else {
            return $items;
        }
    }

    private function buildFilterByFeedStatus($filter) {
        if (array_key_exists('feed_status', $filter)) {
            $productIds = $this->getProductByStatusFeed($filter);
            if (isset($filter['productIds']) && count($filter['productIds']) > 0) {
                $newIds = [];
                foreach ($filter['productIds'] as $id) {
                    if (in_array($id, $productIds)) {
                        $newIds[] = $id;
                    }
                }
                $filter['productIds'] = $newIds;
            } else {
                $filter['productIds'] = $productIds;
            }
        }
        return $filter;
    }

    private function getProductByStatusFeed($filter) {
        $productIds = [];
        $isPushFeed = 0;
        if ($filter['feed_status'] == 'feed_up') {
            $isPushFeed = 1;
        }
        $filterFeeds = [
            'is_push_feed' => $isPushFeed,
            'product_ids' => []
        ];
        if (isset($filter['productIds']) && count($filter['productIds']) > 0) {
            $filterFeeds['product_ids'] = $filter['productIds'];
        }
        $products = $this->productInfoService->getProductByFeed($filterFeeds);
        foreach ($products as $item) {
            if (!in_array($item->id, $productIds)) {
                $productIds[] = $item->id;
            }
        }
        if ($isPushFeed) {
            $items = $this->productApproveAdvertisingService->find(['productIds' => $productIds, 'advertising_status' => 1]);
        } else { 
            $items = $this->productApproveAdvertisingService->find(['productIds' => $productIds, 'advertising_status' => 0]);
        }
        $retVal = [];
        foreach($items as $item) {
            $retVal[] = $item->product_id;
        }
        return $retVal;
    }

    private function buildProductCodeByCategory($filter) {
        $productIds = $this->productNCategoryService->getProductIds([$filter['category_id']]);
        $retVal = [-1];
        $items = [];
        if (!empty($productIds)) {
            if (!isset($filter['codes'])) {
                $items = $this->productInfoService->find(['product_ids' => $productIds]);
            } else {
                $items = $this->productInfoService->find(['product_ids' => $productIds, 'skus' => $filter['codes']]);
            }
        }
        if (!empty($items)) {
            $retVal = [];
            foreach ($items as $item) {
                if(!in_array($item->product_id, $retVal)) {
                    $retVal[] = $item->product_id;
                }
            }
        }
        return $retVal;
    }

    private function buildProductCodePendings() {
        $retVal = [];
        $items = $this->productToAdvertisingService->find([]);
        $pendingIds = [];
        foreach($items as $item) {
            if ($item->status == 'pending') {
                $pendingIds[] = $item->product_id;
            }
        }
        $items = $this->productInfoService->find(['product_ids' => $pendingIds, 'colums' => 'sku']);
        foreach($items as $item) {
            $retVal[] = $item->sku;
        }
        return $retVal;
    }

    public function exportExcel(Request $request) {
        set_time_limit(0);
        ini_set('memory_limit', '2048M');
        $filters = $this->buildFilters($request);
        $products = $this->getData($filters, $request);
        $this->exportToExcel($products);
    }

}
