<?php

namespace Modules\Ads\Controllers\Service;

use Illuminate\Http\Request;
use Modules\Ads\Controllers\Service\ProductToAdvertiseBase;
use Modules\Ads\Services\ProductToAdvertisingService;
use Modules\Ads\Services\ProductInfoService;
use Modules\Ads\Services\ProductNCategoryService;
use Modules\Ads\Services\ProductService;
use Modules\Ads\Services\ProductApproveAdvertisingService;
use Modules\Ads\Services\ClickService;
use Modules\Ads\Models\Category;

class ProductToAdvertiseBySku extends ProductToAdvertiseBase
{
    protected $productToAdvertisingService = null;
    protected $productInfoService = null;
    protected $productNCategoryService = null;
    protected $productService = null;
    protected $productApproveAdvertising = null;
    protected $clickService = null;
    protected $pageSize = 20;

    public function __construct(
                                ProductToAdvertisingService $productToAdvertisingService,
                                ProductInfoService $productInfoService,
                                ProductNCategoryService $productNCategoryService,
                                ProductService $productService,
                                ProductApproveAdvertisingService $productApproveAdvertisingService,
                                ClickService $clickService
    )
    {
        $this->productToAdvertisingService = $productToAdvertisingService;
        $this->productInfoService = $productInfoService;
        $this->productNCategoryService = $productNCategoryService;
        $this->productService = $productService;
        $this->productApproveAdvertisingService = $productApproveAdvertisingService;
        $this->clickService = $clickService;
    }

    public function buildCampaignClick($request) {
        $input = $request->all();
        $currentDate = new \DateTime();
        $fromDate = array_key_exists('dateFrom', $input) ? \DateTime::createFromFormat('d/m/Y', $input['dateFrom']) : $currentDate;
        $toDate = array_key_exists('dateTo', $input) ? \DateTime::createFromFormat('d/m/Y', $input['dateTo']) : $currentDate;
        $filters = array();
        $filters['fromDate'] = $fromDate->setTime(0, 0, 0);
        $filters['toDate'] = $toDate->setTime(23,59,59);
        $filters['codes'] = array_key_exists('codes', $input) ? $input['codes'] : [];
        $clickCampaigns = $this->clickService->getClickProductToAdvertise($filters, 'campaign_id');
        $campaignByIds = [];
        foreach($this->campaigns as $item) {
            $campaignByIds[$item['campaign_id']] = $item;
        }
        foreach($clickCampaigns as $item) {
            if (isset($campaignByIds[$item->campaign_id])) {
                $item->campaign = $campaignByIds[$item->campaign_id];
            }
        }
        $response = [
            'status' => 'successful',
            'result' => $clickCampaigns
        ];
        return $response;
    }

    public function getData($filter, $request) {
        if (isset($filter['not_advertising']) && $filter['not_advertising']) {
            $filter['codes'] = $this->buildProductCodePendings();
        }
        if (isset($filter['category_id'])) {
            $filter['codes'] = $this->buildProductCodeByCategory($filter);
        }
        $pageId = $filter['pageId'];
        $pageSize = $filter['pageSize'];
        $clickByCodes = [];
        if (isset($filter['sort']) && !$filter['not_click'] && ($filter['sort'] == 'click_asc' || $filter['sort'] == 'click_desc')) {
            unset($filter['pageId']);
            unset($filter['pageSize']);
            $orderBy = $filter['orders'];
            unset($filter['orders']);
            $filter = $this->buildFilterByFeedStatus($filter);
            $codes = $this->getResult($filter, 'lists');
            $filter['codes'] = $codes;
            $filter['pageSize'] = $pageSize;
            $filter['pageId'] = $pageId;
            $filter['orders'] = $orderBy;
            $result = $this->clickService->getClickProductToAdvertise($filter);
            $codes = [];
            $clickByCodes = [];
            foreach($result as $item) {
                $codes[] = $item->sku;
                $clickByCodes[$item->sku] = $item;
            }
            $filterProductAdvertising = [
                'codes' => $codes
            ];
            $items = $this->getResult($filterProductAdvertising);
            $items = $items->toArray();
            $newItems = [];
            foreach($items as $item) {
                $newItem = $item;
                $newItem['click'] = 0;
                if (isset($clickByCodes[$newItem['sku']])) {
                    $newItem['click'] = $clickByCodes[$item['sku']]->click;
                }
                $newItems[] = (object) $newItem;
            }
            usort($newItems, function($a, $b) {
                return $a->click < $b->click;
            });
            $items = [];
            foreach($newItems as $item) {
                $items[] = (array) $item;
            }
            unset($filter['pageId']);
            unset($filter['pageSize']);
            unset($filter['orders']);
            $pageId = $request->input('page_id', 0);
            $filter['metric'] = "count";
            $adwordsItemCount = $this->clickService->getClickProductToAdvertise($filter);
            unset($filter['metric']);
        } else {
            if ($filter['not_click']) {
                if (!isset($filter['codes'])) {
                    $itemNotClicks = $this->productToAdvertisingService->find(['columns' => 'sku']);
                    $itemNotClickCodes = [];
                    foreach ($itemNotClicks as $item) {
                        $itemNotClickCodes[] = $item->sku;
                    }
                    $filter['codes'] = $itemNotClickCodes;
                }
                $clickFilter = $filter;
                unset($clickFilter['pageId']);
                unset($clickFilter['pageSize']);
                unset($clickFilter['orders']);
                $resultClicks = $this->clickService->getClickProductToAdvertise($clickFilter);
                $codeClicked = [];
                foreach($resultClicks as $item) {
                    $codeClicked[] = $item->sku;
                }
                $newCodes = [];
                foreach ($filter['codes'] as $item) {
                    if (!in_array($item, $codeClicked)) {
                        $newCodes[] = $item;
                    }
                }
                if (!empty($newCodes)) {
                    $filter['codes'] = $newCodes;
                } else {
                    $filter['codes'] = ['-1'];
                }
            }
            if (isset($filter['not_click']) && $filter['not_click'] && isset($filter['campaign_id'])) {
                unset($filter['campaign_id']);
            }
            $filter = $this->buildFilterByFeedStatus($filter);
            unset($filter['orders']);
            $adwordsItem = $this->getResult($filter);
            $items = $adwordsItem->toArray();
            unset($filter['pageId']);
            unset($filter['pageSize']);
            $pageId = $request->input('pageId', 0);
            $filter['metric'] = "count";
            $adwordsItemCount = $this->getResult($filter);
            $codes = [-1];
            foreach($items as $item) {
                $codes[] = $item['sku'];
            }
            unset($filter['metric']);
            $filter['codes'] = $codes;
            $resultClicks = $this->clickService->getClickProductToAdvertise($filter);
            $clickByCodes = [];
            foreach($resultClicks as $item) {
                $clickByCodes[$item->sku] = $item->click;
            }
            $newResults = [];
            foreach($items as $item) {
                $newItem = $item;
                $newItem['click'] = 0;
                if (isset($clickByCodes[$item['sku']])) {
                    $newItem['click'] = $clickByCodes[$item['sku']];
                }
                $newResults[] = $newItem;
            }
            $items = $newResults;
        }
        $pagesCount = $this->clickService->recordsCountToPagesCount($adwordsItemCount, $this->pageSize);
        $items = $this->clearResult($items, $filter);
        $productCodes = [];
        foreach($items as $item) {
            $productCodes[] = $item['sku'];
        }
        $filter['codes'] = $productCodes;
        $statusFeed = $this->buildStatusMerchantFeed($productCodes);
        $newResult = [];
        foreach($items as $item) {
            $newItem = $item;
            $newItem['is_push_merchant_feed'] = 0;
            if (isset($statusFeed[$item['sku']])) {
                $newItem['is_push_merchant_feed'] = $statusFeed[$item['sku']];
            }
            $newResult[] = $newItem;
        }
        $items = $newResult;
        $clickCampaigns = $this->clickService->getClickProductToAdvertise($filter, 'campaign_type');
        $clickCampaignByCode = [];
        foreach($clickCampaigns as $item) {
            if (!array_key_exists($item->sku, $clickCampaignByCode)) {
                $clickCampaignByCode[$item->sku] = [];
            }
            $clickCampaignByCode[$item->sku][] = $item;
        }
        $result = [];
        foreach($items as $item) {
            $newItem = $item;
            if (isset($clickCampaignByCode[$item['sku']])) {
                $newItem['click_campaign_types'] = $clickCampaignByCode[$item['sku']];
            }
            $result[] = $newItem;
        }
        if (isset($filter['is_export']) && $filter['is_export']) {
            return $result;
        } else {
            $response = array(
                "status" => 'success',
                "products" => $result,
                'pagesCount' => $pagesCount,
                'pageId' => $pageId
            );
            return $response;
        }
    }

    private function buildStatusMerchantFeed($productCodes) {
        $productCodes = array_unique($productCodes);
        $productCodes = array_values($productCodes);
        $retVal = [];
        $items = $this->productInfoService->find(['skus' => $productCodes, 'columns' => 'product_id,sku']);
        $itemByProductSkus = [];
        $productIds = [];
        foreach ($items as $item) {
            if (!in_array($item->product_id, $productIds)) {
                $productIds[] = $item->product_id;
            }
            $itemByProductSkus[$item->sku] = $item->product_id;
        }
        $products = $this->productService->find(['ids' => $productIds, 'columns' => 'id,approve_advertising']);
        $statusByIds = [];
        foreach ($products as $product) {
            $statusByIds[$product->id] = $product->approve_advertising;
        }
        foreach($itemByProductSkus as $key => $value) {
            if (isset($statusByIds[$value])) {
                $retVal[$key] = $statusByIds[$value];
            }
        }
        return $retVal;
    }

    private function getResult($filter, $mode = '') {
        if (isset($filter['account_key']) || isset($filter['campaign_type']) || isset($filter['ad_type']) || isset($filter['campaign_id'])) {
            $items = $this->productToAdvertisingService->find($filter);
            $codes = [];
            if (is_object($items)) {
                foreach ($items as $item) {
                    $codes[] = $item->sku;
                }
            }
            if (!empty($codes)) {
                $codes = array_unique($codes);
                $filter['codes'] = $codes;
            } else {
                $filter['codes'] = ["-1"];
            }
        }
        $filter['with'] = ['ads'];
        $items = $this->productToAdvertisingService->find($filter);
        if ($mode == 'lists') {
            $codes = [];
            foreach ($items as $item) {
                $codes[] = $item->sku;
            }
            return $codes;
        } else {
            return $items;
        }
    }

    private function buildFilterByFeedStatus($filter) {
        if (array_key_exists('feed_status', $filter)) {
            $productCodes = $this->getProductByStatusFeed($filter);
            if (isset($filter['codes']) && count($filter['codes']) > 0) {
                $newCodes = [];
                foreach ($filter['codes'] as $code) {
                    if (in_array($code, $productCodes)) {
                        $newCodes[] = $code;
                    }
                }
                $filter['codes'] = $newCodes;
            } else {
                $filter['codes'] = $productCodes;
            }
        }
        return $filter;
    }

    private function getProductByStatusFeed($filter) {
        $codes = [];
        $isPushFeed = 0;
        if ($filter['feed_status'] == 'feed_up') {
            $isPushFeed = 1;
        }
        $filterFeeds = [
            'is_push_feed' => $isPushFeed,
            'codes' => []
        ];
        if (isset($filter['codes']) && count($filter['codes']) > 0) {
            $filterFeeds['codes'] = $filter['codes'];
        } 
        $products = $this->productInfoService->getProductByFeed($filterFeeds);
        foreach ($products as $item) {
            $codes[] = $item->sku;
        }
        if ($isPushFeed) {
            $items = $this->productApproveAdvertisingService->find(['skus' => $codes, 'advertising_status' => 1]);
        } else { 
            $items = $this->productApproveAdvertisingService->find(['skus' => $codes, 'advertising_status' => 0]);
        }
        $retVal = [];
        foreach($items as $item) {
            $retVal[] = $item->code;
        }
        return $retVal;
    }

    private function buildProductCodeByCategory($filter) {
        $productIds = $this->productNCategoryService->getProductIds([$filter['category_id']]);
        $retVal = [-1];
        $items = [];
        if (!empty($productIds)) {
            if (!isset($filter['codes'])) {
                $items = $this->productInfoService->find(['product_ids' => $productIds]);
            } else {
                $items = $this->productInfoService->find(['product_ids' => $productIds, 'skus' => $filter['codes']]);
            }
        }
        if (!empty($items)) {
            $retVal = [];
            foreach ($items as $item) {
                $retVal[] = $item->sku;
            }
        }
        return $retVal;
    }

    private function buildProductCodePendings() {
        $retVal = [];
        $items = $this->productToAdvertisingService->find([]);
        $pendingCodes = [];
        foreach($items as $item) {
            if ($item->status == 'pending') {
                $pendingCodes[] = $item->sku;
            }
        }
        $items = $this->productInfoService->find(['skus' => $pendingCodes, 'is_variant' => 1, 'colums' => 'sku']);
        foreach($items as $item) {
            $retVal[] = $item->sku;
        }
        return $retVal;
    }

    public function exportExcel(Request $request) {
        set_time_limit(0);
        ini_set('memory_limit', '2048M');
        $filters = $this->buildFilters($request);
        $products = $this->getData($filters, $request);
        $this->exportToExcel($products);
    }
}
